/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import starlogo.Application;
import starlogo.Colors;
import starlogo.NShapeChooser;
import starlogo.NShapeEditor;
import starlogo.TurtleShapes;

public class NShapeChooserPanel
extends Component
implements KeyListener,
ImageProducer,
MouseListener {
    public static int LINEWIDTH = 1;
    NShapeChooser chooser;
    int selectedShape;
    String selectedname;
    int tcolmask = Colors.colorarrayints[1760];
    int pcolmask = Colors.colorarrayints[0];
    Image image;
    ImageConsumer ic;
    int[] pixels;
    int width = 273;
    int height = 69;
    int rowbytes = this.width;
    Application app;

    public void refresh() {
        int n = 0;
        while (n < 64) {
            this.drawShape(n);
            ++n;
        }
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    public void refreshShape(int n) {
        this.drawShape(n);
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    public int[] drawShape(int n) {
        int n2 = n % 16;
        int n3 = n / 16;
        int n4 = n2 * (16 + LINEWIDTH) + LINEWIDTH;
        int n5 = n3 * (16 + LINEWIDTH) + LINEWIDTH;
        int n6 = n4 + n5 * this.rowbytes;
        int[] nArray = new int[256];
        int n7 = 0;
        TurtleShapes turtleShapes = TurtleShapes.getShape(n);
        double[] dArray = turtleShapes.getColorsForSize(16)[0];
        int[] nArray2 = turtleShapes.getMasksForSize(16)[0];
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n9 < 16) {
            int n11 = 0;
            while (n11 < 16) {
                n8 = nArray2[2 * n10] == -1 ? this.tcolmask : (nArray2[2 * n10 + 1] == -1 ? this.pcolmask : Colors.colorarrayints[(int)(dArray[n10] * 32.0)]);
                this.pixels[n6 + n11] = n8;
                nArray[n7++] = n8;
                ++n10;
                ++n11;
            }
            n6 += this.rowbytes;
            ++n9;
        }
        return nArray;
    }

    public void drawSquare(int n, boolean bl) {
        int n2 = n % 16;
        int n3 = n / 16;
        int n4 = n2 * 17;
        int n5 = n3 * 17;
        int n6 = n4 + n5 * this.rowbytes;
        int n7 = bl ? Colors.colorarrayints[3360] : Colors.colorarrayints[160];
        int n8 = 0;
        while (n8 < 18) {
            this.pixels[n6 + n8] = n7;
            this.pixels[n6 + this.rowbytes * 17 + n8] = n7;
            ++n8;
        }
        n8 = 0;
        while (n8 < 17) {
            this.pixels[n6 + n8 * this.rowbytes] = n7;
            this.pixels[n6 + n8 * this.rowbytes + 17] = n7;
            ++n8;
        }
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    public void paintComponent(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
    }

    void select(int n) {
        this.drawSquare(this.selectedShape, false);
        this.selectedShape = n;
        this.drawSquare(this.selectedShape, true);
        this.selectedname = TurtleShapes.getShape((int)n).name;
        if (this.selectedname == null) {
            this.selectedname = "shape-" + n;
        }
        this.chooser.updateName("Shape #" + n + ": " + this.selectedname);
        this.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 40) {
            this.select((this.selectedShape + 16) % 64);
        } else if (keyEvent.getKeyCode() == 38) {
            int n = (this.selectedShape + 48) % 64;
            this.select(n);
        } else if (keyEvent.getKeyCode() == 39) {
            int n = (this.selectedShape + 1) % 64;
            this.select(n);
        } else if (keyEvent.getKeyCode() == 37) {
            int n = (this.selectedShape + 63) % 64;
            this.select(n);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.openEditor(this.selectedShape);
        }
    }

    public void openEditor(int n) {
        int n2 = this.chooser.app.sl.cellsize;
        if (n2 < 8) {
            n2 = 8;
        }
        new NShapeEditor(TurtleShapes.getShape(n), n, this.selectedname, n2, this.chooser);
    }

    int eventToShape(MouseEvent mouseEvent) {
        int n = mouseEvent.getX() / 17;
        int n2 = mouseEvent.getY() / 17;
        return n2 * 16 + n;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.eventToShape(mouseEvent);
        if (n < 0 || n >= 64) {
            return;
        }
        this.select(n);
        if (mouseEvent.getClickCount() > 1) {
            this.openEditor(n);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.ic = null;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.pixels, 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (imageConsumer == null) {
            return;
        }
        if (this.ic == null) {
            this.ic = imageConsumer;
            imageConsumer.setColorModel(Colors.cm);
            imageConsumer.setDimensions(this.width, this.height);
        }
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.cm, this.pixels, 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    NShapeChooserPanel(NShapeChooser nShapeChooser, Application application) {
        this.chooser = nShapeChooser;
        this.app = application;
        this.setSize(this.width, this.height);
        this.pixels = new int[this.width * this.height * 64];
        this.image = nShapeChooser.createImage(this);
        this.refresh();
        int n = Colors.colorarrayints[160];
        int n2 = 0;
        int n3 = 0;
        while (n2 < 17) {
            int n4 = 0;
            while (n4 < this.width) {
                this.pixels[n3 + n4] = n;
                ++n4;
            }
            n3 += this.width * 17;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.width) {
            n3 = 0;
            while (n3 < this.pixels.length) {
                this.pixels[n2 + n3] = n;
                n3 += this.width;
            }
            n2 += 17;
        }
        this.selectedShape = 0;
        this.select(this.selectedShape);
        this.addMouseListener(this);
    }
}

