/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Button;
import java.awt.CardLayout;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Observable;
import java.util.Observer;
import starlogo.Application;
import starlogo.ControlCenter;
import starlogo.DoubleInsets;
import starlogo.NControlCenterTextArea;
import starlogo.NSLCommand;
import starlogo.NSLDialog;
import starlogo.NSLMenu;
import starlogo.NSLProc;
import starlogo.Print;
import starlogo.PrintDialog;
import starlogo.PrintingCanceledException;
import starlogo.SLCommand;
import starlogo.SLProc;
import starlogo.StarLogo;
import yoyo.CompoundSymbol;
import yoyo.Context;
import yoyo.Symbol;
import yoyo.YoYo;

public class NControlCenter
extends Frame
implements ControlCenter,
ClipboardOwner {
    public static Font STATUS_FONT;
    static final int minTextHeight = 60;
    Panel[] card = new Panel[2];
    public NSLCommand[] command = new NSLCommand[2];
    public NSLProc[] proc = new NSLProc[2];
    Label[] commandLab = new Label[2];
    Label[] procLab = new Label[2];
    DragPanel[] drag = new DragPanel[2];
    Panel[] cover = new Panel[2];
    Panel tools;
    Label status;
    Button obsBut;
    Button turBut;
    Button cgBut;
    Button stopBut;
    Panel tabs;
    Panel cards;
    CardLayout cl;
    int tabHeight;
    int cur;
    NControlCenterTextArea textFocus;
    Insets insets;
    int width;
    NSLMenu slmenu;
    Cursor defaultCursor = Cursor.getDefaultCursor();
    Resizer resizer;
    public Application app;
    public StarLogo sl;
    ObservableInstance observed = new ObservableInstance();

    void setupText() {
        this.proc[0] = new NSLProc(true, this.sl, this);
        this.proc[1] = new NSLProc(false, this.sl, this);
        this.command[0] = new NSLCommand(0, this.sl, this);
        this.command[1] = new NSLCommand(2, this.sl, this);
    }

    void setupLabels() {
        this.commandLab[0] = new Label(" Turtle Command Center");
        this.commandLab[1] = new Label(" Observer Command Center");
        this.procLab[0] = new Label(" Turtle Procedures");
        this.procLab[1] = new Label(" Observer Procedures");
        this.setupLabelColors();
        this.setupLabelFonts();
        this.status = new StatusLabel();
        NSLDialog.colorControl(this.status);
        this.status.setFont(STATUS_FONT);
    }

    void setupLabelColors() {
        this.commandLab[0].setForeground(Color.white);
        this.commandLab[1].setForeground(Color.white);
        this.procLab[0].setForeground(Color.white);
        this.procLab[1].setForeground(Color.white);
        this.commandLab[0].setBackground(new Color(23, 118, 51));
        this.commandLab[1].setBackground(new Color(92, 61, 36));
        this.procLab[0].setBackground(new Color(23, 118, 51));
        this.procLab[1].setBackground(new Color(92, 61, 36));
    }

    void setupLabelFonts() {
        int n = 0;
        while (n < 2) {
            this.commandLab[n].setFont(NSLDialog.LABEL_FONT);
            this.procLab[n].setFont(NSLDialog.LABEL_FONT);
            ++n;
        }
    }

    void setupTabs() {
        this.tabs = new Panel();
        NSLDialog.colorControl(this.tabs);
        this.tabs.setLayout(new GridLayout(1, 2));
        this.tabs.setFont(NSLDialog.LABEL_FONT);
        this.turBut = new Button("Turtle");
        this.turBut.addActionListener(this);
        NSLDialog.colorControl(this.turBut);
        this.turBut.setFont(NSLDialog.LABEL_FONT);
        this.tabs.add(this.turBut);
        this.obsBut = new Button("Observer");
        this.obsBut.addActionListener(this);
        NSLDialog.colorControl(this.obsBut);
        this.obsBut.setFont(NSLDialog.LABEL_FONT);
        this.tabs.add(this.obsBut);
    }

    void setupTools() {
        this.tools = new Panel(new GridLayout(1, 3));
        NSLDialog.colorControl(this.tools);
        this.tools.add(this.status);
        this.cgBut = new Button("Clear Graphics");
        this.cgBut.addActionListener(this);
        NSLDialog.colorControl(this.cgBut);
        this.cgBut.setFont(NSLDialog.LABEL_FONT);
        this.tools.add(this.cgBut);
        this.stopBut = new Button("Stop All");
        this.stopBut.addActionListener(this);
        NSLDialog.colorControl(this.stopBut);
        this.stopBut.setFont(NSLDialog.LABEL_FONT);
        this.tools.add(this.stopBut);
    }

    void setupDrag() {
        int n = 0;
        while (n < 2) {
            this.cover[n] = new Panel();
            this.cover[n].setBackground(Color.lightGray);
            ++n;
        }
    }

    void setupLayout() {
        this.cards = new Panel();
        this.cl = new CardLayout();
        this.cards.setLayout(this.cl);
        this.setLayout(null);
        this.add(this.tabs);
        this.add(this.cards);
        this.add(this.tools);
        int n = 0;
        while (n < 2) {
            this.card[n] = new Panel();
            this.card[n].setLayout(null);
            this.card[n].add(this.cover[n]);
            this.card[n].add(this.commandLab[n]);
            this.card[n].add(this.command[n]);
            this.card[n].add(this.procLab[n]);
            this.card[n].add(this.proc[n]);
            this.cards.add((Component)this.card[n], String.valueOf(n));
            ++n;
        }
    }

    public SLCommand getSLCommand(int n) {
        return this.command[n];
    }

    public SLProc getSLProc(int n) {
        return this.proc[n];
    }

    public void setObsProcs(Object[] objectArray, Integer[] integerArray) {
        this.proc[1].setProcs(objectArray, integerArray);
    }

    public void setTurProcs(Object[] objectArray, Integer[] integerArray) {
        this.proc[0].setProcs(objectArray, integerArray);
    }

    public void clearProcs() {
        this.proc[1].clearUfuns();
        this.proc[0].clearUfuns();
    }

    public boolean lookupUfun(String string, int n) {
        switch (n) {
            case 1: {
                return this.proc[1].lookupUfun(string);
            }
            case 0: {
                return this.proc[0].lookupUfun(string);
            }
        }
        return false;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.validate();
    }

    void setupKeyTrackers() {
        ControlKeyAdapter controlKeyAdapter = new ControlKeyAdapter(this);
        this.turBut.addKeyListener(controlKeyAdapter);
        this.obsBut.addKeyListener(controlKeyAdapter);
        this.cgBut.addKeyListener(controlKeyAdapter);
        this.stopBut.addKeyListener(controlKeyAdapter);
        this.addKeyListener(controlKeyAdapter);
    }

    void setupFocusTrackers() {
        this.textFocus = this.command[0];
        this.cur = 0;
    }

    void setupCursorTrackers() {
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(this){
            private final /* synthetic */ NControlCenter this$0;

            public final void mouseMoved(MouseEvent mouseEvent) {
                if (this.this$0.getCursor() != this.this$0.defaultCursor) {
                    this.this$0.setCursor(this.this$0.defaultCursor);
                }
            }
            {
                this.this$0 = nControlCenter;
                this.constructor$0(nControlCenter);
            }

            private final void constructor$0(NControlCenter nControlCenter) {
            }
        };
        int n = 0;
        while (n < 2) {
            this.commandLab[n].addMouseMotionListener(mouseMotionAdapter);
            this.command[n].addMouseMotionListener(mouseMotionAdapter);
            this.procLab[n].addMouseMotionListener(mouseMotionAdapter);
            this.proc[n].addMouseMotionListener(mouseMotionAdapter);
            ++n;
        }
    }

    void init() {
        this.slmenu = new NSLMenu(this, this.app);
        this.slmenu.setMenuBar(this);
        this.addNotify();
        this.scaleToWindow();
        this.setupPositions();
        this.cl.show(this.cards, String.valueOf(0));
        this.setupKeyTrackers();
        this.setupFocusTrackers();
        this.resizer = new Resizer();
        this.addComponentListener(this.resizer);
    }

    void scaleToWindow() {
        this.insets = this.getInsets();
        this.width = this.getSize().width - this.insets.left - this.insets.right;
        Font font = this.tabs.getFont();
        FontMetrics fontMetrics = this.tabs.getFontMetrics(font);
        this.tabHeight = fontMetrics.getHeight() + 5;
        this.tabs.setLocation(this.insets.left, this.insets.top);
        this.tabs.setSize(this.width, this.tabHeight);
        int n = this.tools.getPreferredSize().height;
        this.tools.setLocation(this.insets.left, this.getSize().height - this.insets.bottom - n);
        this.tools.setSize(this.width, n);
        Point point = new Point(this.insets.left, this.insets.top + this.tabHeight);
        Dimension dimension = new Dimension(this.width, this.getSize().height - this.insets.top - this.insets.bottom - this.tabHeight - n);
        this.cards.setSize(dimension);
        this.cards.setLocation(point);
    }

    void setupPositions() {
        Dimension dimension = this.cards.getSize();
        int n = 0;
        while (n < 2) {
            this.card[n].setLocation(0, 0);
            this.card[n].setSize(dimension);
            this.cover[n].setLocation(0, dimension.height / 3 - 4);
            this.cover[n].setSize(dimension.width, 4);
            this.commandLab[n].setLocation(0, 0);
            this.commandLab[n].setSize(dimension.width, this.tabHeight);
            this.command[n].setLocation(0, this.tabHeight);
            this.command[n].setSize(this.width, dimension.height / 3 - this.tabHeight - 4);
            this.procLab[n].setLocation(0, dimension.height / 3);
            this.procLab[n].setSize(dimension.width, this.tabHeight);
            this.proc[n].setLocation(0, dimension.height / 3 + this.tabHeight);
            this.proc[n].setSize(dimension.width, dimension.height / 3 * 2 - this.tabHeight + 1);
            ++n;
        }
    }

    public void update(Graphics graphics) {
        ((Container)this).paint(graphics);
    }

    public NControlCenterTextArea getTextFocus() {
        return this.textFocus;
    }

    int clipShift(int n, int n2) {
        int n3 = this.command[n].getSize().height;
        int n4 = this.proc[n].getSize().height;
        if (n3 <= 60 && n2 < 0 || n4 <= 60 && n2 > 0) {
            return 0;
        }
        if (n3 + n2 < 60) {
            return 60 - n3;
        }
        if (n4 - n2 < 60) {
            return n4 - 60;
        }
        return n2;
    }

    void arrange(int n, int n2) {
        this.command[n].setSize(this.command[n].getSize().width, this.command[n].getSize().height + n2);
        this.cover[n].setLocation(this.cover[n].getLocation().x, this.cover[n].getLocation().y + n2);
        this.procLab[n].setLocation(this.procLab[n].getLocation().x, this.procLab[n].getLocation().y + n2);
        this.proc[n].setLocation(this.proc[n].getLocation().x, this.proc[n].getLocation().y + n2);
        this.proc[n].setSize(this.proc[n].getSize().width, this.proc[n].getSize().height - n2);
        this.repaint();
    }

    public void doResize() {
        this.resizer.doResize();
    }

    public int getCCHeight(int n) {
        return this.command[n].getSize().height;
    }

    public void setCCHeight(int n, int n2) {
        int n3 = n2 - this.command[n].getSize().height;
        n3 = this.clipShift(n, n3);
        this.arrange(n, n3);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
        String string = checkboxMenuItem.getLabel();
        if (string.equals("Show Spaces") || string.equals("Muestre Espacios")) {
            SLProc sLProc;
            int n = 9679;
            sLProc.setShowSpaces(!(sLProc = this.getSLProc(this.cur)).showSpacesp());
            return;
        }
        try {
            int n = Integer.parseInt(string);
            Font font = this.getSLProc(0).getFont();
            this.setFont(new Font(font.getName(), font.getStyle(), n));
            this.slmenu.setCurrentSize(checkboxMenuItem);
            return;
        }
        catch (Exception exception) {
            Font font = this.getSLProc(0).getFont();
            this.setFont(new Font(string, font.getStyle(), font.getSize()));
            this.slmenu.setCurrentFont(checkboxMenuItem);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof MenuItem) {
            this.actionPerformedOnMenuItem((MenuItem)object);
        } else if (object instanceof Button) {
            this.actionPerformedOnButton((Button)object);
        }
    }

    public void actionPerformedOnMenuItem(MenuItem menuItem) {
        String string = menuItem.getLabel();
        TextArea textArea = (TextArea)((Object)this.getTextFocus());
        if (string.equals("Cut")) {
            String string2 = textArea.getSelectedText();
            if (string2.equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string2);
            this.app.clip.setContents(stringSelection, this);
            int n = textArea.getSelectionStart();
            textArea.replaceRange("", n, textArea.getSelectionEnd());
            textArea.select(n, n);
            if (textArea == this.proc[0] || textArea == this.proc[1]) {
                this.app.rancompilerp = false;
                this.app.project.markChanged();
            }
            return;
        }
        if (string.equals("Copy")) {
            String string3 = textArea.getSelectedText();
            if (string3.equals("")) {
                return;
            }
            StringSelection stringSelection = new StringSelection(string3);
            this.app.clip.setContents(stringSelection, this);
            return;
        }
        if (string.equals("Paste")) {
            Transferable transferable = this.app.clip.getContents(this);
            if (transferable != null) {
                try {
                    Object object = transferable.getTransferData(DataFlavor.stringFlavor);
                    if (object instanceof String) {
                        String string4 = (String)object;
                        int n = string4.length();
                        int n2 = textArea.getCaretPosition();
                        if (n == 0) {
                            textArea.insert(string4, n2);
                            textArea.select(n2 + n, n2 + n);
                        } else {
                            int n3 = textArea.getSelectionStart();
                            textArea.replaceRange(string4, n3, textArea.getSelectionEnd());
                            textArea.select(n3 + n, n3 + n);
                        }
                    }
                    if (textArea == this.proc[0] || textArea == this.proc[1]) {
                        this.app.rancompilerp = false;
                        this.app.project.markChanged();
                    }
                }
                catch (IOException iOException) {
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return;
        }
        if (string.equals("Select All")) {
            textArea.selectAll();
            return;
        }
        if (string.equals("Clear")) {
            textArea.setText("");
            if (textArea == this.proc[0] || textArea == this.proc[1]) {
                this.app.rancompilerp = false;
                this.app.project.markChanged();
            }
        }
    }

    public void actionPerformedOnButton(Button button) {
        String string = button.getLabel();
        if (string.equals("Clear Graphics")) {
            Object object = this.sl.runningp;
            synchronized (object) {
                this.sl.CG();
                this.sl.redraw();
            }
            this.textFocus.requestFocus();
            return;
        }
        if (string.equals("Stop All")) {
            Object object = this.sl.runningp;
            synchronized (object) {
                this.sl.stopAll();
            }
            this.textFocus.requestFocus();
            return;
        }
        if (string.equals("Turtle") && this.cur == 0 || string.equals("Observer") && this.cur == 1) {
            this.textFocus.requestFocus();
            return;
        }
        this.textFocus = this.textFocus instanceof SLCommand ? this.command[this.cur == 1 ? 0 : 1] : this.proc[this.cur == 1 ? 0 : 1];
        if (string.equals("Turtle")) {
            this.cur = 0;
        } else if (string.equals("Observer")) {
            this.cur = 1;
        }
        this.cl.show(this.cards, String.valueOf(this.cur));
        this.textFocus.requestFocus();
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void turtlePrint(String string) {
        this.getSLCommand(0).print(string);
    }

    public void observerPrint(String string) {
        this.getSLCommand(1).print(string);
    }

    public void turtlePrintln(String string) {
        this.getSLCommand(0).println(string);
    }

    public void observerPrintln(String string) {
        this.getSLCommand(1).println(string);
    }

    public void observerClearText() {
        this.getSLProc(1).setText("");
    }

    public void turtleClearText() {
        this.getSLProc(0).setText("");
    }

    public void flush() {
        this.getSLCommand(1).flush();
        this.getSLCommand(0).flush();
    }

    public void observerClearCC() {
        this.getSLCommand(1).callerClearText();
    }

    public void turtleClearCC() {
        this.getSLCommand(0).callerClearText();
    }

    public void clearText() {
        this.observerClearText();
        this.turtleClearText();
    }

    public void reset() {
        this.deleteObservers();
        this.clearText();
    }

    public void resetText(String string) {
        int n;
        int n2;
        String string2 = "`turtle`";
        String string3 = "`observer`";
        int n3 = string.indexOf(string2) + string2.length();
        int n4 = string.indexOf("`", n3);
        if (n4 == -1) {
            n4 = string.length();
        }
        if ((n2 = string.indexOf("`", n = string.indexOf(string3) + string3.length())) == -1) {
            n2 = string.length();
        }
        String string4 = string.substring(n3, n4).trim();
        String string5 = string.substring(n, n2).trim();
        this.getSLProc(0).setText(this.processString(string4, "\n"));
        this.getSLProc(1).setText(this.processString(string5, "\n"));
    }

    public String processString(String string, String string2) {
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(string));
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (true) {
                String string3;
                if ((string3 = lineNumberReader.readLine()) == null) {
                    return stringBuffer.toString();
                }
                stringBuffer.append(string3);
                stringBuffer.append(string2);
            }
        }
        catch (IOException iOException) {
            this.app.err.println("shit");
            return "Error reading file\n";
        }
    }

    public void compileText(String string) {
        Object object = this.sl.runningp;
        synchronized (object) {
            this.sl.stopAll();
        }
        this.getSLProc(1).clearUfuns();
        this.getSLProc(0).clearUfuns();
        Object[] objectArray = new Object[]{Symbol.lookup("compiler"), Symbol.lookup("read-code")};
        Object[] objectArray2 = new Object[]{new CompoundSymbol(objectArray), this.getSLProc(1).getText(), this.getSLProc(0).getText(), string, this};
        this.app.cc.enqueue(objectArray2, this.app.message, this.app.err, this);
    }

    public String getSaveString() {
        return "`turtle`\r\n" + this.processString(this.getSLProc(0).getText().trim(), "\r\n") + "\r\n\r\n`observer`\r\n" + this.processString(this.getSLProc(1).getText().trim(), "\r\n");
    }

    public void setFont(Font font) {
        if (this.getSLProc(1) != null) {
            int n = 0;
            while (n < 2) {
                this.getSLProc(n).setFont(font);
                this.getSLCommand(n).setFont(font);
                ++n;
            }
        }
    }

    public void addObserver(Observer observer) {
        this.observed.addObserver(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observed.deleteObserver(observer);
    }

    public void deleteObservers() {
        this.observed.deleteObservers();
    }

    public void done(Context context) {
        this.observed.doChanged();
    }

    public void displayOneString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error", string, true);
    }

    public void displayAString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error", string, true);
    }

    public void print() {
        try {
            Font font = NSLProc.PROC_FONT;
            PrintDialog printDialog = Application.createPrintDialog(this, true, true, false, true);
            printDialog.show();
            if (printDialog.canceledp()) {
                return;
            }
            DoubleInsets doubleInsets = printDialog.getMargins();
            Print print = new Print(this, "Command Center Window", printDialog.getOrientation(), doubleInsets.top, doubleInsets.bottom, doubleInsets.left, doubleInsets.right, printDialog.getResIndependent());
            printDialog.dispose();
            print.displayPrintingMessage(true);
            print.printText("Observer Commands\n\n", font, true);
            print.printText(this.command[1].getText(), font, true);
            print.printText("\n\nObserver Procedures\n\n", font, true);
            print.printText(this.proc[1].getText(), font, true);
            print.printText("\n\nTurtle Commands\n\n", font, true);
            print.printText(this.command[0].getText(), font, true);
            print.printText("\n\nTurtle Procedures\n\n", font, true);
            print.printText(this.proc[0].getText(), font, true);
            print.print();
        }
        catch (PrintingCanceledException printingCanceledException) {
            // empty catch block
        }
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    public NControlCenter(Application application) {
        super("Control Center");
        this.app = application;
        this.sl = application.sl;
        application.registerCloser(this);
        application.registerFrameTracker(this);
        ((Component)this).setLocation(0, 85);
        ((Component)this).setSize(285, 396);
        this.setupText();
        this.setupLabels();
        this.setupTabs();
        this.setupTools();
        this.setupDrag();
        this.setupLayout();
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            STATUS_FONT = NSLDialog.LABEL_FONT;
            if (YoYo.macintoshp) {
                STATUS_FONT = Font.getFont("starlogo.status-line.font", STATUS_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class StatusLabel
    extends Label {
        public Dimension getPreferredSize() {
            return new Dimension(super.getPreferredSize().width, this.getFontMetrics(this.getFont()).getHeight() + 5);
        }

        StatusLabel() throws RuntimeException {
        }
    }

    class ControlKeyAdapter
    extends KeyAdapter {
        NControlCenter parent;

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\t' && keyEvent.isControlDown()) {
                NControlCenter.this.actionPerformedOnButton(NControlCenter.this.cur == 0 ? NControlCenter.this.obsBut : NControlCenter.this.turBut);
                keyEvent.consume();
                return;
            }
            if (YoYo.macintoshp && keyEvent.isMetaDown() && keyEvent.getKeyChar() == '.') {
                Object object = this.parent.sl.runningp;
                synchronized (object) {
                    this.parent.sl.stopAll();
                }
                return;
            }
            if (!YoYo.macintoshp && keyEvent.isControlDown() && keyEvent.getKeyChar() == 'c') {
                Object object = this.parent.sl.runningp;
                synchronized (object) {
                    this.parent.sl.stopAll();
                }
                return;
            }
        }

        ControlKeyAdapter(NControlCenter nControlCenter2) {
            this.parent = nControlCenter2;
        }
    }

    class Resizer
    extends ComponentAdapter {
        public void componentResized(ComponentEvent componentEvent) {
            this.doResize();
        }

        public void doResize() {
            if (NControlCenter.this.getInsets().top != NControlCenter.this.insets.top) {
                NControlCenter.this.scaleToWindow();
            }
            this.setWindowSize();
            this.scaleComponents(0);
            this.scaleComponents(1);
            this.rearrange(0);
            this.rearrange(1);
        }

        void setWindowSize() {
            int n = NControlCenter.this.commandLab[NControlCenter.this.cur].getSize().height + NControlCenter.this.procLab[NControlCenter.this.cur].getSize().height + 120 + NControlCenter.this.insets.top + NControlCenter.this.insets.bottom + NControlCenter.this.tabs.getSize().height + NControlCenter.this.tools.getSize().height;
            if (NControlCenter.this.getSize().height < n) {
                ((Component)NControlCenter.this).setSize(NControlCenter.this.getSize().width, n);
            }
        }

        void scaleComponents(int n) {
            Dimension dimension = new Dimension(NControlCenter.this.getSize().width - NControlCenter.this.insets.right - NControlCenter.this.insets.left, NControlCenter.this.getSize().height - NControlCenter.this.insets.top - NControlCenter.this.insets.bottom - NControlCenter.this.tabs.getSize().height - NControlCenter.this.tools.getSize().height);
            NControlCenter.this.cards.setSize(dimension);
            NControlCenter.this.card[0].setSize(dimension);
            NControlCenter.this.card[1].setSize(dimension);
            int n2 = NControlCenter.this.command[n].getSize().height;
            int n3 = NControlCenter.this.proc[n].getSize().height;
            NControlCenter.this.width = dimension.width;
            int n4 = dimension.height - (NControlCenter.this.commandLab[n].getSize().height + n2 + NControlCenter.this.procLab[n].getSize().height + n3);
            int n5 = n4 * n2 / (n2 + n3);
            NControlCenter.this.tabs.setSize(NControlCenter.this.width, NControlCenter.this.tabs.getSize().height);
            NControlCenter.this.tabs.doLayout();
            NControlCenter.this.tools.setLocation(NControlCenter.this.insets.left, NControlCenter.this.getSize().height - NControlCenter.this.tools.getSize().height - NControlCenter.this.insets.bottom);
            NControlCenter.this.tools.setSize(NControlCenter.this.width, NControlCenter.this.tools.getSize().height);
            NControlCenter.this.tools.doLayout();
            NControlCenter.this.commandLab[n].setSize(NControlCenter.this.width, NControlCenter.this.commandLab[n].getSize().height);
            NControlCenter.this.command[n].setSize(NControlCenter.this.width, n2 + n5);
            NControlCenter.this.cover[n].setSize(NControlCenter.this.width, NControlCenter.this.cover[n].getSize().height);
            NControlCenter.this.cover[n].setLocation(0, NControlCenter.this.cover[n].getLocation().y + n5);
            NControlCenter.this.procLab[n].setSize(NControlCenter.this.width, NControlCenter.this.procLab[n].getSize().height);
            NControlCenter.this.procLab[n].setLocation(0, NControlCenter.this.procLab[n].getLocation().y + n5);
            NControlCenter.this.proc[n].setLocation(0, NControlCenter.this.proc[n].getLocation().y + n5);
            NControlCenter.this.proc[n].setSize(NControlCenter.this.width, dimension.height - NControlCenter.this.proc[n].getLocation().y + 1);
        }

        void rearrange(int n) {
            if (NControlCenter.this.command[n].getSize().height < 60) {
                NControlCenter.this.drag[n].setLocation(NControlCenter.this.drag[n].getLocation().x, NControlCenter.this.drag[n].getLocation().y + 60 - NControlCenter.this.command[n].getSize().height);
                NControlCenter.this.arrange(n, 60 - NControlCenter.this.command[n].getSize().height);
            }
            if (NControlCenter.this.proc[n].getSize().height < 60) {
                NControlCenter.this.drag[n].setLocation(NControlCenter.this.drag[n].getLocation().x, NControlCenter.this.drag[n].getLocation().y + NControlCenter.this.proc[n].getSize().height - 60);
                NControlCenter.this.arrange(n, NControlCenter.this.proc[n].getSize().height - 60);
            }
        }

        Resizer() {
        }
    }

    class DragPanel
    extends Panel {
        NControlCenter parent;
        int oldY;
        int yHandle;
        boolean dragging = false;
        Cursor resizeCursor = Cursor.getPredefinedCursor(9);

        public DragPanel(NControlCenter nControlCenter2) {
            this.parent = nControlCenter2;
            this.addMouseListener(new DragMouseListener());
            this.addMouseMotionListener(new DragMouseMotionListener());
            this.setBackground(Color.white);
        }

        class DragMouseListener
        extends MouseAdapter {
            public void mousePressed(MouseEvent mouseEvent) {
                DragPanel.this.oldY = mouseEvent.getY();
                DragPanel.this.yHandle = mouseEvent.getY() - DragPanel.this.getLocation().y;
                DragPanel.this.setVisible(false);
                DragPanel.this.dragging = true;
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (DragPanel.this.dragging) {
                    DragPanel.this.setLocation(DragPanel.this.getLocation().x, DragPanel.this.oldY + DragPanel.this.parent.clipShift(DragPanel.this.parent.cur, mouseEvent.getY() - DragPanel.this.oldY) - DragPanel.this.yHandle);
                    DragPanel.this.setVisible(true);
                    DragPanel.this.parent.setCursor(Cursor.getDefaultCursor());
                    DragPanel.this.dragging = false;
                }
            }

            DragMouseListener() {
            }
        }

        class DragMouseMotionListener
        implements MouseMotionListener {
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!DragPanel.this.parent.getCursor().equals(DragPanel.this.resizeCursor)) {
                    DragPanel.this.parent.setCursor(DragPanel.this.resizeCursor);
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                if (DragPanel.this.dragging && (n = DragPanel.this.parent.clipShift(DragPanel.this.parent.cur, mouseEvent.getY() - DragPanel.this.oldY)) != 0) {
                    DragPanel.this.parent.arrange(DragPanel.this.parent.cur, n);
                    DragPanel.this.oldY += n;
                }
            }

            DragMouseMotionListener() {
            }
        }
    }

    protected class ObservableInstance
    extends Observable {
        public void doChanged() {
            this.setChanged();
        }

        ObservableInstance() {
        }
    }
}

