/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import starlogo.Application;
import starlogo.ButtonDialog;
import starlogo.ButtonWidget;
import starlogo.NSLDialog;
import starlogo.NWidgetDialog;
import starlogo.ToolTipWidget;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.YoYo;

final class NButtonDialog
extends NWidgetDialog
implements ButtonDialog,
FocusListener {
    private static NButtonDialog dialog;
    private CheckboxGroup commandGroup;
    private CheckboxGroup nameGroup;
    private Checkbox turCheck;
    private Checkbox obsCheck;
    private Checkbox foreverCheck;
    private Checkbox instCheck;
    private Checkbox nameCheck;
    private Label nameLab;
    private Label instLab;
    private Panel commandPanel;
    private Panel namePanel;
    private Panel butPanel;
    private Panel namefieldPanel;
    private Panel instructionfieldPanel;
    private TextField commandText;
    private TextField nameText;
    private Label descriptLab;
    private TextArea descriptText;
    private String descript;
    public boolean shortcuts = true;

    public static final NButtonDialog create(Frame frame, String string) {
        if (dialog == null) {
            dialog = new NButtonDialog(frame, string);
        } else {
            dialog.setTitle(string);
        }
        dialog.addNotify();
        dialog.setFields("", "button" + ButtonWidget.idCount, true, false, false, "");
        return dialog;
    }

    public static final NButtonDialog create(Frame frame, String string, WidgetDrag widgetDrag) {
        ButtonWidget buttonWidget = (ButtonWidget)widgetDrag;
        if (dialog == null) {
            dialog = new NButtonDialog(frame, string);
        } else {
            dialog.setTitle(string);
        }
        dialog.addNotify();
        dialog.setFields(buttonWidget.command, buttonWidget.name, buttonWidget.turtlep, buttonWidget.forever, buttonWidget.showName, buttonWidget.getToolText());
        return dialog;
    }

    private final void setFields(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        this.commandText.setText(string);
        this.commandText.setSelectionStart(0);
        this.commandText.setSelectionEnd(string.length());
        this.nameText.setText(string2);
        this.nameText.setCaretPosition(0);
        this.descriptText.setText(string3);
        this.descriptText.setCaretPosition(0);
        if (bl) {
            this.turCheck.setState(true);
        } else {
            this.obsCheck.setState(true);
        }
        this.foreverCheck.setState(bl2);
        if (bl3) {
            this.nameCheck.setState(true);
        } else {
            this.instCheck.setState(true);
        }
    }

    protected final void setupComponents() {
        if (YoYo.language == 0) {
            this.nameLab = new Label("Name:");
            this.instLab = new Label("StarLogo Instruction:");
            this.nameText = new TextField(15);
            this.commandText = new TextField(30);
            this.descriptLab = new Label("Tooltip:");
            this.descriptText = new TextArea("", 3, 40);
            this.foreverCheck = new Checkbox("Forever");
            this.butPanel = new Panel(new GridLayout(1, 2, 5, 0));
            this.butPanel.add(this.bca);
            this.butPanel.add(this.bok);
            this.commandGroup = new CheckboxGroup();
            this.commandPanel = new Panel(new GridLayout(2, 1, 5, 0));
            this.turCheck = new Checkbox("Turtle", true, this.commandGroup);
            this.obsCheck = new Checkbox("Observer", false, this.commandGroup);
            this.commandPanel.add(this.turCheck);
            this.commandPanel.add(this.obsCheck);
            this.nameGroup = new CheckboxGroup();
            this.namePanel = new Panel(new GridLayout(2, 1, 5, 0));
            this.instCheck = new Checkbox("Show Instruction", true, this.nameGroup);
            this.nameCheck = new Checkbox("Show Name", false, this.nameGroup);
            this.namePanel.add(this.nameCheck);
            this.namePanel.add(this.instCheck);
        }
        if (YoYo.language == 1) {
            this.nameLab = new Label("Nombre:");
            this.instLab = new Label("Instrucci\u00f3n de StarLogo:");
            this.nameText = new TextField(15);
            this.commandText = new TextField(30);
            this.descriptLab = new Label("Descripci\u00f3n:");
            this.descriptText = new TextArea("", 3, 40);
            this.foreverCheck = new Checkbox("Siempre");
            this.butPanel = new Panel(new GridLayout(1, 2, 5, 0));
            this.butPanel.add(this.bca);
            this.butPanel.add(this.bok);
            this.commandGroup = new CheckboxGroup();
            this.commandPanel = new Panel(new GridLayout(2, 1, 5, 0));
            this.turCheck = new Checkbox("Tortuga", true, this.commandGroup);
            this.obsCheck = new Checkbox("Observador", false, this.commandGroup);
            this.commandPanel.add(this.turCheck);
            this.commandPanel.add(this.obsCheck);
            this.nameGroup = new CheckboxGroup();
            this.namePanel = new Panel(new GridLayout(2, 1, 5, 0));
            this.instCheck = new Checkbox("Muestre Instrucci\u00f3n", true, this.nameGroup);
            this.nameCheck = new Checkbox("Muestre Nombre", false, this.nameGroup);
            this.namePanel.add(this.nameCheck);
            this.namePanel.add(this.instCheck);
        }
        NSLDialog.formatText(this.commandText);
        NSLDialog.formatText(this.nameText);
        NSLDialog.formatLabel(this.nameLab);
        NSLDialog.formatLabel(this.instLab);
        NSLDialog.formatLabel(this.commandPanel);
        NSLDialog.formatLabel(this.turCheck);
        NSLDialog.formatLabel(this.obsCheck);
        NSLDialog.formatLabel(this.namePanel);
        NSLDialog.formatLabel(this.foreverCheck);
        NSLDialog.formatLabel(this.instCheck);
        NSLDialog.formatLabel(this.nameCheck);
        NSLDialog.formatLabel(this.butPanel);
        NSLDialog.formatLabel(this.bca);
        NSLDialog.formatLabel(this.bok);
        NSLDialog.formatText(this.descriptText);
        NSLDialog.formatLabel(this.descriptLab);
    }

    protected final void setupGBC() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.add((Component)this.nameLab, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weighty = 20.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 13, 0, 0);
        this.add((Component)this.nameText, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.add((Component)this.instLab, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 20.0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.add((Component)this.commandText, gridBagConstraints);
        gridBagConstraints.ipady = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(6, 13, 0, 0);
        this.add((Component)this.descriptLab, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weighty = 20.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 13, 0, 13);
        this.add((Component)this.descriptText, gridBagConstraints);
        gridBagConstraints.weighty = 20.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(YoYo.macintoshp ? 13 : 6, 0, 0, 13);
        this.add((Component)this.namePanel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(YoYo.macintoshp ? 13 : 6, 0, 0, 13);
        this.add((Component)this.commandPanel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(YoYo.macintoshp ? 13 : 6, 0, 0, 13);
        this.add((Component)this.foreverCheck, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(13, 13, 13, 13);
        this.add((Component)this.butPanel, gridBagConstraints);
    }

    protected final void setupPosition() {
        ((Component)this).setSize(400, YoYo.linuxp ? 270 : (YoYo.pcp ? 260 : 250));
        this.initLocation();
    }

    protected final boolean valid_inputs() {
        if (this.nameText.getText().trim().equals("")) {
            Application.createMessageDialog(this.parent, "Warning", "Sorry, you must specify a name.", false);
            return false;
        }
        if (this.commandText.getText().trim().equals("")) {
            Application.createMessageDialog(this.parent, "Warning", "Sorry, you must specify an instruction.", false);
            return false;
        }
        return true;
    }

    public final void getValues(WidgetDrag widgetDrag) {
        ButtonWidget buttonWidget = (ButtonWidget)widgetDrag;
        buttonWidget.command = this.commandText.getText();
        buttonWidget.name = this.nameText.getText();
        buttonWidget.forever = this.foreverCheck.getState();
        buttonWidget.showName = this.nameCheck.getState();
        buttonWidget.font = WidgetLite.WIDGET_FONT;
        buttonWidget.turtlep = this.getObserverp();
        if (!ToolTipWidget.empty(this.descriptText.getText())) {
            buttonWidget.setToolTip(new ToolTipWidget(buttonWidget.parent, this.descriptText.getText()));
        } else {
            buttonWidget.removeToolTip();
        }
    }

    private final boolean getObserverp() {
        return !this.commandGroup.getSelectedCheckbox().getLabel().equals("Observer");
    }

    public final void focusGained(FocusEvent focusEvent) {
        this.shortcuts = false;
    }

    public final void focusLost(FocusEvent focusEvent) {
        this.shortcuts = true;
    }

    public final boolean shortcutsOn() {
        return this.shortcuts;
    }

    private NButtonDialog(Frame frame, String string) {
        super(frame, string);
        this.init();
        this.initFocus(this.commandText);
        this.descriptText.addFocusListener(this);
        this.pack();
    }
}

