/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.util.Vector;
import starlogo.Colors;
import starlogo.ExtraInfo;
import starlogo.Utilities;

public class LineSet {
    public static final int NUM = 10;
    public static double DELAY = 0.5;
    public int id;
    public String name;
    public String inst;
    public ExtraInfo ei;
    public boolean displayed;
    public double starlogocolor;
    public Color color;
    public int row;
    public int col;
    public boolean xyOn = false;
    public String instx = null;
    public ExtraInfo eix = null;
    public int type = -1;
    public int order;

    public String getCommandToCompile() {
        if (this.displayed && !this.inst.equals("")) {
            String string = "";
            string = !this.xyOn ? (this.type == 2 ? " " + this.inst + " " : "%ptolemy-plot " + this.order + " " + this.id + " (" + this.inst + ") ") : (this.type == 3 ? this.inst + this.instx : "%ptolemy-plotxy " + this.order + " " + this.id + " (" + this.inst + ") (" + this.instx + ") ");
            return string;
        }
        return "";
    }

    public static Vector loadLineSets(Vector vector) {
        Vector<LineSet> vector2 = new Vector<LineSet>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        block0: while (n < vector.size()) {
            String string = vector.elementAt(n).toString();
            if (string.equals("lineset-id")) {
                n2 = n;
                int n4 = Integer.parseInt(vector.elementAt(n + 1).toString());
                ++n;
                while (n < vector.size()) {
                    String string2 = vector.elementAt(n).toString();
                    if (string2.equals("lineset-end") && Integer.parseInt(vector.elementAt(n + 1).toString()) == n4) {
                        n3 = n + 2;
                        vector2.addElement(LineSet.load(vector, n2, n3));
                        n = n3;
                        continue block0;
                    }
                    ++n;
                }
                continue;
            }
            ++n;
        }
        return vector2;
    }

    public static LineSet load(Vector vector, int n, int n2) {
        int n3 = n;
        String string = "<name>";
        String string2 = "";
        String string3 = "";
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        boolean bl = false;
        boolean bl2 = false;
        ExtraInfo extraInfo = null;
        ExtraInfo extraInfo2 = null;
        while (n3 < n2) {
            String string4;
            String string5 = vector.elementAt(n3).toString();
            if (string5.equals("lineset-id")) {
                string4 = vector.elementAt(n3 + 1).toString();
                n4 = Integer.parseInt(string4);
                n3 += 2;
                continue;
            }
            if (string5.equals("lineset-name")) {
                string = vector.elementAt(n3 + 1).toString();
                n3 += 2;
                continue;
            }
            if (string5.equals("lineset-order")) {
                string4 = vector.elementAt(n3 + 1).toString();
                n5 = Integer.parseInt(string4);
                n3 += 2;
                continue;
            }
            if (string5.equals("lineset-type")) {
                string4 = vector.elementAt(n3 + 1).toString();
                n6 = Integer.parseInt(string4);
                n3 += 2;
                continue;
            }
            if (string5.equals("lineset-color")) {
                string4 = vector.elementAt(n3 + 1).toString();
                n7 = Integer.parseInt(string4);
                n3 += 2;
                continue;
            }
            if (string5.equals("lineset-displayed?")) {
                bl = vector.elementAt(n3 + 1).toString().equals("true");
                n3 += 2;
                continue;
            }
            if (string5.equals("lineset-instruction")) {
                string2 = vector.elementAt(n3 + 1).toString();
                n3 += 2;
                continue;
            }
            if (string5.equals("lineset-xy?")) {
                bl2 = vector.elementAt(n3 + 1).toString().equals("true");
                n3 += 2;
                continue;
            }
            if (string5.equals("lineset-xy-instruction")) {
                string3 = vector.elementAt(n3 + 1).toString();
                n3 += 2;
                continue;
            }
            n3 += 2;
        }
        extraInfo = ExtraInfo.load(n4, n5, vector, n, n2);
        if (bl2) {
            extraInfo2 = ExtraInfo.load(n4, n5, vector, "xy", n, n2);
            return new LineSet(string, n6, string2, n4, n5, extraInfo, n7, bl, string3, extraInfo2);
        }
        return new LineSet(string, n6, string2, n4, n5, extraInfo, n7, bl);
    }

    public String getSaveString() {
        String string = "lineset-id " + this.id + "\r\n" + "lineset-name \"" + Utilities.printable(this.name) + "\"\r\n" + "lineset-order " + this.order + "\r\n" + "lineset-type " + this.type + "\r\n" + "lineset-color " + this.color.getRGB() + "\r\n" + "lineset-displayed? " + (this.displayed ? "true" : "false") + "\r\n" + "lineset-instruction \"" + Utilities.printable(this.inst) + "\"\r\n" + this.ei.getSaveString();
        if (this.xyOn) {
            string = string + "lineset-xy? true\r\nlineset-xy-instruction \"" + Utilities.printable(this.instx) + "\"\r\n" + this.eix.getSaveString("xy");
        }
        string = string + "lineset-end " + this.id + "\r\n";
        return string;
    }

    LineSet copy(int n, int n2) {
        LineSet lineSet = new LineSet(n, n2);
        lineSet.name = this.name;
        lineSet.inst = this.inst;
        lineSet.ei = this.ei == null ? null : this.ei.copy(n, n2);
        lineSet.displayed = this.displayed;
        lineSet.starlogocolor = this.starlogocolor;
        lineSet.color = this.color;
        lineSet.row = this.row;
        lineSet.col = this.col;
        lineSet.xyOn = this.xyOn;
        lineSet.instx = this.instx;
        lineSet.eix = this.eix == null ? null : this.eix.copy(n, n2);
        lineSet.type = this.type;
        return lineSet;
    }

    LineSet(int n, int n2) {
        this.id = n;
        this.order = n2;
        this.name = "<name>";
        this.inst = "";
        this.ei = new ExtraInfo(n, n2);
        this.displayed = n == 1;
        this.starlogocolor = n % 10 * 10 + 5;
        this.color = Colors.colorarray[(int)(this.starlogocolor * 32.0)];
        this.xyOn = false;
    }

    LineSet(int n, int n2, int n3) {
        this(n, n3);
        this.type = n2;
        if (n2 == 3 || n2 == 4) {
            this.xyOn = true;
            this.instx = "";
            this.eix = new ExtraInfo(n, n3);
        }
    }

    LineSet(String string, int n, String string2, int n2, int n3, ExtraInfo extraInfo, boolean bl) {
        this.name = string;
        this.type = n;
        this.inst = string2;
        this.id = n2;
        this.order = n3;
        this.ei = extraInfo;
        this.displayed = bl;
        this.xyOn = false;
    }

    LineSet(String string, int n, String string2, int n2, int n3, ExtraInfo extraInfo, int n4, boolean bl) {
        this(string, n, string2, n2, n3, extraInfo, bl);
        this.color = new Color(n4);
    }

    LineSet(String string, int n, String string2, int n2, int n3, ExtraInfo extraInfo, boolean bl, String string3, ExtraInfo extraInfo2) {
        this.name = string;
        this.type = n;
        this.inst = string2;
        this.id = n2;
        this.order = n3;
        this.ei = extraInfo;
        this.displayed = bl;
        this.instx = string3;
        this.eix = extraInfo2;
        this.xyOn = true;
    }

    LineSet(String string, int n, String string2, int n2, int n3, ExtraInfo extraInfo, int n4, boolean bl, String string3, ExtraInfo extraInfo2) {
        this(string, n, string2, n2, n3, extraInfo, bl, string3, extraInfo2);
        this.color = new Color(n4);
    }
}

