/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JPanel;
import starlogo.Colors;
import starlogo.JShapeColorTool;
import starlogo.JShapeEditorPanel;
import starlogo.Widget;

public class JShapePaintSelect
extends JPanel {
    static int turtlewidth = 17;
    static int turtleheight = 17;
    static Image turtleImage;
    static Image newTurtleImage;
    static int colorBlack;
    static int colorYellow;
    boolean patch = false;
    boolean turtle = false;
    boolean paint = true;
    Rectangle patchRect = new Rectangle(4, 14, 16, 16);
    Rectangle turtleRect = new Rectangle(27, 14, 15, 15);
    int[] turtlepixels = new int[turtlewidth * turtleheight];
    MemoryImageSource source;
    int[] imagepixels = new int[turtlewidth * turtleheight];
    JShapeColorTool colortool;
    private static /* synthetic */ Class class$Lstarlogo$JShapePaintSelect;

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.patchRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.patch) {
                return;
            }
            this.patch = true;
            this.turtle = false;
            this.paint = false;
            this.updateTurtleColor(Colors.colorarray[0]);
            this.repaint();
        } else if (this.turtleRect.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (this.turtle) {
                return;
            }
            this.patch = false;
            this.turtle = true;
            this.paint = false;
            this.updateTurtleColor(Color.gray.darker());
            this.repaint();
        }
    }

    public void makeTurtlePixels() {
        PixelGrabber pixelGrabber = new PixelGrabber(turtleImage, 0, turtleheight, turtlewidth, turtleheight, this.turtlepixels, 0, turtlewidth);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            return;
        }
        int n = 0;
        while (n < turtlewidth * turtleheight) {
            if (this.turtlepixels[n] != colorBlack) {
                this.imagepixels[n] = this.turtlepixels[n];
            }
            ++n;
        }
        this.source = new MemoryImageSource(turtlewidth, turtleheight, this.imagepixels, 0, turtlewidth);
        this.source.setAnimated(true);
        newTurtleImage = Toolkit.getDefaultToolkit().createImage(this.source);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(SystemColor.control);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        if (this.patch) {
            graphics.drawImage(JShapeEditorPanel.patchTrans16x16AsImage, 4, 14, this);
            graphics.setColor(Colors.colorarray[0]);
            graphics.drawRect(3, 13, 17, 17);
            Shape shape = graphics.getClip();
            graphics.clipRect(27, 14, 16, 17);
            graphics.drawImage(turtleImage, 27, 14, this);
            graphics.setClip(shape);
        } else if (this.turtle) {
            graphics.setColor(Colors.colorarray[0]);
            graphics.fillRect(4, 14, 16, 16);
            graphics.drawImage(newTurtleImage, 27, 14, this);
        } else {
            graphics.setColor(Colors.colorarray[0]);
            graphics.fillRect(4, 14, 16, 16);
            Shape shape = graphics.getClip();
            graphics.setClip(27, 14, 16, 17);
            graphics.drawImage(turtleImage, 27, 14, this);
            graphics.setClip(shape);
        }
    }

    void updateTurtleColor(Color color) {
        int n = color.getRGB();
        int n2 = 0;
        while (n2 < turtlewidth * turtleheight) {
            if (this.turtlepixels[n2] == colorBlack) {
                this.imagepixels[n2] = JShapeEditorPanel.patchTrans16x16[n2];
            } else if (this.turtlepixels[n2] == colorYellow) {
                this.imagepixels[n2] = -16777216;
            }
            ++n2;
        }
        this.source.newPixels(0, 0, turtlewidth, turtleheight);
    }

    public void deselect() {
        if (!this.patch && !this.turtle) {
            return;
        }
        this.patch = false;
        this.turtle = false;
        this.paint = true;
        this.updateTurtleColor(Colors.colorarray[0]);
        this.repaint();
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        URL uRL = (class$Lstarlogo$JShapePaintSelect != null ? class$Lstarlogo$JShapePaintSelect : (class$Lstarlogo$JShapePaintSelect = JShapePaintSelect.class$("starlogo.JShapePaintSelect"))).getResource(string + "turtle.gif");
        if (uRL == null) {
            throw new MalformedURLException();
        }
        turtleImage = toolkit.getImage(uRL);
        mediaTracker.addImage(turtleImage, Widget.trackerID++);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public JShapePaintSelect(JShapeColorTool jShapeColorTool) {
        this.colortool = jShapeColorTool;
        this.makeTurtlePixels();
        this.addMouseListener(new MouseAdapter(this){
            private final /* synthetic */ JShapePaintSelect this$0;

            public final void mouseClicked(MouseEvent mouseEvent) {
                this.this$0.mouseClicked(mouseEvent);
            }
            {
                this.this$0 = jShapePaintSelect;
                this.constructor$0(jShapePaintSelect);
            }

            private final void constructor$0(JShapePaintSelect jShapePaintSelect) {
            }
        });
    }

    static {
        colorBlack = -16777216;
        colorYellow = -256;
    }
}

