/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import starlogo.SLDialog;
import yoyo.YoYo;

abstract class JSLDialog
extends JDialog
implements SLDialog {
    public static Font TEXT_FONT;
    public static Font LABEL_FONT;
    static int avgFontHeight;
    static int avgFontWidth;
    protected Frame parent;
    public OKCancel okcancel;

    public void addNotify() {
        super.addNotify();
        if (YoYo.macosxp) {
            ((Component)this).setBackground(UIManager.getColor("window"));
        } else {
            ((Component)this).setBackground(SystemColor.control);
        }
    }

    protected void initOKCancel(JButton jButton, JButton jButton2) {
        this.okcancel = new OKCancel(jButton, jButton2);
    }

    protected void initFocus(Component component) {
        FocusGrabber focusGrabber = new FocusGrabber(component);
        this.addFocusListener(focusGrabber);
        this.addWindowListener(focusGrabber);
    }

    protected void initShortcuts() {
        JSLDialog.addKeyListeners(this, new Shortcuts(this));
    }

    protected void initLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = dimension.width;
        Dimension dimension2 = this.getSize();
        int n2 = dimension2.width;
        if (!YoYo.solarisp) {
            ((Component)this).setLocation((n - n2) / 2, 60);
        }
    }

    public static void formatText(JTextComponent jTextComponent) {
        jTextComponent.setFont(TEXT_FONT);
        JSLDialog.colorText(jTextComponent);
    }

    public static void formatLabel(Component component) {
        component.setFont(LABEL_FONT);
        JSLDialog.colorControl(component);
    }

    public static void colorControl(Component component) {
    }

    public static void colorText(JTextComponent jTextComponent) {
        jTextComponent.setBackground(Color.white);
        jTextComponent.setForeground(Color.black);
    }

    protected void cancel() {
        ((Component)this).setVisible(false);
    }

    protected void ok() {
        ((Component)this).setVisible(false);
    }

    protected static void addKeyListeners(Container container, KeyListener keyListener) {
        container.addKeyListener(keyListener);
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                JSLDialog.addKeyListeners((Container)componentArray[n], keyListener);
            } else {
                componentArray[n].addKeyListener(keyListener);
            }
            ++n;
        }
    }

    public boolean shortcutsOn() {
        return true;
    }

    public void initAverages() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(UIManager.getFont("Button.font"));
        avgFontHeight = fontMetrics.getHeight();
        int[] nArray = fontMetrics.getWidths();
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += nArray[n2];
            ++n2;
        }
        avgFontWidth = n / nArray.length;
    }

    public int dluToPixelsHorizontal(int n) {
        if (avgFontHeight == 0 || avgFontWidth == 0) {
            this.initAverages();
        }
        if (YoYo.pcp) {
            return n * avgFontWidth / 4;
        }
        return n;
    }

    public int dluToPixelsVertical(int n) {
        if (avgFontHeight == 0 || avgFontWidth == 0) {
            this.initAverages();
        }
        if (YoYo.pcp) {
            return n * avgFontHeight / 8;
        }
        return n;
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    protected JSLDialog(Frame frame, String string, boolean bl) {
        this(frame, string, bl, false);
    }

    protected JSLDialog(Frame frame, String string, boolean bl, boolean bl2) {
        super(frame, string, bl);
        this.parent = frame;
        this.addWindowListener(new Closer());
        if (!bl2 && !YoYo.unixp) {
            this.setResizable(false);
        }
        this.addNotify();
    }

    static {
        try {
            TEXT_FONT = new Font("Monospaced", 0, 12);
            if (YoYo.macintoshp) {
                TEXT_FONT = Font.getFont("starlogo.text.font", TEXT_FONT);
            }
            LABEL_FONT = new Font("Dialog", 0, 12);
            if (YoYo.macintoshp) {
                LABEL_FONT = Font.getFont("starlogo.label.font", LABEL_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected class OKCancel
    implements ActionListener {
        public final JButton bok;
        public final JButton bcancel;

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == this.bok) {
                JSLDialog.this.ok();
            } else if (jButton == this.bcancel) {
                JSLDialog.this.cancel();
            }
        }

        public OKCancel(JButton jButton, JButton jButton2) {
            this.bok = jButton;
            this.bcancel = jButton2;
            if (jButton != null) {
                jButton.addActionListener(this);
            }
            if (jButton2 != null) {
                jButton2.addActionListener(this);
            }
        }
    }

    private class Shortcuts
    extends KeyAdapter {
        private JSLDialog sld;

        public void keyPressed(KeyEvent keyEvent) {
            char c = keyEvent.getKeyChar();
            if (c == '\n' || c == '\r') {
                if (this.sld.shortcutsOn()) {
                    keyEvent.consume();
                    JSLDialog.this.ok();
                }
            } else if (c == '\u001b' && this.sld.shortcutsOn()) {
                keyEvent.consume();
                JSLDialog.this.cancel();
            }
        }

        public Shortcuts(JSLDialog jSLDialog2) {
            this.sld = jSLDialog2;
        }
    }

    private class Closer
    extends WindowAdapter {
        public void windowActivated(WindowEvent windowEvent) {
            if (JSLDialog.this.okcancel != null) {
                JSLDialog.this.getRootPane().setDefaultButton(JSLDialog.this.okcancel.bok);
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            JSLDialog.this.cancel();
        }

        Closer() {
        }
    }

    private class FocusGrabber
    extends WindowAdapter
    implements FocusListener {
        Component focus;

        public void focusGained(FocusEvent focusEvent) {
            this.focus.requestFocus();
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
            this.focus.requestFocus();
        }

        public FocusGrabber(Component component) {
            this.focus = component;
        }
    }
}

