/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import starlogo.Application;
import starlogo.ColorLegendDialog;
import starlogo.Colors;
import starlogo.DisplayMessage;
import starlogo.Interface;
import starlogo.SLProc;
import starlogo.SmartRectangle;
import starlogo.StackProcess;
import starlogo.StarLogo;
import starlogo.ToolTipWidget;
import starlogo.TurtleShapes;
import starlogo.VM;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.YoYo;

public class ColorLegendWidget
extends WidgetDrag
implements Observer,
DisplayMessage,
ImageProducer {
    public static int idCount = 1;
    public static int LEGEND_WIDTH = 60;
    public static int LEGEND_EDGE_WIDTH = 14;
    public static int LEGEND_HEIGHT = 16;
    static Font MONITOR_FONT;
    public int cindex = 0;
    public boolean isVis = false;
    public boolean selected = false;
    int pcolmask = 0;
    int tcolmask = -1;
    Image image;
    ImageConsumer ic;
    int[] pixels;
    int width = 16;
    int height = 16;
    int rowbytes = this.width;
    public String name;
    public Color color;
    public boolean showBorder;
    public int shape = 0;
    public Font font;
    Object value = VM.zeroInt;
    public int whichip = -1;
    public int onewhichip = -1;
    public StackProcess sp;
    public FontMetrics fm;
    public int textHeight;
    public int textDescent;
    StarLogo sl;
    Application app;
    public int id;

    public static ColorLegendWidget load(Vector vector, Interface interface_, StarLogo starLogo, boolean bl) {
        Object object;
        Object object2;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 50;
        int n5 = 20;
        int n6 = 1;
        String string = "legend1";
        Object object3 = "";
        int n7 = -1;
        int n8 = -1;
        Color color = Color.red;
        int n9 = 0;
        while (n9 < vector.size()) {
            String string2;
            object2 = vector.elementAt(n9).toString();
            if (((String)object2).equals("top-left")) {
                object = vector.elementAt(n9 + 1).toString();
                string2 = vector.elementAt(n9 + 2).toString();
                n2 = Integer.parseInt((String)object);
                n3 = Integer.parseInt(string2);
                n9 += 3;
                continue;
            }
            if (((String)object2).equals("width-height")) {
                object = vector.elementAt(n9 + 1).toString();
                string2 = vector.elementAt(n9 + 2).toString();
                n4 = Integer.parseInt((String)object);
                n5 = Integer.parseInt(string2);
                n9 += 3;
                continue;
            }
            if (((String)object2).equals("name")) {
                string = vector.elementAt(n9 + 1).toString();
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("shape")) {
                object = vector.elementAt(n9 + 1).toString();
                n = Integer.parseInt((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("color")) {
                object = vector.elementAt(n9 + 1).toString();
                color = new Color(Integer.parseInt((String)object));
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("show-border?")) {
                object = vector.elementAt(n9 + 1).toString();
                bl2 = Boolean.valueOf((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("legend-number")) {
                object = vector.elementAt(n9 + 1).toString();
                n6 = Integer.parseInt((String)object);
                n9 += 2;
                continue;
            }
            if (((String)object2).equals("toolTip-text")) {
                object3 = object = vector.elementAt(n9 + 1).toString();
                n9 += 2;
                continue;
            }
            if (bl) {
                if (((String)object2).equals("whichip")) {
                    object = vector.elementAt(n9 + 1).toString();
                    n7 = Integer.parseInt((String)object);
                    n9 += 2;
                    continue;
                }
                if (((String)object2).equals("onewhichip")) {
                    object = vector.elementAt(n9 + 1).toString();
                    n8 = Integer.parseInt((String)object);
                    n9 += 2;
                    continue;
                }
            }
            n9 += 2;
        }
        object2 = interface_.getBoundaries();
        object = new Rectangle(n3 + ((Rectangle)object2).x, n2 + ((Rectangle)object2).y, n4, n5);
        if (n6 >= idCount) {
            idCount = n6 + 1;
        }
        if (bl) {
            return new ColorLegendWidget(string, color, (Rectangle)object, bl2, n, n6, interface_, n7, n8, starLogo, (String)object3);
        }
        return new ColorLegendWidget(string, color, (Rectangle)object, bl2, n, n6, interface_, starLogo, (String)object3);
    }

    public int getId() {
        return this.id;
    }

    public String getSaveString(boolean bl) throws IOException {
        Rectangle rectangle = this.parent.getBoundaries();
        String string = "SLLegend\r\ntop-left " + (this.position.y - rectangle.y) + " " + (this.position.x - rectangle.x) + "\r\n" + "width-height " + this.position.width + " " + this.position.height + "\r\n" + "name \"" + this.name + "\"\r\n" + "shape " + this.shape + "\r\n" + "color " + this.color.getRGB() + "\r\n" + "show-border? " + this.showBorder + "\r\n" + "legend-number " + this.id + "\r\n" + this.getToolTipSaveString() + (bl && this.whichip >= 0 && this.onewhichip >= 0 ? "whichip " + this.whichip + "\r\n" + "onewhichip " + this.onewhichip + "\r\n" : "") + "\r\n";
        return string;
    }

    public static void createNew(Interface interface_) {
        ColorLegendDialog colorLegendDialog = Application.createColorLegendDialog(interface_.frame(), "New Legend");
        if (YoYo.language == 1) {
            colorLegendDialog = Application.createColorLegendDialog(interface_.frame(), "S\u00edmbolo Nuevo");
        }
        colorLegendDialog.show();
        if (colorLegendDialog.pressedOK()) {
            ColorLegendWidget colorLegendWidget = new ColorLegendWidget(interface_, interface_.sl());
            colorLegendDialog.getValues(colorLegendWidget);
            colorLegendWidget.updateMinSize();
            interface_.addWidget(colorLegendWidget);
        }
        colorLegendDialog.dispose();
    }

    public void setIndex(int n) {
        this.cindex = n;
    }

    public static int createNewFromPtolemy(Interface interface_, int n) {
        ColorLegendDialog colorLegendDialog = Application.createColorLegendDialog(interface_.frame(), "New Legend");
        colorLegendDialog.show();
        if (colorLegendDialog.pressedOK()) {
            if (StarLogo.DEBUG) {
                interface_.sl().app.log.println("OK clicked");
            }
            ColorLegendWidget colorLegendWidget = new ColorLegendWidget(interface_, interface_.sl(), true);
            colorLegendDialog.getValues(colorLegendWidget);
            interface_.addWidget(colorLegendWidget);
            colorLegendWidget.setIndex(n);
            colorLegendWidget.setVis(true);
        }
        colorLegendDialog.dispose();
        return idCount - 1;
    }

    public void setVis(boolean bl) {
        this.isVis = true;
    }

    public void edit() {
        ColorLegendDialog colorLegendDialog = Application.createColorLegendDialog(this.parent.frame(), "Edit Legend", this);
        if (YoYo.language == 1) {
            colorLegendDialog = Application.createColorLegendDialog(this.parent.frame(), "Cambie S\u00edmbolo", this);
        }
        colorLegendDialog.show();
        if (colorLegendDialog.pressedOK()) {
            boolean bl = this.showBorder;
            String string = this.name;
            this.parent.addHandlesToClipRect(this);
            colorLegendDialog.getValues(this);
            if (bl != this.showBorder || !string.equals(this.name)) {
                this.updateMinSize();
                this.update(this.position);
                this.app.project.markChanged();
            }
        }
        colorLegendDialog.dispose();
        super.edit();
    }

    public void setValue(Object object) {
        this.value = object;
        this.parent.repaint(this.position);
    }

    public void delete() {
        this.parent.legends().removeElement(this);
        super.delete();
    }

    public void setSaveColor(Color color) {
        this.color = color;
    }

    public void update() {
    }

    public void update(Observable observable, Object object) {
        if (object instanceof SLProc) {
            this.update();
        }
    }

    public void update(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public String toString() {
        return "Legend: " + this.name;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.ic == imageConsumer;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.ic = null;
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.tcm, this.drawShape(this.shape), 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (imageConsumer == null) {
            return;
        }
        if (this.ic == null) {
            this.ic = imageConsumer;
            imageConsumer.setColorModel(Colors.tcm);
            imageConsumer.setDimensions(this.width, this.height);
        }
        imageConsumer.setHints(2);
        imageConsumer.setPixels(0, 0, this.width, this.height, Colors.tcm, this.drawShape(this.shape), 0, this.rowbytes);
        imageConsumer.imageComplete(2);
        imageConsumer.setHints(1);
    }

    public void refresh() {
        this.drawShape(this.shape);
        if (this.ic != null) {
            this.startProduction(this.ic);
        }
    }

    public int[] drawShape(int n) {
        int[] nArray = new int[256];
        int n2 = 0;
        TurtleShapes turtleShapes = TurtleShapes.getShape(n);
        double[] dArray = turtleShapes.getColorsForSize(16)[0];
        int[] nArray2 = turtleShapes.getMasksForSize(16)[0];
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n2++] = nArray2[2 * n3] == -1 ? this.tcolmask : (nArray2[2 * n3 + 1] == -1 ? this.pcolmask : Colors.colorarrayints[(int)(dArray[n3] * 32.0)]);
            ++n3;
        }
        return nArray;
    }

    public void paint(Graphics graphics) {
        this.MIN_HEIGHT = 16;
        Shape shape = graphics.getClip();
        if (this.color.getRGB() == -1) {
            this.tcolmask = Colors.colorarrayints[272];
        }
        graphics.translate(this.position.x, this.position.y);
        if (this.showBorder) {
            graphics.setColor(Color.lightGray);
            graphics.drawRect(0, 0, this.position.width - 1, this.position.height - 1);
        }
        graphics.setColor(this.color);
        Shape shape2 = graphics.getClip();
        graphics.setClip(1, 1, this.position.width - 2, this.position.height - 2);
        graphics.drawImage(this.image, 0, 0, this);
        graphics.translate(-this.position.x, -this.position.y);
        this.paintText(graphics);
        graphics.setClip(shape);
    }

    public void paintText(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(Color.darkGray);
        graphics.setFont(this.font);
        int n = this.fm.stringWidth(this.name);
        graphics.translate(this.position.x, this.position.y);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, this.position.width, this.position.height);
        graphics.drawString(this.name, 35, 6 + this.textHeight / 2 - this.textDescent);
        graphics.setClip(shape);
        graphics.clipRect(10, 7, this.position.width - 20, 12);
        graphics.setClip(shape);
        graphics.translate(-this.position.x, -this.position.y);
        graphics.setColor(color);
    }

    public int resizeWhichCorner(Point point) {
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.position.x - 8, this.position.y - 8, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 7;
        }
        rectangle.setBounds(this.position.x + this.position.width, this.position.y - 8, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 8;
        }
        rectangle.setBounds(this.position.x - 8, this.position.y + this.position.height, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 7;
        }
        rectangle.setBounds(this.position.x + this.position.width, this.position.y + this.position.height, 8, 8);
        if (rectangle.contains(point.x, point.y)) {
            return 8;
        }
        return 0;
    }

    public void updateMinSize() {
        int n = this.fm.stringWidth(this.name);
        int n2 = this.width + n + 19;
        int n3 = this.fm.getAscent() + 6;
        if (this.position.height != n3) {
            this.position.height = n3;
        }
        if (this.position.width != n2) {
            this.position.width = n2;
        }
        if (this.parent.outline() != null) {
            this.parent.outline().width = this.position.width;
        }
    }

    public void displayOneString(String string) {
        Application.createMessageDialog(this.parent.frame(), "Error", "Error", true);
    }

    public void displayAString(String string) {
        Application.createMessageDialog(this.parent.frame(), "Error", "Error", true);
    }

    public void handleMouseClick(MouseEvent mouseEvent) {
        if (this.parent.getToolbar().buttonDown == 7 && YoYo.applet == null) {
            this.edit();
        }
    }

    public int getToolbarButton() {
        return 7;
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
    }

    public WidgetDrag copy(int n, Rectangle rectangle) {
        String string = this.name + " copy" + WidgetDrag.editionString(n);
        return new ColorLegendWidget(string, this.color, rectangle, this.showBorder, this.shape, ++idCount, this.parent, this.whichip, this.onewhichip, this.sl, this.getToolText());
    }

    public ColorLegendWidget(String string, Color color, Rectangle rectangle, boolean bl, int n, int n2, Interface interface_, StarLogo starLogo, String string2) {
        this.name = string;
        this.color = color;
        this.showBorder = bl;
        this.shape = n;
        this.position = new Rectangle(rectangle);
        this.position.height = LEGEND_HEIGHT;
        this.shape = n;
        this.id = n2;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = MONITOR_FONT;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        if (!ToolTipWidget.empty(string2)) {
            this.setToolTip(new ToolTipWidget(this.parent, string2));
        }
        this.image = this.parent.createImage(this);
    }

    public ColorLegendWidget(String string, Color color, Rectangle rectangle, boolean bl, int n, int n2, Interface interface_, int n3, int n4, StarLogo starLogo, String string2) {
        this(string, color, rectangle, bl, n, n2, interface_, starLogo, string2);
        this.whichip = n3;
        this.onewhichip = n4;
        this.image = this.parent.createImage(this);
    }

    public ColorLegendWidget(Interface interface_, StarLogo starLogo) {
        Dimension dimension = interface_.getSize();
        SmartRectangle smartRectangle = interface_.outline();
        if (smartRectangle.width < LEGEND_WIDTH) {
            smartRectangle.width = LEGEND_WIDTH;
        }
        if (smartRectangle.x + LEGEND_WIDTH > dimension.width) {
            smartRectangle.x = this.parent.getSize().width - LEGEND_WIDTH;
        }
        if (smartRectangle.y + LEGEND_HEIGHT > dimension.height) {
            smartRectangle.height = smartRectangle.height + smartRectangle.y - dimension.height + LEGEND_HEIGHT;
            smartRectangle.y = dimension.height - LEGEND_HEIGHT;
        }
        if (smartRectangle.height < LEGEND_HEIGHT) {
            smartRectangle.height = LEGEND_HEIGHT;
        }
        this.position = new Rectangle(smartRectangle);
        this.position.height = LEGEND_HEIGHT;
        this.id = idCount++;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = WidgetLite.WIDGET_FONT;
        this.showBorder = true;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.image = this.parent.createImage(this);
    }

    public ColorLegendWidget(Vector vector, int n, Interface interface_, StarLogo starLogo) {
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        String string = this.app.project.version;
        this.position = new Rectangle();
        this.position.x = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().x;
        this.position.y = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().y;
        this.position.width = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().x - this.position.x;
        this.position.height = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().y - this.position.y;
        this.position.height = LEGEND_HEIGHT;
        int n2 = ++n;
        this.name = vector.elementAt(n2).toString();
        this.font = WidgetLite.WIDGET_FONT;
        int n3 = ++n;
        ++n;
        this.id = new Integer(vector.elementAt(n3).toString());
        if (this.id >= idCount) {
            idCount = this.id + 1;
        }
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.updateMinSize();
    }

    public ColorLegendWidget(Interface interface_, StarLogo starLogo, boolean bl) {
        this.image = this.parent.createImage(this);
        this.id = idCount++;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.font = WidgetLite.WIDGET_FONT;
        this.showBorder = false;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
    }

    static {
        try {
            MONITOR_FONT = WidgetLite.WIDGET_FONT;
            if (YoYo.macintoshp) {
                MONITOR_FONT = Font.getFont("starlogo.monitor.font", MONITOR_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

