/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import starlogo.Application;
import starlogo.DisplayMessage;
import starlogo.Interface;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import starlogo.Widget;
import starlogo.WidgetLite;
import yoyo.Context;
import yoyo.Reader;
import yoyo.YoYo;

public class ColorChooser
extends Widget
implements StarLogoCaller,
DisplayMessage {
    static Font COLORCHOOSER_FONT;
    private boolean selected = false;
    public Interface iface;
    public StarLogo sl;
    private int drawColor;
    String cnum;
    String cname;
    boolean runningp;
    StringBuffer tempStringBuffer = new StringBuffer();
    FontMetrics fm;
    String[] colorArray = new String[]{"gray", "red", "orange", "brown", "yellow", "green", "lime", "turquoise", "cyan", "sky", "blue", "violet", "magenta", "pink"};
    private Vector spps = new Vector();
    private int sppcount = 0;

    public void setColor(int n) {
        this.drawColor = n;
        this.iface.addToClipRect(this.position);
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.translate(this.position.x, this.position.y);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setColor(SystemColor.control);
        graphics.fillRect(0, 0, 48, 20);
        graphics.draw3DRect(0, 1, 47, 14, false);
        graphics.draw3DRect(0, 17, 47, 14, false);
        Shape shape = graphics.getClip();
        graphics.setClip(2, 2, 46, 48);
        graphics.setFont(COLORCHOOSER_FONT);
        this.cnum = String.valueOf(this.drawColor);
        if (this.iface.keyboardFocus() == this) {
            this.highlight(graphics);
        } else {
            graphics.setColor(Color.black);
            n = this.fm.stringWidth(this.cnum);
            graphics.drawString(this.cnum, 44 - n, YoYo.macintoshp ? 12 : 11);
        }
        graphics.setColor(Color.black);
        this.cname = this.getColorString();
        n = 44 - this.fm.stringWidth(this.cname);
        graphics.drawString(this.cname, n, 27);
        graphics.setClip(shape);
        graphics.setFont(font);
        graphics.setColor(color);
        graphics.translate(-this.position.x, -this.position.y);
    }

    private final String getColorString() {
        if (this.drawColor == 0) {
            return "black";
        }
        if (this.drawColor == 9) {
            return "white";
        }
        String string = this.colorArray[this.drawColor / 10];
        String string2 = "";
        int n = this.drawColor % 10;
        if (n < 5) {
            string2 = " - " + (5 - n);
        }
        if (n == 5) {
            string2 = "";
        }
        if (n > 5) {
            string2 = " + " + (n - 5);
        }
        return string + string2;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.iface.keyboardFocus() == this) {
            this.enter();
        } else {
            this.select();
        }
        this.iface.addToClipRect(this.position);
    }

    private final void highlight(Graphics graphics) {
        String string = this.tempStringBuffer.toString();
        int n = this.fm.stringWidth(string);
        Shape shape = graphics.getClip();
        graphics.setClip(2, 2, 46, 48);
        graphics.setColor(Color.white);
        graphics.fillRect(1, 2, 46, 13);
        graphics.setColor(Color.blue);
        graphics.fillRect(43 - n, 2, n + 3, 13);
        graphics.setColor(Color.white);
        graphics.setFont(COLORCHOOSER_FONT);
        graphics.drawString(string, 44 - n, YoYo.macintoshp ? 12 : 11);
        graphics.setClip(shape);
    }

    private final void highlight() {
        Graphics graphics = this.iface.getGraphics();
        graphics.translate(this.position.x, this.position.y);
        this.highlight(graphics);
        graphics.dispose();
    }

    public void chop() {
        if (this.tempStringBuffer.length() == 0) {
            return;
        }
        this.tempStringBuffer.setLength(this.tempStringBuffer.length() - 1);
        this.highlight();
    }

    public void add(char c) {
        if (this.tempStringBuffer.length() > 10) {
            return;
        }
        this.tempStringBuffer.append(c);
        this.highlight();
    }

    public void restoreOld() {
        if (this.selected) {
            this.iface.addToClipRect(this.position);
        }
        this.deselect();
    }

    public void keyTyped(char c) {
        if (c == '\u001b') {
            this.restoreOld();
        } else if (c == '\u007f' || c == '\b') {
            this.chop();
        } else if (c == '\n') {
            this.enter();
        } else if (c > '\u001f' && c < '\u0080') {
            this.add(c);
        } else {
            return;
        }
        this.iface.addToClipRect(this.position);
    }

    public void select() {
        this.selected = true;
        this.iface.setKeyboardFocus(this);
        this.tempStringBuffer = new StringBuffer("");
    }

    public void deselect() {
        this.selected = false;
        this.iface.setKeyboardFocus(null);
        this.tempStringBuffer = new StringBuffer();
    }

    public void enter() {
        String string = this.tempStringBuffer.toString();
        if (string.trim().equals("")) {
            this.restoreOld();
            return;
        }
        this.handlecr(this.tempStringBuffer.toString());
        this.deselect();
    }

    private final void handlecr(String string) {
        this.runline("compile-colorchooser [%setcc " + string + "]");
    }

    private final void runline(String string) {
        if (!this.sl.app.maybeCompile()) {
            return;
        }
        this.runningp = true;
        if (string != null && string != "") {
            Object[] objectArray = Reader.read(string);
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = this;
            this.sl.app.cc.enqueue(objectArray2, this.sl.app.message, this.sl.app.err, null);
        }
    }

    public void done(Context context) {
    }

    public void runCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        if (this.sl.locked) {
            this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
        } else {
            Object object = this.sl.runningp;
            synchronized (object) {
                int n2 = this.sl.internalSetInstructions(this.toString(), nArray, objectArray2);
                StackProcessParent.runObserver(this.sl, n2, false, this);
            }
        }
    }

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0 && this.runningp) {
            this.runningp = false;
        }
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
    }

    public void callerPrintln(String string) {
        this.iface.statusbar().setStatusMessage(string);
    }

    public void callerClearText() {
        this.iface.statusbar().setStatusMessage("");
    }

    public void displayOneString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error", string, true);
    }

    public void displayAString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error", string, true);
    }

    ColorChooser(Interface interface_) {
        this.iface = interface_;
        this.sl = interface_.sl();
        this.drawColor = interface_.colortool().curcolor;
        this.cnum = String.valueOf(this.drawColor);
        this.fm = interface_.getToolkit().getFontMetrics(COLORCHOOSER_FONT);
        this.position = new Rectangle(0, 0, 48, 50);
    }

    static {
        try {
            COLORCHOOSER_FONT = WidgetLite.WIDGET_FONT;
            if (YoYo.macintoshp) {
                COLORCHOOSER_FONT = Font.getFont("starlogo.color-chooser.font", COLORCHOOSER_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

