/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import starlogo.Application;
import starlogo.ButtonDialog;
import starlogo.DisplayMessage;
import starlogo.Interface;
import starlogo.SLProc;
import starlogo.StackProcessParent;
import starlogo.StarLogo;
import starlogo.StarLogoCaller;
import starlogo.ToolTipWidget;
import starlogo.Utilities;
import starlogo.Widget;
import starlogo.WidgetDrag;
import starlogo.WidgetLite;
import yoyo.Context;
import yoyo.Reader;
import yoyo.YoYo;

public class ButtonWidget
extends WidgetDrag
implements StarLogoCaller,
Observer,
DisplayMessage {
    public static final String prePrefix = "pre-compile-button ";
    public static final String turCPrefix = "compile-turtle-button ";
    public static final String obsCPrefix = "compile-observer-button ";
    public static final String turPrefix = "turtle-button-r ";
    public static final String obsPrefix = "observer-button-r ";
    public static String foreverPrefix = "loop [";
    public static final int FIRST_BUTTON_ID = 1;
    public static int idCount = 1;
    static final int DOWN = 0;
    static final int UP = 1;
    static Image[] butCorners = new Image[2];
    static Image[] butN = new Image[2];
    static Image[] butE = new Image[2];
    static Image[] butS = new Image[2];
    static Image[] butW = new Image[2];
    static Image looper;
    static Font BUTTON_FONT;
    public String name;
    public String command;
    public boolean forever;
    public boolean showName;
    public boolean turtlep;
    public Font font;
    public Object[] listtorun;
    public Object[] listtocompile;
    public int id;
    int whichip = -1;
    boolean moved = false;
    boolean buttonDown = false;
    StarLogo sl;
    Application app;
    int textWidth;
    int textHeight;
    int textDescent;
    FontMetrics fm = null;
    public StackProcessParent spp;
    private Vector spps = new Vector();
    private int sppcount = 0;
    private static /* synthetic */ Class class$Lstarlogo$ButtonWidget;

    public static void createNew(Interface interface_) {
        interface_.app();
        ButtonDialog buttonDialog = Application.createButtonDialog(interface_.frame(), YoYo.language == 0 ? "New Button" : "Boton Nuevo");
        buttonDialog.show();
        if (buttonDialog.pressedOK()) {
            ButtonWidget buttonWidget = new ButtonWidget(interface_, interface_.sl());
            buttonDialog.getValues(buttonWidget);
            buttonWidget.updateMinSize();
            interface_.addWidget(buttonWidget);
            interface_.app().rancompilerp = false;
        }
        buttonDialog.dispose();
    }

    public void edit() {
        ButtonDialog buttonDialog = Application.createButtonDialog(this.parent.frame(), "Edit Button", this);
        buttonDialog.show();
        if (buttonDialog.pressedOK()) {
            this.parent.addHandlesToClipRect(this);
            buttonDialog.getValues(this);
            int n = this.textWidth;
            this.textWidth = this.fm.stringWidth(this.getText());
            if (this.forever) {
                this.textWidth += 18;
            }
            if (this.textWidth != n) {
                this.updateMinSize();
            }
            this.update(this.position);
            this.app.rancompilerp = false;
            this.app.project.markChanged();
        }
        buttonDialog.dispose();
        super.edit();
    }

    public static ButtonWidget load(Vector vector, Interface interface_, StarLogo starLogo, boolean bl) {
        Object object;
        Object object2;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 50;
        int n4 = 20;
        int n5 = 1;
        String string = "button1";
        String string2 = "nothing";
        Object object3 = "";
        int n6 = -1;
        int n7 = 0;
        while (n7 < vector.size()) {
            String string3;
            object2 = vector.elementAt(n7).toString();
            if (((String)object2).equals("turtle-or-observer?")) {
                object = vector.elementAt(n7 + 1).toString();
                bl2 = ((String)object).equals("turtle");
                n7 += 2;
                continue;
            }
            if (((String)object2).equals("top-left")) {
                object = vector.elementAt(n7 + 1).toString();
                string3 = vector.elementAt(n7 + 2).toString();
                n = Integer.parseInt((String)object);
                n2 = Integer.parseInt(string3);
                n7 += 3;
                continue;
            }
            if (((String)object2).equals("width-height")) {
                object = vector.elementAt(n7 + 1).toString();
                string3 = vector.elementAt(n7 + 2).toString();
                n3 = Integer.parseInt((String)object);
                n4 = Integer.parseInt(string3);
                n7 += 3;
                continue;
            }
            if (((String)object2).equals("name")) {
                string = vector.elementAt(n7 + 1).toString();
                n7 += 2;
                continue;
            }
            if (((String)object2).equals("line-to-run")) {
                string2 = vector.elementAt(n7 + 1).toString();
                n7 += 2;
                continue;
            }
            if (((String)object2).equals("forever?")) {
                object = vector.elementAt(n7 + 1).toString();
                bl3 = ((String)object).equals("true");
                n7 += 2;
                continue;
            }
            if (((String)object2).equals("show-name?")) {
                object = vector.elementAt(n7 + 1).toString();
                bl4 = ((String)object).equals("true");
                n7 += 2;
                continue;
            }
            if (((String)object2).equals("button-number")) {
                object = vector.elementAt(n7 + 1).toString();
                n5 = Integer.parseInt((String)object);
                n7 += 2;
                continue;
            }
            if (((String)object2).equals("toolTip-text")) {
                object3 = object = vector.elementAt(n7 + 1).toString();
                n7 += 2;
                continue;
            }
            if (bl && ((String)object2).equals("whichip")) {
                object = vector.elementAt(n7 + 1).toString();
                n6 = Integer.parseInt((String)object);
                n7 += 2;
                continue;
            }
            n7 += 2;
        }
        object2 = interface_.getBoundaries();
        object = new Rectangle(n2 + ((Rectangle)object2).x, n + ((Rectangle)object2).y, n3, n4);
        if (n5 >= idCount) {
            idCount = n5 + 1;
        }
        if (bl) {
            return new ButtonWidget(string, string2, (Rectangle)object, bl2, bl3, bl4, n5, interface_, n6, starLogo, (String)object3);
        }
        return new ButtonWidget(string, string2, (Rectangle)object, bl2, bl3, bl4, n5, interface_, starLogo, (String)object3);
    }

    public String getSaveString(boolean bl) throws IOException {
        Rectangle rectangle = this.parent.getBoundaries();
        return "SLButton\r\nturtle-or-observer? " + (this.turtlep ? "turtle\r\n" : "observer\r\n") + "top-left " + (this.position.y - rectangle.y) + " " + (this.position.x - rectangle.x) + "\r\n" + "width-height " + this.position.width + " " + this.position.height + "\r\n" + "name \"" + this.name + "\"\r\n" + "line-to-run \"" + Utilities.printable(this.command) + "\"\r\n" + "forever? " + (this.forever ? "true\r\n" : "false\r\n") + "button-number " + this.id + "\r\n" + "show-name? " + (this.showName ? "true\r\n" : "false\r\n") + (bl && this.whichip >= 0 ? "whichip " + this.whichip + "\r\n" : "") + this.getToolTipSaveString() + "\r\n";
    }

    void mouseClicked(MouseEvent mouseEvent) {
        if (this.parent.getToolbar().buttonDown == 1 || this.parent.getToolbar().paintActivep()) {
            if (!this.app.maybeCompile()) {
                return;
            }
            if (this.whichip >= 0) {
                Object object = this.sl.runningp;
                synchronized (object) {
                    this.toggleButton();
                }
            } else if (YoYo.applet == null) {
                Application.createMessageDialog(this.parent.frame(), "Warning", "Your project did not compile successfully. This button will work once you correct the problem.", false);
            }
        }
    }

    public void turnButtonOn() {
        if (!this.buttonDown) {
            this.buttonDown = true;
            this.spp = this.turtlep ? StackProcessParent.runTurtles(this.sl, this.whichip, this.forever, this) : StackProcessParent.runObserver(this.sl, this.whichip, this.forever, this);
            this.parent.repaint(this.position);
        }
    }

    public void turnButtonOff() {
        if (this.buttonDown) {
            this.popButton();
        }
    }

    public void toggleButton() {
        boolean bl = this.buttonDown = !this.buttonDown;
        if (this.buttonDown) {
            if (this.whichip >= 0) {
                if (this.sl.locked) {
                    this.displayOneString("I can't run StarLogo when any part of the Graphics Canvas is obscured.");
                    this.buttonDown = !this.buttonDown;
                } else {
                    this.spp = this.turtlep ? StackProcessParent.runTurtles(this.sl, this.whichip, this.forever, this) : StackProcessParent.runObserver(this.sl, this.whichip, this.forever, this);
                    this.parent.repaint(this.position);
                }
            } else {
                this.buttonDown = !this.buttonDown;
            }
        } else {
            this.popButton();
        }
    }

    public void popButton() {
        if (!this.donep()) {
            this.stopAll();
        }
    }

    public String getPreCommandToCompile() {
        return prePrefix + this.id + "\"" + this.name + "\"";
    }

    public String getCommandToCompile() {
        if (YoYo.language == 1) {
            foreverPrefix = "siempre [";
        }
        if (this.turtlep) {
            if (this.forever) {
                return turCPrefix + this.id + " \"" + this.name + "\" [" + foreverPrefix + this.command + "] ]";
            }
            return turCPrefix + this.id + " \"" + this.name + "\" [" + this.command + "]";
        }
        if (this.forever) {
            return obsCPrefix + this.id + " \"" + this.name + "\" [" + foreverPrefix + this.command + "] ]";
        }
        return obsCPrefix + this.id + " \"" + this.name + "\" [" + this.command + "]";
    }

    public void preCompileCommand() {
        this.whichip = -1;
        if (this.command != "" && this.command != null) {
            Object object = this.sl.runningp;
            synchronized (object) {
                this.sl.stopAll();
            }
            this.listtocompile = Reader.read(this.getPreCommandToCompile());
            Object[] objectArray = new Object[this.listtocompile.length + 1];
            System.arraycopy(this.listtocompile, 0, objectArray, 0, this.listtocompile.length);
            objectArray[objectArray.length - 1] = this;
            this.app.cc.enqueue(objectArray, this.app.message, this.app.err, null);
        }
    }

    public void compileCommand() {
        this.whichip = -1;
        if (this.command != "" && this.command != null) {
            Object object = this.sl.runningp;
            synchronized (object) {
                this.sl.stopAll();
            }
            this.listtocompile = Reader.read(this.getCommandToCompile());
            Object[] objectArray = new Object[this.listtocompile.length + 1];
            System.arraycopy(this.listtocompile, 0, objectArray, 0, this.listtocompile.length);
            objectArray[objectArray.length - 1] = this;
            if (StarLogo.DEBUG) {
                this.app.log.println("Trying to compile button: " + this);
            }
            this.app.cc.enqueue(objectArray, this.app.message, this.app.err, null);
        }
    }

    public void setCompiledCommand(Object[] objectArray, Object[] objectArray2) {
        if (StarLogo.DEBUG) {
            this.app.log.println("Finished compiling button " + this.name + "  " + YoYo.printToString(objectArray) + " " + YoYo.printToString(objectArray2));
        }
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ((Number)objectArray[n]).intValue();
            ++n;
        }
        this.whichip = this.sl.internalSetInstructions(this.toString(), nArray, objectArray2);
        if (StarLogo.DEBUG) {
            this.app.log.println("Button's whichip = " + this.whichip);
        }
    }

    public void done(StackProcessParent stackProcessParent) {
        this.spps.removeElement(stackProcessParent);
        --this.sppcount;
        if (this.sppcount == 0) {
            this.spp = null;
            this.buttonDown = false;
            this.parent.repaint(this.position);
        }
    }

    public boolean donep() {
        return this.sppcount == 0;
    }

    public StarLogoCaller caller() {
        return this;
    }

    public void addStackProcessParent(StackProcessParent stackProcessParent) {
        this.spps.addElement(stackProcessParent);
        ++this.sppcount;
    }

    public void stopAll() {
        Enumeration enumeration = ((Vector)this.spps.clone()).elements();
        while (enumeration.hasMoreElements()) {
            StackProcessParent stackProcessParent = (StackProcessParent)enumeration.nextElement();
            this.sl.stopProcess(stackProcessParent);
        }
        this.spp = null;
        this.buttonDown = false;
        this.parent.repaint(this.position);
    }

    public void callerPrintln(String string) {
        if (YoYo.applet == null) {
            if (this.turtlep) {
                this.app.procWin.turtlePrintln(string);
            } else {
                this.app.procWin.observerPrintln(string);
            }
        } else {
            YoYo.applet.showStatus(string);
        }
    }

    public void callerClearText() {
        if (YoYo.applet == null) {
            if (this.turtlep) {
                this.app.procWin.turtleClearCC();
            } else {
                this.app.procWin.observerClearCC();
            }
        } else {
            YoYo.applet.showStatus("");
        }
    }

    public void done(Context context) {
    }

    public void displayOneString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error in " + this.name, string, true);
    }

    public void displayAString(String string) {
        Application.createMessageDialog(this.sl.myframe, "Error in " + this.name, string, true);
    }

    public void update() {
        this.setChanged();
        this.notifyObservers();
    }

    public void update(Object object) {
        this.setChanged();
        this.notifyObservers(object);
    }

    public void update(Observable observable, Object object) {
        if (object instanceof SLProc) {
            this.update();
        }
    }

    public String toString() {
        return "Button:  " + this.getText();
    }

    public String getText() {
        return this.showName ? this.name : this.command;
    }

    public void delete() {
        this.parent.buttons().removeElement(this);
        super.delete();
    }

    public int getToolbarButton() {
        return 2;
    }

    public void updateMinSize() {
        int n;
        this.textWidth = this.fm.stringWidth(this.getText());
        if (this.forever) {
            this.textWidth += 18;
        }
        if ((n = 10 + this.textWidth) < 40) {
            n = 40;
        }
        if (this.position.width < n) {
            this.position.width = n;
        }
        if (this.parent.outline() != null) {
            this.parent.outline().width = this.position.width;
            if (this.parent.outline().x + this.parent.outline().width > this.parent.getSize().width) {
                this.parent.outline().width = this.parent.getSize().width - this.parent.outline().x;
            }
            if (this.parent.outline().width < n) {
                this.parent.outline().width = n;
            }
        }
        this.MIN_WIDTH = 40;
    }

    public void paint(Graphics graphics) {
        int n = this.buttonDown ? 0 : 1;
        graphics.translate(this.position.x, this.position.y);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, 5, 5);
        graphics.drawImage(butCorners[n], 0, 0, null);
        graphics.setClip(shape);
        graphics.clipRect(this.position.width - 5, 0, 5, 5);
        graphics.drawImage(butCorners[n], this.position.width - 10, 0, null);
        graphics.setClip(shape);
        graphics.clipRect(0, this.position.height - 5, 5, 5);
        graphics.drawImage(butCorners[n], 0, this.position.height - 10, null);
        graphics.setClip(shape);
        graphics.clipRect(this.position.width - 5, this.position.height - 5, 5, 5);
        graphics.drawImage(butCorners[n], this.position.width - 10, this.position.height - 10, null);
        graphics.setClip(shape);
        graphics.drawImage(butN[n], 5, 0, this.position.width - 10, 5, null);
        graphics.drawImage(butE[n], this.position.width - 5, 5, 5, this.position.height - 10, null);
        graphics.drawImage(butS[n], 5, this.position.height - 5, this.position.width - 10, 5, null);
        graphics.drawImage(butW[n], 0, 5, 5, this.position.height - 10, null);
        if (n == 1) {
            graphics.setColor(new Color(0, 153, 255));
        } else {
            graphics.setColor(new Color(24, 99, 189));
        }
        graphics.fillRect(5, 5, this.position.width - 9, this.position.height - 9);
        graphics.translate(-this.position.x, -this.position.y);
        this.paintText(graphics, n);
    }

    public void paintText(Graphics graphics, int n) {
        if (n == 1) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.white);
        }
        graphics.setFont(this.font);
        graphics.translate(this.position.x, this.position.y);
        Shape shape = graphics.getClip();
        graphics.clipRect(4, 4, this.position.width - 9, this.position.height - 9);
        if (this.forever) {
            graphics.drawString(this.getText(), (this.position.width - this.textWidth) / 2, this.position.height / 2 + this.textHeight / 2 - this.textDescent);
            int n2 = (this.position.width + this.textWidth) / 2 - 16;
            int n3 = this.position.height / 2 - 8;
            graphics.clipRect(n2, n3, 16, 16);
            if (n == 0) {
                graphics.drawImage(looper, n2, n3, null);
            } else {
                graphics.drawImage(looper, n2 - 16, n3, null);
            }
        } else {
            graphics.drawString(this.getText(), (this.position.width - this.textWidth) / 2, this.position.height / 2 + this.textHeight / 2 - this.textDescent);
        }
        graphics.setClip(shape);
        graphics.translate(-this.position.x, -this.position.y);
    }

    public static void loadImages(String string, MediaTracker mediaTracker, Toolkit toolkit) throws MalformedURLException {
        ButtonWidget.butCorners[0] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "button-corners-down.gif"));
        ButtonWidget.butN[0] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "but-top-down.gif"));
        ButtonWidget.butE[0] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "but-right-down.gif"));
        ButtonWidget.butS[0] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "but-bot-down.gif"));
        ButtonWidget.butW[0] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "but-left-down.gif"));
        looper = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "looper.gif"));
        ButtonWidget.butCorners[1] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "button-corners-up.gif"));
        ButtonWidget.butN[1] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "but-top-up.gif"));
        ButtonWidget.butE[1] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "but-right-up.gif"));
        ButtonWidget.butS[1] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "but-bot-up.gif"));
        ButtonWidget.butW[1] = toolkit.getImage((class$Lstarlogo$ButtonWidget != null ? class$Lstarlogo$ButtonWidget : (class$Lstarlogo$ButtonWidget = ButtonWidget.class$("starlogo.ButtonWidget"))).getResource(string + "but-left-up.gif"));
        mediaTracker.addImage(butN[0], Widget.trackerID++);
        mediaTracker.addImage(butCorners[0], Widget.trackerID++);
        mediaTracker.addImage(butE[0], Widget.trackerID++);
        mediaTracker.addImage(butS[0], Widget.trackerID++);
        mediaTracker.addImage(butW[0], Widget.trackerID++);
        mediaTracker.addImage(looper, Widget.trackerID++);
        mediaTracker.addImage(butN[1], Widget.trackerID++);
        mediaTracker.addImage(butCorners[1], Widget.trackerID++);
        mediaTracker.addImage(butE[1], Widget.trackerID++);
        mediaTracker.addImage(butS[1], Widget.trackerID++);
        mediaTracker.addImage(butW[1], Widget.trackerID++);
    }

    public WidgetDrag copy(int n, Rectangle rectangle) {
        String string = this.name + " copy" + WidgetDrag.editionString(n);
        return new ButtonWidget(string, this.command, rectangle, this.turtlep, this.forever, this.showName, ++idCount, this.parent, this.sl, this.getToolText());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ButtonWidget(String string, String string2, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n, Interface interface_, StarLogo starLogo, String string3) {
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.name = string;
        this.command = string2;
        this.forever = bl2;
        this.showName = bl3;
        this.turtlep = bl;
        this.position = new Rectangle(rectangle);
        this.id = n;
        this.font = BUTTON_FONT;
        this.fm = this.parent.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.updateMinSize();
        if (!ToolTipWidget.empty(string3)) {
            this.setToolTip(new ToolTipWidget(this.parent, string3));
        }
    }

    public ButtonWidget(String string, String string2, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n, Interface interface_, int n2, StarLogo starLogo, String string3) {
        this(string, string2, rectangle, bl, bl2, bl3, n, interface_, starLogo, string3);
        this.whichip = n2;
    }

    public ButtonWidget(Interface interface_, StarLogo starLogo) {
        this(interface_, starLogo, "", "", false, false, true, "");
    }

    public ButtonWidget(Interface interface_, StarLogo starLogo, String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        if (interface_.outline().x + this.MIN_WIDTH > interface_.getSize().width) {
            interface_.outline().width = interface_.outline().width + interface_.outline().x - interface_.getSize().width + this.MIN_WIDTH;
            interface_.outline().x = interface_.getSize().width - this.MIN_WIDTH;
        }
        if (interface_.outline().width < this.MIN_WIDTH) {
            interface_.outline().width = this.MIN_WIDTH;
        }
        if (interface_.outline().y + this.MIN_HEIGHT > interface_.getSize().height) {
            interface_.outline().height = interface_.outline().height + interface_.outline().y - interface_.getSize().height + this.MIN_HEIGHT;
            interface_.outline().y = interface_.getSize().height - this.MIN_HEIGHT;
        }
        if (interface_.outline().height < this.MIN_HEIGHT) {
            interface_.outline().height = this.MIN_HEIGHT;
        }
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.name = string2;
        this.command = string;
        this.forever = bl;
        this.showName = bl2;
        this.turtlep = bl3;
        this.position = new Rectangle(interface_.outline());
        this.id = interface_.getHighestButtonID() + 1;
        ++idCount;
        this.font = WidgetLite.WIDGET_FONT;
        this.fm = this.parent.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.updateMinSize();
        if (!ToolTipWidget.empty(string3)) {
            this.setToolTip(new ToolTipWidget(this.parent, string3));
        }
    }

    public ButtonWidget(Vector vector, int n, Interface interface_, StarLogo starLogo) {
        this.position = new Rectangle();
        this.position.x = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().x;
        this.position.y = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().y;
        this.position.width = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().x - this.position.x;
        this.position.height = new Integer(vector.elementAt(n++).toString()) + interface_.getBoundaries().y - this.position.y;
        this.name = vector.elementAt(n++).toString();
        this.command = vector.elementAt(n++).toString();
        this.forever = vector.elementAt(n++).toString().toUpperCase().trim().equals("T");
        this.font = WidgetLite.WIDGET_FONT;
        this.id = new Integer(vector.elementAt(n++).toString());
        if (this.id >= idCount) {
            idCount = this.id + 1;
        }
        boolean bl = this.showName = vector.elementAt(n++).toString().toUpperCase().trim().equals("T");
        this.turtlep = n <= vector.size() - 1 ? !vector.elementAt(n++).toString().equals("observer") : true;
        this.parent = interface_;
        this.sl = starLogo;
        this.app = starLogo.app;
        this.fm = interface_.getToolkit().getFontMetrics(this.font);
        this.textDescent = this.fm.getMaxDescent();
        this.textHeight = this.fm.getMaxAscent() + this.textDescent;
        this.updateMinSize();
    }

    static {
        try {
            BUTTON_FONT = WidgetLite.WIDGET_FONT;
            if (YoYo.macintoshp) {
                BUTTON_FONT = Font.getFont("starlogo.button.font", BUTTON_FONT);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

