/*
 * Decompiled with CFR 0.152.
 */
package starlogo;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.PrintStream;
import java.io.Serializable;
import starlogo.SizeRequirements;

public class BoxLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private int axis;
    private Container target;
    private transient SizeRequirements[] xChildren;
    private transient SizeRequirements[] yChildren;
    private transient SizeRequirements xTotal;
    private transient SizeRequirements yTotal;
    private transient PrintStream dbg;

    public void invalidateLayout(Container container) {
        this.checkContainer(container);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public Dimension preferredLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    public Dimension maximumLayoutSize(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        Dimension dimension = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        Insets insets = container.getInsets();
        dimension.width = (int)Math.min((long)dimension.width + (long)insets.left + (long)insets.right, Integer.MAX_VALUE);
        dimension.height = (int)Math.min((long)dimension.height + (long)insets.top + (long)insets.bottom, Integer.MAX_VALUE);
        return dimension;
    }

    public float getLayoutAlignmentX(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    public float getLayoutAlignmentY(Container container) {
        this.checkContainer(container);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    public void layoutContainer(Container container) {
        Component component;
        this.checkContainer(container);
        this.checkRequests();
        int n = container.getComponentCount();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        if (this.axis == 0) {
            SizeRequirements.calculateTiledPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2);
            SizeRequirements.calculateAlignedPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
        } else {
            SizeRequirements.calculateAlignedPositions(dimension.width, this.xTotal, this.xChildren, nArray, nArray2);
            SizeRequirements.calculateTiledPositions(dimension.height, this.yTotal, this.yChildren, nArray3, nArray4);
        }
        int n2 = 0;
        while (n2 < n) {
            component = container.getComponent(n2);
            component.setBounds((int)Math.min((long)insets.left + (long)nArray[n2], Integer.MAX_VALUE), (int)Math.min((long)insets.top + (long)nArray3[n2], Integer.MAX_VALUE), nArray2[n2], nArray4[n2]);
            ++n2;
        }
        if (this.dbg != null) {
            n2 = 0;
            while (n2 < n) {
                component = container.getComponent(n2);
                this.dbg.println(component.toString());
                this.dbg.println("X: " + this.xChildren[n2]);
                this.dbg.println("Y: " + this.yChildren[n2]);
                ++n2;
            }
        }
    }

    void checkContainer(Container container) {
        if (this.target != container) {
            throw new AWTError("BoxLayout can't be shared");
        }
    }

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            int n = this.target.getComponentCount();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            int n2 = 0;
            while (n2 < n) {
                Component component = this.target.getComponent(n2);
                if (!component.isVisible()) {
                    this.xChildren[n2] = new SizeRequirements(0, 0, 0, component.getAlignmentX());
                    this.yChildren[n2] = new SizeRequirements(0, 0, 0, component.getAlignmentY());
                } else {
                    Dimension dimension = component.getMinimumSize();
                    Dimension dimension2 = component.getPreferredSize();
                    Dimension dimension3 = component.getMaximumSize();
                    this.xChildren[n2] = new SizeRequirements(dimension.width, dimension2.width, dimension3.width, component.getAlignmentX());
                    this.yChildren[n2] = new SizeRequirements(dimension.height, dimension2.height, dimension3.height, component.getAlignmentY());
                }
                ++n2;
            }
            if (this.axis == 0) {
                this.xTotal = SizeRequirements.getTiledSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
            } else {
                this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
                this.yTotal = SizeRequirements.getTiledSizeRequirements(this.yChildren);
            }
        }
    }

    public BoxLayout(Container container, int n) {
        if (n != 0 && n != 1) {
            throw new AWTError("Invalid axis");
        }
        this.axis = n;
        this.target = container;
    }

    BoxLayout(Container container, int n, PrintStream printStream) {
        this(container, n);
        this.dbg = printStream;
    }
}

