/*
 * Decompiled with CFR 0.152.
 */
package ptolemy;

import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import starlogo.Colors;
import starlogo.LineWidget;

public class PlotBox
extends JPanel {
    protected transient double _yMax = 0.0;
    protected transient double _yMin = 0.0;
    protected transient double _xMax = 0.0;
    protected transient double _xMin = 0.0;
    protected static final transient double _PADDING = 0.05;
    protected transient boolean _xRangeGiven = false;
    protected transient boolean _yRangeGiven = false;
    protected transient boolean _rangesGivenByZooming = false;
    protected double _xlowgiven;
    protected double _xhighgiven;
    protected double _ylowgiven;
    protected double _yhighgiven;
    protected double _xBottom = Double.MAX_VALUE;
    protected double _xTop = -1.7976931348623157E308;
    protected double _yBottom = Double.MAX_VALUE;
    protected double _yTop = -1.7976931348623157E308;
    protected boolean _xlog = false;
    protected boolean _ylog = false;
    protected static final double _LOG10SCALE = 1.0 / Math.log(10.0);
    protected boolean _drawAxes = true;
    protected boolean _grid = true;
    protected boolean _wrap = false;
    protected Color _background = Color.white;
    protected Color _foreground = Color.black;
    protected int _topPadding = 10;
    protected int _bottomPadding = 5;
    protected int _rightPadding = 10;
    protected int _leftPadding = 10;
    protected int _ulx = 1;
    protected int _uly = 1;
    protected int _lrx = 100;
    protected int _lry = 100;
    protected double _yscale = 1.0;
    protected double _xscale = 1.0;
    protected boolean _usecolor = true;
    public Color[] _colors = new Color[15];
    public int[] _slcolors = new int[15];
    public Color[] _barcolors = new Color[15];
    protected int _width = 400;
    protected int _height = 400;
    public URL _documentBase = null;
    public Image _buffer;
    private String _filespec = null;
    private static final Color _boxColor = Color.darkGray;
    private double _ytickMax = 0.0;
    private double _ytickMin = 0.0;
    private double _xtickMax = 0.0;
    private double _xtickMin = 0.0;
    private int _yExp = 0;
    private int _xExp = 0;
    private double _ytickscale = 0.0;
    private double _xtickscale = 0.0;
    private Font _labelFont = null;
    private Font _superscriptFont = null;
    private Font _titleFont = null;
    private FontMetrics _labelFontMetrics = null;
    private FontMetrics _superscriptFontMetrics = null;
    private FontMetrics _titleFontMetrics = null;
    private NumberFormat _numberFormat = null;
    private transient int _gridCurJuke = 0;
    private transient double _gridBase = 0.0;
    private transient String[] _errorMsg;
    private String _xlabel;
    private String _ylabel;
    private String _title;
    private String _preTitle;
    private Vector _legendStrings = new Vector();
    private Vector _legendDatasets = new Vector();
    private Vector _xticks = null;
    private Vector _xticklabels = null;
    private Vector _yticks = null;
    private Vector _yticklabels = null;
    private transient Button _fillButton = null;
    private transient int _zoomx = -1;
    private transient int _zoomy = -1;
    private transient int _zoomxn = -1;
    private transient int _zoomyn = -1;
    private transient boolean _zoomin = false;
    private transient boolean _zoomout = false;
    private transient boolean _drawn = false;
    private transient boolean _zooming = false;
    private static final String _DTD = "<!-- PlotML DTD, created by Edward A. Lee, eal@eecs.berkeley.edu. --><!ELEMENT plot (barGraph | bin | dataset | default | noColor | \n\tnoGrid | title | wrap | xLabel | xLog | xRange | xTicks | yLabel | \n yLog | yRange | yTicks)*>\n  <!ELEMENT barGraph EMPTY>\n    <!ATTLIST barGraph width CDATA #IMPLIED>\n    <!ATTLIST barGraph offset CDATA #IMPLIED>\n  <!ELEMENT bin EMPTY>\n    <!ATTLIST bin width CDATA #IMPLIED>\n    <!ATTLIST bin offset CDATA #IMPLIED>\n  <!ELEMENT dataset (m | move | p | point)*>\n    <!ATTLIST dataset connected (yes | no) #IMPLIED>\n    <!ATTLIST dataset marks (none | dots | points | various) #IMPLIED>\n    <!ATTLIST dataset name CDATA #IMPLIED>\n    <!ATTLIST dataset stems (yes | no) #IMPLIED>\n  <!ELEMENT default EMPTY>\n    <!ATTLIST default connected (yes | no) \"yes\">\n    <!ATTLIST default marks (none | dots | points | various) \"none\">\n    <!ATTLIST default stems (yes | no) \"no\">\n  <!ELEMENT noColor EMPTY>\n  <!ELEMENT noGrid EMPTY>\n  <!ELEMENT title (#PCDATA)>\n  <!ELEMENT wrap EMPTY>\n  <!ELEMENT xLabel (#PCDATA)>\n  <!ELEMENT xLog EMPTY>\n  <!ELEMENT xRange EMPTY>\n    <!ATTLIST xRange min CDATA #REQUIRED>\n    <!ATTLIST xRange max CDATA #REQUIRED>\n  <!ELEMENT xTicks (tick)+>\n  <!ELEMENT yLabel (#PCDATA)>\n  <!ELEMENT yLog EMPTY>\n  <!ELEMENT yRange EMPTY>\n    <!ATTLIST yRange min CDATA #REQUIRED>\n    <!ATTLIST yRange max CDATA #REQUIRED>\n  <!ELEMENT yTicks (tick)+>\n    <!ELEMENT tick EMPTY>\n      <!ATTLIST tick label CDATA #REQUIRED>\n      <!ATTLIST tick position CDATA #REQUIRED>\n    <!ELEMENT m EMPTY>\n      <!ATTLIST m x CDATA #IMPLIED>\n      <!ATTLIST m x CDATA #REQUIRED>\n      <!ATTLIST m lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST m highErrorBar CDATA #IMPLIED>\n    <!ELEMENT move EMPTY>\n      <!ATTLIST move x CDATA #IMPLIED>\n      <!ATTLIST move x CDATA #REQUIRED>\n      <!ATTLIST move lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST move highErrorBar CDATA #IMPLIED>\n    <!ELEMENT p EMPTY>\n      <!ATTLIST p x CDATA #IMPLIED>\n      <!ATTLIST p x CDATA #REQUIRED>\n      <!ATTLIST p lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST p highErrorBar CDATA #IMPLIED>\n    <!ELEMENT point EMPTY>\n      <!ATTLIST point x CDATA #IMPLIED>\n      <!ATTLIST point x CDATA #REQUIRED>\n      <!ATTLIST point lowErrorBar CDATA #IMPLIED>\n      <!ATTLIST point highErrorBar CDATA #IMPLIED>";

    public PlotBox() {
        this.initColors();
        this.setLayout(new FlowLayout(2));
        this._measureFonts();
    }

    public void initColors() {
        int n = 0;
        while (n < 10) {
            this._colors[n] = Colors.colorarray[(n * 10 + 5) * 32];
            this._slcolors[n] = n * 10 + 5;
            this._barcolors[n] = Colors.colorarray[(n * 10 + 5) * 32];
            ++n;
        }
        this._colors[10] = Color.magenta;
        this._colors[11] = Color.black;
        this._slcolors[10] = 125;
        this._slcolors[11] = 0;
        this._barcolors[10] = Color.magenta;
        this._barcolors[11] = Color.black;
    }

    public PlotBox copy(LineWidget lineWidget, PlotBox plotBox) {
        int n;
        int n2;
        plotBox._yMax = this._yMax;
        plotBox._yMin = this._yMin;
        plotBox._xMax = this._xMax;
        plotBox._xMin = this._xMin;
        plotBox._xRangeGiven = this._xRangeGiven;
        plotBox._yRangeGiven = this._yRangeGiven;
        plotBox._rangesGivenByZooming = this._rangesGivenByZooming;
        plotBox._xlowgiven = this._xlowgiven;
        plotBox._xhighgiven = this._xhighgiven;
        plotBox._ylowgiven = this._ylowgiven;
        plotBox._yhighgiven = this._yhighgiven;
        plotBox._xBottom = this._xBottom;
        plotBox._xTop = this._xTop;
        plotBox._yBottom = this._yBottom;
        plotBox._yTop = this._yTop;
        plotBox._grid = this._grid;
        plotBox._wrap = this._wrap;
        plotBox._ulx = this._ulx;
        plotBox._uly = this._uly;
        plotBox._lrx = this._lrx;
        plotBox._lry = this._lry;
        plotBox._yscale = this._yscale;
        plotBox._usecolor = this._usecolor;
        int n3 = 0;
        while (n3 < 15) {
            plotBox._colors[n3] = this._colors[n3];
            plotBox._slcolors[n3] = this._slcolors[n3];
            plotBox._barcolors[n3] = this._barcolors[n3];
            ++n3;
        }
        plotBox._width = this._width;
        plotBox._height = this._height;
        plotBox._xtickMax = this._xtickMax;
        plotBox._xtickMin = this._xtickMin;
        plotBox._ytickMax = this._ytickMax;
        plotBox._ytickMin = this._ytickMin;
        plotBox._ytickscale = this._ytickscale;
        plotBox._xtickscale = this._xtickscale;
        plotBox._xlabel = this._xlabel;
        plotBox._ylabel = this._ylabel;
        plotBox._title = plotBox._title;
        int n4 = this._legendStrings.size();
        plotBox._legendStrings = new Vector(n4);
        int n5 = 0;
        while (n5 < n4) {
            plotBox._legendStrings.addElement(new String((String)this._legendStrings.elementAt(n5)));
            ++n5;
        }
        int n6 = this._legendDatasets.size();
        plotBox._legendDatasets = new Vector(n6);
        int n7 = 0;
        while (n7 < n6) {
            plotBox._legendDatasets.addElement(new Integer((Integer)this._legendDatasets.elementAt(n7)));
            ++n7;
        }
        if (this._xticks != null) {
            n2 = this._xticks.size();
            plotBox._xticks = new Vector(n2);
            n = 0;
            while (n < n2) {
                plotBox._xticks.addElement(new Double((Double)this._xticks.elementAt(n)));
                ++n;
            }
        }
        if (this._xticklabels != null) {
            n2 = this._xticks.size();
            plotBox._xticklabels = new Vector(n2);
            n = 0;
            while (n < n2) {
                plotBox._xticklabels.addElement(new String((String)this._xticklabels.elementAt(n)));
                ++n;
            }
        }
        if (this._yticks != null) {
            n2 = this._xticks.size();
            plotBox._yticks = new Vector(n2);
            n = 0;
            while (n < n2) {
                plotBox._yticks.addElement(new Double((Double)this._yticks.elementAt(n)));
                ++n;
            }
        }
        if (this._yticklabels != null) {
            n2 = this._xticks.size();
            plotBox._yticklabels = new Vector(n2);
            n = 0;
            while (n < n2) {
                plotBox._yticklabels.addElement(new String((String)this._yticklabels.elementAt(n)));
                ++n;
            }
        }
        plotBox._fillButton = this._fillButton;
        return plotBox;
    }

    public void clearLegend() {
        this._legendStrings = new Vector();
        this._legendDatasets = new Vector();
    }

    public void addLegend(int n, String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this._legendStrings.addElement(string);
        this._legendDatasets.addElement(new Integer(n));
    }

    public void addXTick(String string, double d) {
        if (this._xticks == null) {
            this._xticks = new Vector();
            this._xticklabels = new Vector();
        }
        this._xticks.addElement(new Double(d));
        this._xticklabels.addElement(string);
    }

    public void addYTick(String string, double d) {
        if (this._yticks == null) {
            this._yticks = new Vector();
            this._yticklabels = new Vector();
        }
        this._yticks.addElement(new Double(d));
        this._yticklabels.addElement(string);
    }

    public synchronized void clear(boolean bl, boolean bl2, boolean bl3) {
        if (bl2) {
            this._xBottom = Double.MAX_VALUE;
            this._xTop = -1.7976931348623157E308;
            this._yBottom = Double.MAX_VALUE;
            this._yTop = -1.7976931348623157E308;
        }
        if (bl) {
            if (bl2) {
                this._yMax = 0.0;
                this._yMin = 0.0;
                this._xMax = 0.0;
                this._xMin = 0.0;
                this._xRangeGiven = false;
                this._yRangeGiven = false;
                this._rangesGivenByZooming = false;
            }
            this._xlog = false;
            this._ylog = false;
            this._grid = bl3;
            this._wrap = false;
            this._usecolor = true;
            this._filespec = null;
            this._xlabel = null;
            this._ylabel = null;
            this._title = null;
            this._legendStrings = new Vector();
            this._legendDatasets = new Vector();
            if (bl2) {
                this._xticks = null;
                this._xticklabels = null;
                this._yticks = null;
                this._yticklabels = null;
            }
        }
    }

    public void export(OutputStream outputStream) {
    }

    public synchronized void fillPlot() {
        this._setXRange(this._xBottom, this._xTop);
        this._setYRange(this._yBottom, this._yTop);
    }

    public boolean getColor() {
        return this._usecolor;
    }

    /*
     * Unable to fully structure code
     */
    public static Color getColorByName(String var0) {
        try {
            if (var0.startsWith("#")) {
                var0 = var0.substring(1);
            }
            var1_1 = new Color(Integer.parseInt(var0, 16));
            return var1_1;
        }
        catch (NumberFormatException var1_2) {
            var1_3 = new String[][]{{"black", "00000"}, {"white", "ffffff"}, {"red", "ff0000"}, {"green", "00ff00"}, {"blue", "0000ff"}};
            var2_4 = 0;
            ** while (var2_4 < var1_3.length)
        }
lbl-1000:
        // 1 sources

        {
            if (var0.equals(var1_3[var2_4][0])) {
                try {
                    var3_6 = new Color(Integer.parseInt(var1_3[var2_4][1], 16));
                    return var3_6;
                }
                catch (NumberFormatException var3_5) {
                    // empty catch block
                }
            }
            ++var2_4;
            continue;
        }
lbl18:
        // 1 sources

        return null;
    }

    public String getDataurl() {
        return this._filespec;
    }

    public URL getDocumentBase() {
        return this._documentBase;
    }

    public boolean getGrid() {
        return this._grid;
    }

    public double getXmin() {
        return this._xMin;
    }

    public double getYmin() {
        return this._yMin;
    }

    public double getXmax() {
        return this._xMax;
    }

    public double getYmax() {
        return this._yMax;
    }

    public String getLegend(int n) {
        int n2 = this._legendDatasets.indexOf(new Integer(n), 0);
        if (n2 != -1) {
            return (String)this._legendStrings.elementAt(n2);
        }
        return null;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this._width, this._height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this._width, this._height);
    }

    public String getTitle() {
        if (this._title == null) {
            return "";
        }
        return this._title;
    }

    public String getXLabel() {
        return this._xlabel;
    }

    public boolean getXLog() {
        return this._xlog;
    }

    public double[] getXRange() {
        double[] dArray = new double[]{this._xMin + (this._xMax - this._xMin) * 0.05, this._xMax - (this._xMax - this._xMin) * 0.05};
        return dArray;
    }

    public Vector[] getXTicks() {
        if (this._xticks == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[]{this._xticks, this._xticklabels};
        return vectorArray;
    }

    public String getYLabel() {
        return this._ylabel;
    }

    public boolean getYLog() {
        return this._ylog;
    }

    public double[] getYRange() {
        double[] dArray = new double[]{this._yMin + (this._yMax - this._yMin) * 0.05, this._yMax - (this._yMax - this._yMin) * 0.05};
        return dArray;
    }

    public Vector[] getYTicks() {
        if (this._yticks == null) {
            return null;
        }
        Vector[] vectorArray = new Vector[]{this._yticks, this._yticklabels};
        return vectorArray;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this._buffer == null) {
            return;
        }
        Graphics graphics2 = this._buffer.getGraphics();
        this._drawPlot(graphics2, true);
        graphics.drawImage(this._buffer, 0, 0, null);
    }

    public void paintNoBuffer(Graphics graphics) {
        this._drawPlot(graphics, true);
    }

    public void setBackground(Color color) {
        this._background = color;
        super.setBackground(this._background);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this._width = n3;
        this._height = n4;
        this._buffer = this.createImage(n3, n4);
        super.setBounds(n, n2, this._width, this._height);
    }

    public void setButtons(boolean bl) {
        if (this._fillButton == null) {
            this._fillButton = new Button("fill");
            this._fillButton.addActionListener(new FillButtonListener());
            this.add(this._fillButton);
        }
        this._fillButton.setVisible(bl);
    }

    public void setColor(boolean bl) {
        this._usecolor = bl;
    }

    public void setDataurl(String string) {
        this._filespec = string;
    }

    public void setDocumentBase(URL uRL) {
        this._documentBase = uRL;
    }

    public void setForeground(Color color) {
        this._foreground = color;
        super.setForeground(this._foreground);
    }

    public void setGrid(boolean bl) {
        this._grid = bl;
    }

    public void setAxes(boolean bl) {
        this._drawAxes = bl;
    }

    public void setLabelFont(String string) {
        this._labelFont = Font.decode(string);
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
    }

    public void setSize(int n, int n2) {
        this._width = n;
        this._height = n2;
        this._buffer = this.createImage(n, n2);
        super.setSize(n, n2);
    }

    public void setTitle(String string, String string2) {
        this._title = string;
        this._preTitle = string2;
    }

    public void setTitleFont(String string) {
        this._titleFont = Font.decode(string);
        this._titleFontMetrics = this.getFontMetrics(this._titleFont);
    }

    public void setWrap(boolean bl) {
        this._wrap = bl;
    }

    public void setXLabel(String string) {
        this._xlabel = string;
    }

    public void setXLog(boolean bl) {
        this._xlog = bl;
    }

    public void setXRange(double d, double d2, boolean bl) {
        this._xRangeGiven = bl;
        this._setXRange(d, d2);
    }

    public void explicitXRange(double d, double d2) {
        this._xRangeGiven = true;
        this._xBottom = d;
        this._xTop = d2;
        this._setXRange(d, d2);
    }

    public void setYLabel(String string) {
        this._ylabel = string;
    }

    public void setYLog(boolean bl) {
        this._ylog = bl;
    }

    public void setYRange(double d, double d2, boolean bl) {
        this._yRangeGiven = bl;
        this._setYRange(d, d2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void write(OutputStream outputStream) {
        this.write(outputStream, null);
    }

    public void write(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(new BufferedOutputStream(outputStream), false);
        if (string == null) {
            printWriter.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
            printWriter.println("<!DOCTYPE plot [");
            printWriter.println(_DTD);
            printWriter.println("]>");
        } else {
            printWriter.println("<?xml version=\"1.0\" standalone=\"no\"?>");
            printWriter.println("<!DOCTYPE plot SYSTEM \"" + string + "\">");
        }
        printWriter.println("<plot>");
        printWriter.println("<!-- Ptolemy plot, version 3.1, PlotML format. -->");
        this._write(printWriter);
        printWriter.println("</plot>");
        printWriter.flush();
        if (outputStream != System.out) {
            printWriter.close();
        }
    }

    public synchronized void zoom(double d, double d2, double d3, double d4) {
        this._setXRange(d, d3);
        this._setYRange(d2, d4);
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        double d;
        Object object;
        int n5;
        Object object2;
        int n6;
        Object object3;
        if (graphics == null) {
            throw new RuntimeException("PlotBox._drawPlot: Attempt to draw axes without a Graphics object.");
        }
        Rectangle rectangle = this.getBounds();
        graphics.setPaintMode();
        if (bl) {
            graphics.clearRect(0, 0, rectangle.width, rectangle.height);
        }
        if (this._errorMsg != null) {
            int n7;
            int n8 = n7 = this._labelFontMetrics.getHeight() + 2;
            graphics.setColor(Color.black);
            int n9 = 0;
            while (n9 < this._errorMsg.length) {
                graphics.drawString(this._errorMsg[n9], 10, n8);
                n8 += n7;
                System.err.println(this._errorMsg[n9]);
                ++n9;
            }
            return;
        }
        if (!this._xRangeGiven) {
            if (this._xBottom > this._xTop) {
                this._setXRange(0.0, 50.0);
            } else {
                this._setXRange(this._xBottom, this._xTop);
            }
        }
        if (!this._yRangeGiven) {
            if (this._yBottom > this._yTop) {
                this._setYRange(0.0, 5.0);
            } else {
                this._setYRange(this._yBottom, this._yTop);
            }
        }
        int n10 = 0;
        int n11 = this._titleFontMetrics.getHeight();
        if (this._title == null) {
            this._title = "";
        }
        if (this._title != null || this._yExp != 0) {
            n10 = n11 + this._topPadding;
        }
        graphics.setFont(this._labelFont);
        int n12 = this._labelFontMetrics.getHeight();
        int n13 = n12 / 2;
        int n14 = rectangle.height - 5;
        int n15 = rectangle.width - this._rightPadding;
        if (this._xlog) {
            this._xExp = (int)Math.floor(this._xtickMin);
        }
        if (this._xExp != 0 && this._xticks == null) {
            String string = Integer.toString(this._xExp);
            n15 -= this._superscriptFontMetrics.stringWidth(string);
            graphics.setFont(this._superscriptFont);
            if (!this._xlog) {
                graphics.drawString(string, n15, n14 - n13);
                graphics.setFont(this._labelFont);
                graphics.drawString("x10", n15 -= this._labelFontMetrics.stringWidth("x10"), n14);
            }
            this._bottomPadding = 3 * n12 / 2 + 5;
        }
        if (this._xlabel != null && this._bottomPadding < n12 + 5) {
            this._bottomPadding = n12 + 5;
        }
        this._uly = n10 + 5;
        this._lry = rectangle.height - n12 - this._bottomPadding - 3;
        int n16 = this._lry - this._uly;
        this._yscale = (double)n16 / (this._yMax - this._yMin);
        this._ytickscale = (double)n16 / (this._ytickMax - this._ytickMin);
        int n17 = 2 + n16 / (n12 + 10);
        double d2 = this._roundUp((this._ytickMax - this._ytickMin) / (double)n17);
        double d3 = d2 * Math.ceil(this._ytickMin / d2);
        int n18 = 0;
        String[] stringArray = new String[n17];
        int[] nArray = new int[n17];
        int n19 = 0;
        if (this._yticks == null) {
            object3 = null;
            if (this._ylog) {
                object3 = this._gridInit(d3, d2, true, null);
            }
            n6 = this._numFracDigits(d2);
            double d4 = d3;
            if (this._ylog) {
                d4 = this._gridStep((Vector)object3, d3, d2, this._ylog);
            }
            double d5 = d4;
            while (d5 <= this._ytickMax) {
                if (n19 < n17) {
                    object2 = this._ylog ? this._formatLogNum(d5, n6) : this._formatNum(d5, n6);
                    stringArray[n19] = object2;
                    n5 = this._labelFontMetrics.stringWidth((String)object2);
                    nArray[n19++] = n5;
                    if (n5 > n18) {
                        n18 = n5;
                    }
                    d5 = this._gridStep((Vector)object3, d5, d2, this._ylog);
                    continue;
                }
                break;
            }
        } else {
            object3 = this._yticklabels.elements();
            while (object3.hasMoreElements()) {
                String string = (String)object3.nextElement();
                int n20 = this._labelFontMetrics.stringWidth(string);
                if (n20 <= n18) continue;
                n18 = n20;
            }
        }
        this._ulx = this._ylabel != null ? n18 + this._labelFontMetrics.stringWidth("W") + this._leftPadding : n18 + this._leftPadding;
        int n21 = this._drawLegend(graphics, rectangle.width - this._rightPadding, this._uly);
        this._lrx = rectangle.width - n21 - this._rightPadding;
        n6 = this._lrx - this._ulx;
        this._xscale = (double)n6 / (this._xMax - this._xMin);
        this._xtickscale = (double)n6 / (this._xtickMax - this._xtickMin);
        graphics.setColor(Color.white);
        graphics.fillRect(this._ulx, this._uly, n6, n16);
        graphics.setColor(this._foreground);
        if (this._drawAxes) {
            graphics.drawRect(this._ulx, this._uly, n6, n16);
        }
        int n22 = 5;
        int n23 = this._ulx + n22;
        int n24 = this._lrx - n22;
        if (this._yticks == null) {
            object = null;
            double d6 = d3;
            if (this._ylog) {
                object = this._gridInit(d3, d2, true, null);
                d6 = this._gridStep((Vector)object, d3, d2, this._ylog);
                n17 = n19;
            }
            n19 = 0;
            boolean bl2 = this._ylog;
            d = d6;
            while (d <= this._ytickMax) {
                if (n19 >= n17) break;
                n4 = this._lry - (int)((d - this._ytickMin) * this._ytickscale);
                int n25 = 0;
                if (n19 > 0 && !this._ylog) {
                    n25 = n13;
                }
                graphics.drawLine(this._ulx, n4, n23, n4);
                graphics.drawLine(this._lrx, n4, n24, n4);
                if (this._grid && n4 != this._uly && n4 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n23, n4, n24, n4);
                    graphics.setColor(this._foreground);
                }
                if (this._ylog && stringArray[n19].indexOf(101) != -1) {
                    bl2 = false;
                }
                graphics.drawString(stringArray[n19], this._ulx - nArray[n19++] - 4, n4 + n25);
                d = this._gridStep((Vector)object, d, d2, this._ylog);
            }
            if (this._ylog) {
                Vector vector = this._gridInit(d3, d2, false, (Vector)object);
                if (vector.size() > 0) {
                    double d7 = d2 > 1.0 ? 1.0 : d2;
                    double d8 = this._gridStep(vector, d3, d7, this._ylog);
                    while (d8 <= this._ytickMax) {
                        n3 = this._lry - (int)((d8 - this._ytickMin) * this._ytickscale);
                        if (this._grid && n3 != this._uly && n3 != this._lry) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(this._ulx + 1, n3, this._lrx - 1, n3);
                            graphics.setColor(this._foreground);
                        }
                        d8 = this._gridStep(vector, d8, d7, this._ylog);
                    }
                }
                this._yExp = bl2 ? (int)Math.floor(d6) : 0;
            }
            if (this._yExp != 0) {
                graphics.drawString("x10", 2, n10);
                graphics.setFont(this._superscriptFont);
                graphics.drawString(Integer.toString(this._yExp), this._labelFontMetrics.stringWidth("x10") + 2, n10 - n13);
                graphics.setFont(this._labelFont);
            }
        } else {
            object = this._yticks.elements();
            object2 = this._yticklabels.elements();
            while (object2.hasMoreElements()) {
                String string = (String)object2.nextElement();
                double d9 = (Double)object.nextElement();
                if (d9 > this._yMax || d9 < this._yMin) continue;
                n2 = this._lry - (int)((d9 - this._yMin) * this._yscale);
                n4 = 0;
                if (d9 < (double)(this._lry - n12)) {
                    n4 = n13;
                }
                graphics.drawLine(this._ulx, n2, n23, n2);
                graphics.drawLine(this._lrx, n2, n24, n2);
                if (this._grid && n2 != this._uly && n2 != this._lry) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n23, n2, n24, n2);
                    graphics.setColor(this._foreground);
                }
                graphics.drawString(string, this._ulx - this._labelFontMetrics.stringWidth(string) - 3, n2 + n4);
            }
        }
        int n26 = this._uly + n22;
        int n27 = this._lry - n22;
        if (this._xticks == null) {
            n5 = 10;
            double d10 = 0.0;
            n2 = 0;
            n4 = this._labelFontMetrics.stringWidth("8");
            if (this._xlog) {
                n5 = 2 + n6 / (n4 * 6 + 10);
            } else {
                int n28 = 0;
                while (n28++ <= 10) {
                    int n29;
                    int n30;
                    d10 = this._roundUp((this._xtickMax - this._xtickMin) / (double)n5);
                    n2 = this._numFracDigits(d10);
                    n = this._numIntDigits(this._xtickMax);
                    if (n < (n30 = this._numIntDigits(this._xtickMin))) {
                        n = n30;
                    }
                    if ((n5 = 2 + n6 / ((n29 = n4 * (n2 + 2 + n)) + 10)) - (n3 = n5) <= 1 || n3 - n5 <= 1) break;
                }
            }
            d10 = this._roundUp((this._xtickMax - this._xtickMin) / (double)n5);
            n2 = this._numFracDigits(d10);
            double d11 = d10 * Math.ceil(this._xtickMin / d10);
            Vector vector = null;
            double d12 = d11;
            if (this._xlog) {
                vector = this._gridInit(d11, d10, true, null);
                d12 = this._gridRoundUp(vector, d11);
            }
            boolean bl3 = this._xlog;
            double d13 = d12;
            while (d13 <= this._xtickMax) {
                String string;
                if (this._xlog) {
                    string = this._formatLogNum(d13, n2);
                    if (string.indexOf(101) != -1) {
                        bl3 = false;
                    }
                } else {
                    string = this._formatNum(d13, n2);
                }
                n23 = this._ulx + (int)((d13 - this._xtickMin) * this._xtickscale);
                graphics.drawLine(n23, this._uly, n23, n26);
                graphics.drawLine(n23, this._lry, n23, n27);
                if (this._grid && n23 != this._ulx && n23 != this._lrx) {
                    graphics.setColor(Color.lightGray);
                    graphics.drawLine(n23, n26, n23, n27);
                    graphics.setColor(this._foreground);
                }
                int n31 = n23 - this._labelFontMetrics.stringWidth(string) / 2;
                graphics.drawString(string, n31, this._lry + 3 + n12);
                d13 = this._gridStep(vector, d13, d10, this._xlog);
            }
            if (this._xlog) {
                double d14 = d10 > 1.0 ? 1.0 : d10;
                d12 = d14 * Math.ceil(this._xtickMin / d14);
                Vector vector2 = this._gridInit(d12, d14, false, vector);
                if (vector2.size() > 0) {
                    double d15 = this._gridStep(vector2, d12, d14, this._xlog);
                    while (d15 <= this._xtickMax) {
                        n23 = this._ulx + (int)((d15 - this._xtickMin) * this._xtickscale);
                        if (this._grid && n23 != this._ulx && n23 != this._lrx) {
                            graphics.setColor(Color.lightGray);
                            graphics.drawLine(n23, this._uly + 1, n23, this._lry - 1);
                            graphics.setColor(this._foreground);
                        }
                        d15 = this._gridStep(vector2, d15, d14, this._xlog);
                    }
                }
                if (bl3) {
                    this._xExp = (int)Math.floor(d12);
                    graphics.setFont(this._superscriptFont);
                    graphics.drawString(Integer.toString(this._xExp), n15, n14 - n13);
                    graphics.setFont(this._labelFont);
                    graphics.drawString("x10", n15 -= this._labelFontMetrics.stringWidth("x10"), n14);
                } else {
                    this._xExp = 0;
                }
            }
        } else {
            Enumeration enumeration = this._xticks.elements();
            Enumeration enumeration2 = this._xticklabels.elements();
            d = 0.0;
            while (enumeration2.hasMoreElements()) {
                int n32;
                String string = (String)enumeration2.nextElement();
                double d16 = (Double)enumeration.nextElement();
                if (d16 > this._xMax || d16 < this._xMin || !((double)(n32 = (n23 = this._ulx + (int)((d16 - this._xMin) * this._xscale)) - this._labelFontMetrics.stringWidth(string) / 2) > d)) continue;
                d = n23 + this._labelFontMetrics.stringWidth(string) / 2 + 10;
                graphics.drawString(string, n32, this._lry + 3 + n12);
                graphics.drawLine(n23, this._uly, n23, n26);
                graphics.drawLine(n23, this._lry, n23, n27);
                if (!this._grid || n23 == this._ulx || n23 == this._lrx) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n23, n26, n23, n27);
                graphics.setColor(this._foreground);
            }
        }
        graphics.setColor(this._foreground);
        if (this._title != null) {
            graphics.setFont(this._titleFont);
            int n33 = this._ulx + (n6 - this._titleFontMetrics.stringWidth(this._title)) / 2;
            graphics.drawString(this._preTitle + this._title, n33, n10);
        }
        graphics.setFont(this._labelFont);
        if (this._xlabel != null) {
            int n34 = this._ulx + (n6 - this._labelFontMetrics.stringWidth(this._xlabel)) / 2;
            graphics.drawString(this._xlabel, n34, n14);
        }
        int n35 = 2 + this._labelFontMetrics.stringWidth("W") / 2;
        int n36 = n12;
        if (this._ylabel != null) {
            int n37 = this._ylabel.length();
            n2 = this._uly + (this._lry - this._uly) / 2 - n37 * n36 / 2 + n36;
            int n38 = 0;
            while (n38 < n37) {
                String string = this._ylabel.substring(n38, n38 + 1);
                n = this._labelFontMetrics.stringWidth(string);
                graphics.drawString(string, n35 - n / 2, n2);
                n2 += n36;
                ++n38;
            }
        }
    }

    protected void _drawPoint(Graphics graphics, int n, long l, long l2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = l2 <= (long)this._lry && l2 >= (long)this._uly && l <= (long)this._lrx && l >= (long)this._ulx;
        if (!bl2 && bl) {
            return;
        }
        graphics.fillRect((int)l - 6, (int)l2 - 6, 6, 6);
    }

    protected void _setButtonsVisibility(boolean bl) {
        this._fillButton.setVisible(bl);
    }

    protected void _write(PrintWriter printWriter) {
        int n;
        int n2;
        if (this._title != null) {
            printWriter.println("<title>" + this._title + "</title>");
        }
        if (this._xlabel != null) {
            printWriter.println("<xLabel>" + this._xlabel + "</xLabel>");
        }
        if (this._ylabel != null) {
            printWriter.println("<yLabel>" + this._ylabel + "</yLabel>");
        }
        if (this._xRangeGiven) {
            printWriter.println("<xRange min=\"" + this._xlowgiven + "\" max=\"" + this._xhighgiven + "\"/>");
        }
        if (this._yRangeGiven) {
            printWriter.println("<yRange min=\"" + this._ylowgiven + "\" max=\"" + this._yhighgiven + "\"/>");
        }
        if (this._xticks != null && this._xticks.size() > 0) {
            printWriter.println("<xTicks>");
            n2 = this._xticks.size() - 1;
            n = 0;
            while (n <= n2) {
                printWriter.println("  <tick label=\"" + (String)this._xticklabels.elementAt(n) + "\" position=\"" + (Double)this._xticks.elementAt(n) + "\"/>");
                ++n;
            }
            printWriter.println("</xTicks>");
        }
        if (this._yticks != null && this._yticks.size() > 0) {
            printWriter.println("<yTicks>");
            n2 = this._yticks.size() - 1;
            n = 0;
            while (n <= n2) {
                printWriter.println("  <tick label=\"" + (String)this._yticklabels.elementAt(n) + "\" position=\"" + (Double)this._yticks.elementAt(n) + "\"/>");
                ++n;
            }
            printWriter.println("</yTicks>");
        }
        if (this._xlog) {
            printWriter.println("<xLog/>");
        }
        if (this._ylog) {
            printWriter.println("<yLog/>");
        }
        if (!this._grid) {
            printWriter.println("<noGrid/>");
        }
        if (this._wrap) {
            printWriter.println("<wrap/>");
        }
        if (!this._usecolor) {
            printWriter.println("<noColor/>");
        }
    }

    private int _drawLegend(Graphics graphics, int n, int n2) {
        graphics.setFont(this._labelFont);
        int n3 = this._labelFontMetrics.getHeight();
        Enumeration enumeration = this._legendStrings.elements();
        Enumeration enumeration2 = this._legendDatasets.elements();
        int n4 = n2 + n3;
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            int n6;
            String string = (String)enumeration.nextElement();
            int n7 = (Integer)enumeration2.nextElement();
            if (n7 < 0) continue;
            if (this._usecolor) {
                n6 = n7 % this._colors.length;
                graphics.setColor(this._colors[n6]);
            }
            this._drawPoint(graphics, n7, n - 3, n4 - 3, false);
            graphics.setColor(this._foreground);
            n6 = this._labelFontMetrics.stringWidth(string);
            if (n6 > n5) {
                n5 = n6;
            }
            graphics.drawString(string, n - 15 - n6, n4);
            n4 += n3;
        }
        return 22 + n5;
    }

    private String _formatLogNum(double d, int n) {
        int n2 = (int)d;
        String string = n2 >= 0 && n2 < 10 ? "0" + n2 : (n2 < 0 && n2 > -10 ? "-0" + -n2 : Integer.toString(n2));
        string = d >= 0.0 ? (d - (double)((int)d) < 0.001 ? "1e" + string : this._formatNum(Math.pow(10.0, d - (double)((int)d)), n)) : (-d - (double)((int)(-d)) < 0.001 ? "1e" + string : this._formatNum(Math.pow(10.0, d - (double)((int)d)) * 10.0, n));
        return string;
    }

    private String _formatNum(double d, int n) {
        if (this._numberFormat == null) {
            this._numberFormat = NumberFormat.getInstance();
        }
        this._numberFormat.setMinimumFractionDigits(n);
        this._numberFormat.setMaximumFractionDigits(n);
        String string = this._numberFormat.format(d);
        if (string.equals("-0.00")) {
            return "0.00";
        }
        if (string.equals("-0.0")) {
            return "0.0";
        }
        if (string.equals("-0")) {
            return "0";
        }
        return string;
    }

    private Vector _gridInit(double d, double d2, boolean bl, Vector vector) {
        double d3;
        Vector<Double> vector2 = new Vector<Double>(10);
        double d4 = Math.pow(10.0, d2);
        int n = 1;
        if (bl) {
            if (d4 <= 3.5) {
                n = d4 > 2.0 ? 2 : (d4 > 1.26 ? 5 : (d4 > 1.125 ? 10 : (int)Math.rint(1.0 / d2)));
            }
        } else {
            n = d4 > 10.0 ? 1 : (d4 > 3.0 ? 2 : (d4 > 2.0 ? 5 : (d4 > 1.125 ? 10 : 100)));
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            d3 = (double)n3 * 1.0 / (double)n * 10.0;
            double d5 = _LOG10SCALE * Math.log(d3);
            if (d5 == Double.NEGATIVE_INFINITY) {
                d5 = 0.0;
            }
            if (vector != null && n2 < vector.size()) {
                while (n2 < vector.size() && (Double)vector.elementAt(n2) < d5) {
                    ++n2;
                }
                if (n2 < vector.size()) {
                    if (Math.abs((Double)vector.elementAt(n2) - d5) > 1.0E-5) {
                        vector2.addElement(new Double(d5));
                    }
                } else {
                    vector2.addElement(new Double(d5));
                }
            } else {
                vector2.addElement(new Double(d5));
            }
            ++n3;
        }
        this._gridCurJuke = 0;
        if (d == -0.0) {
            d = 0.0;
        }
        this._gridBase = Math.floor(d);
        d3 = d - this._gridBase;
        this._gridCurJuke = -1;
        while (this._gridCurJuke + 1 < vector2.size() && d3 >= (Double)vector2.elementAt(this._gridCurJuke + 1)) {
            ++this._gridCurJuke;
        }
        return vector2;
    }

    private double _gridRoundUp(Vector vector, double d) {
        double d2 = d - Math.floor(d);
        int n = 0;
        while (n < vector.size() && d2 >= (Double)vector.elementAt(n)) {
            ++n;
        }
        if (n >= vector.size()) {
            return d;
        }
        return Math.floor(d) + (Double)vector.elementAt(n);
    }

    private double _gridStep(Vector vector, double d, double d2, boolean bl) {
        if (bl) {
            if (++this._gridCurJuke >= vector.size()) {
                this._gridCurJuke = 0;
                this._gridBase += Math.ceil(d2);
            }
            if (this._gridCurJuke >= vector.size()) {
                return d + d2;
            }
            return this._gridBase + (Double)vector.elementAt(this._gridCurJuke);
        }
        return d + d2;
    }

    private void _measureFonts() {
        if (this._labelFont == null) {
            this._labelFont = new Font("Helvetica", 0, 12);
        }
        if (this._superscriptFont == null) {
            this._superscriptFont = new Font("Helvetica", 0, 9);
        }
        if (this._titleFont == null) {
            this._titleFont = new Font("Helvetica", 1, 14);
        }
        this._labelFontMetrics = this.getFontMetrics(this._labelFont);
        this._superscriptFontMetrics = this.getFontMetrics(this._superscriptFont);
        this._titleFontMetrics = this.getFontMetrics(this._titleFont);
    }

    private int _numFracDigits(double d) {
        int n = 0;
        while (n <= 15 && d != Math.floor(d)) {
            d *= 10.0;
            ++n;
        }
        return n;
    }

    private int _numIntDigits(double d) {
        int n = 0;
        while (n <= 15 && (double)((int)d) != 0.0) {
            d /= 10.0;
            ++n;
        }
        return n;
    }

    private void _parsePairs(String string, boolean bl) {
        if (bl) {
            this._xticks = null;
            this._xticklabels = null;
        } else {
            this._yticks = null;
            this._yticklabels = null;
        }
        int n = 0;
        boolean bl2 = true;
        while (bl2) {
            int n2 = string.indexOf(",", n);
            String string2 = null;
            if (n2 > n) {
                string2 = string.substring(n, n2).trim();
            } else {
                string2 = string.substring(n).trim();
                bl2 = false;
            }
            int n3 = -1;
            int n4 = 0;
            if (string2.startsWith("\"")) {
                n3 = string2.indexOf("\"", 1);
                n4 = 1;
            } else {
                n3 = string2.indexOf(" ");
            }
            if (n3 > 0) {
                String string3 = string2.substring(n4, n3);
                String string4 = string2.substring(n3 + 1).trim();
                try {
                    double d = Double.valueOf(string4);
                    if (bl) {
                        this.addXTick(string3, d);
                    } else {
                        this.addYTick(string3, d);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Warning from PlotBox: Unable to parse ticks: " + numberFormatException.getMessage());
                }
            }
            n = n2 + 1;
            n2 = string.indexOf(",", n);
        }
    }

    private double _roundUp(double d) {
        int n;
        if ((d *= Math.pow(10.0, -(n = (int)Math.floor(Math.log(d) * _LOG10SCALE)))) > 5.0) {
            d = 10.0;
        } else if (d > 2.0) {
            d = 5.0;
        } else if (d > 1.0) {
            d = 2.0;
        }
        return d *= Math.pow(10.0, n);
    }

    public void _setXRange(double d, double d2) {
        if (d > d2) {
            d = 0.0;
            d2 = 5.0;
        } else if (d == d2) {
            d = 0.0;
            d2 = 5.0;
        }
        this._xMin = d - (d2 - d) * 0.05;
        this._xMax = d2 + (d2 - d) * 0.05;
        double d3 = Math.max(Math.abs(this._xMin), Math.abs(this._xMax));
        this._xExp = (int)Math.floor(Math.log(d3) * _LOG10SCALE);
        if (this._xExp > 3 || this._xExp < -3) {
            double d4 = 1.0 / Math.pow(10.0, this._xExp);
            this._xtickMin = this._xMin * d4;
            this._xtickMax = this._xMax * d4;
        } else {
            this._xtickMin = this._xMin;
            this._xtickMax = this._xMax;
            this._xExp = 0;
        }
    }

    public void _setYRange(double d, double d2) {
        if (d > d2) {
            d = -0.0;
            d2 = 5.0;
        } else if (d == d2) {
            d = -0.0;
            d2 = 5.0;
        }
        this._yMin = d - (d2 - d) * 0.05;
        this._yMax = d2 + (d2 - d) * 0.05;
        double d3 = Math.max(Math.abs(this._yMin), Math.abs(this._yMax));
        this._yExp = (int)Math.floor(Math.log(d3) * _LOG10SCALE);
        if (this._yExp > 3 || this._yExp < -3) {
            double d4 = 1.0 / Math.pow(10.0, this._yExp);
            this._ytickMin = this._yMin * d4;
            this._ytickMax = this._yMax * d4;
        } else {
            this._ytickMin = this._yMin;
            this._ytickMax = this._yMax;
            this._yExp = 0;
        }
    }

    synchronized void _zoom(int n, int n2) {
        this._zooming = false;
        Graphics graphics = this.getGraphics();
        boolean bl = false;
        if (this._zoomin && this._drawn) {
            if (this._zoomxn != -1 || this._zoomyn != -1) {
                int n3 = Math.min(this._zoomx, this._zoomxn);
                int n4 = Math.max(this._zoomx, this._zoomxn);
                int n5 = Math.min(this._zoomy, this._zoomyn);
                int n6 = Math.max(this._zoomy, this._zoomyn);
                graphics.setXORMode(_boxColor);
                graphics.drawRect(n3, n5, n4 - n3, n6 - n5);
                graphics.setPaintMode();
                if (n2 > this._lry) {
                    n2 = this._lry;
                }
                if (n2 < this._uly) {
                    n2 = this._uly;
                }
                if (n > this._lrx) {
                    n = this._lrx;
                }
                if (n < this._ulx) {
                    n = this._ulx;
                }
                if (Math.abs(this._zoomx - n) > 5 && Math.abs(this._zoomy - n2) > 5) {
                    double d = this._xMin + (double)(this._zoomx - this._ulx) / this._xscale;
                    double d2 = this._xMin + (double)(n - this._ulx) / this._xscale;
                    if (d < d2) {
                        this.setXRange(d, d2, true);
                    } else {
                        this.setXRange(d2, d, true);
                    }
                    d = this._yMax - (double)(this._zoomy - this._uly) / this._yscale;
                    d2 = this._yMax - (double)(n2 - this._uly) / this._yscale;
                    if (d < d2) {
                        this.setYRange(d, d2, true);
                    } else {
                        this.setYRange(d2, d, true);
                    }
                }
                bl = true;
            }
        } else if (this._zoomout && this._drawn) {
            graphics.setXORMode(_boxColor);
            int n7 = Math.abs(this._zoomx - this._zoomxn);
            int n8 = Math.abs(this._zoomy - this._zoomyn);
            graphics.drawRect(this._zoomx - 15 - n7, this._zoomy - 15 - n8, 30 + n7 * 2, 30 + n8 * 2);
            graphics.setPaintMode();
            double d = (double)Math.abs(this._zoomx - n) / 30.0;
            double d3 = (double)Math.abs(this._zoomy - n2) / 30.0;
            double d4 = this._xMax + (this._xMax - this._xMin) * d;
            double d5 = this._xMin - (this._xMax - this._xMin) * d;
            double d6 = this._yMax + (this._yMax - this._yMin) * d3;
            double d7 = this._yMin - (this._yMax - this._yMin) * d3;
            this.zoom(d5, d7, d4, d6);
            bl = true;
        } else if (!this._drawn) {
            bl = true;
        }
        this._drawn = false;
        this._zoomout = false;
        this._zoomin = false;
        this._zoomy = -1;
        this._zoomx = -1;
        this._zoomyn = -1;
        this._zoomxn = -1;
    }

    synchronized void _zoomBox(int n, int n2) {
        if (!this._zooming) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        if (this._zoomx != -1 || this._zoomy != -1) {
            if (!this._zoomin && !this._zoomout) {
                if (n2 < this._zoomy) {
                    this._zoomout = true;
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15, this._zoomy - 15, 30, 30);
                } else if (n2 > this._zoomy) {
                    this._zoomin = true;
                }
            }
            if (this._zoomin) {
                int n3;
                int n4;
                int n5;
                int n6;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    n6 = Math.min(this._zoomx, this._zoomxn);
                    n5 = Math.max(this._zoomx, this._zoomxn);
                    n4 = Math.min(this._zoomy, this._zoomyn);
                    n3 = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(n6, n4, n5 - n6, n3 - n4);
                }
                if (n2 > this._zoomy) {
                    this._zoomxn = n;
                    this._zoomyn = n2;
                    n6 = Math.min(this._zoomx, this._zoomxn);
                    n5 = Math.max(this._zoomx, this._zoomxn);
                    n4 = Math.min(this._zoomy, this._zoomyn);
                    n3 = Math.max(this._zoomy, this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(n6, n4, n5 - n6, n3 - n4);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            } else if (this._zoomout) {
                int n7;
                int n8;
                if ((this._zoomxn != -1 || this._zoomyn != -1) && this._drawn) {
                    n8 = Math.abs(this._zoomx - this._zoomxn);
                    n7 = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - n8, this._zoomy - 15 - n7, 30 + n8 * 2, 30 + n7 * 2);
                }
                if (n2 < this._zoomy) {
                    this._zoomxn = n;
                    this._zoomyn = n2;
                    n8 = Math.abs(this._zoomx - this._zoomxn);
                    n7 = Math.abs(this._zoomy - this._zoomyn);
                    graphics.setXORMode(_boxColor);
                    graphics.drawRect(this._zoomx - 15 - n8, this._zoomy - 15 - n7, 30 + n8 * 2, 30 + n7 * 2);
                    this._drawn = true;
                    return;
                }
                this._drawn = false;
            }
        }
        graphics.setPaintMode();
    }

    synchronized void _zoomStart(int n, int n2) {
        if (n2 > this._lry) {
            n2 = this._lry;
        }
        if (n2 < this._uly) {
            n2 = this._uly;
        }
        if (n > this._lrx) {
            n = this._lrx;
        }
        if (n < this._ulx) {
            n = this._ulx;
        }
        this._zoomx = n;
        this._zoomy = n2;
        this._zooming = true;
    }

    public Image getOffscreenBuffer() {
        return this._buffer;
    }

    public class ZoomListener
    implements MouseListener {
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 || mouseEvent.getModifiers() == 0) {
                PlotBox.this._zoomStart(mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0 || mouseEvent.getModifiers() == 0) {
                // empty if block
            }
        }
    }

    class FillButtonListener
    implements ActionListener {
        FillButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlotBox.this.fillPlot();
        }
    }
}

