/*
 * Decompiled with CFR 0.152.
 */
package ptolemy;

import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintWriter;
import java.util.Vector;
import ptolemy.PlotBox;
import ptolemy.PlotPoint;
import starlogo.LineWidget;

public class Plot
extends PlotBox {
    public int mycount = 1;
    public LineWidget lw;
    protected int _currentdataset = -1;
    protected Vector _points = new Vector();
    protected int _marks;
    protected boolean _painted = false;
    private int _pointsPersistence = 0;
    private int _sweepsPersistence = 0;
    private boolean _bars = false;
    private double _barwidth = 0.5;
    private double _baroffset = 0.05;
    private boolean _connected = true;
    private boolean _impulses = false;
    private int _maxdataset = -1;
    private boolean _reusedatasets = false;
    private boolean _firstinset = true;
    private boolean _sawfirstdataset = false;
    private int _radius = 3;
    private int _diameter = 6;
    private Vector _prevx = new Vector();
    private Vector _prevy = new Vector();
    private static final int _ERRORBAR_LEG_LENGTH = 5;
    private static final int _MAX_MARKS = 10;
    private boolean _xyInvalid = false;
    private String _filename = null;
    private boolean _showing = false;
    private Vector _formats = new Vector();
    public int type = 1;
    public int num = 1;

    public void addLegend(int n, String string) {
        this._checkDatasetIndex(n);
        super.addLegend(n, string);
    }

    public PlotBox copy(LineWidget lineWidget, Plot plot) {
        super.copy(lineWidget, plot);
        plot.mycount = this.mycount;
        plot.lw = lineWidget;
        plot._currentdataset = this._currentdataset;
        plot._marks = this._marks;
        plot._painted = this._painted;
        plot._pointsPersistence = this._pointsPersistence;
        plot._sweepsPersistence = this._sweepsPersistence;
        plot._bars = this._bars;
        plot._connected = this._connected;
        plot._barwidth = this._barwidth;
        plot._baroffset = this._baroffset;
        plot._impulses = this._impulses;
        plot._maxdataset = this._maxdataset;
        plot._reusedatasets = plot._reusedatasets;
        plot._firstinset = this._firstinset;
        plot._sawfirstdataset = this._sawfirstdataset;
        plot._radius = this._radius;
        plot._diameter = this._diameter;
        plot._xyInvalid = this._xyInvalid;
        plot._filename = this._filename;
        plot._showing = this._showing;
        int n = this._prevx.size();
        plot._prevx = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            plot._prevx.addElement(this._prevx.elementAt(n2));
            ++n2;
        }
        n = this._prevy.size();
        plot._prevy = new Vector(n);
        int n3 = 0;
        while (n3 < n) {
            plot._prevy.addElement(this._prevy.elementAt(n3));
            ++n3;
        }
        n = this._formats.size();
        plot._formats = new Vector(n);
        int n4 = 0;
        while (n4 < n) {
            plot._formats.addElement(((Format)this._formats.elementAt(n4)).copy());
            ++n4;
        }
        n = this._points.size();
        plot._points = new Vector(n);
        int n5 = 0;
        while (n5 < n) {
            Vector vector = (Vector)this._points.elementAt(n5);
            int n6 = vector.size();
            Vector<PlotPoint> vector2 = new Vector<PlotPoint>(n6);
            int n7 = 0;
            while (n7 < n6) {
                vector2.addElement(((PlotPoint)vector.elementAt(n7)).copy());
                ++n7;
            }
            plot._points.addElement(vector2);
            ++n5;
        }
        return plot;
    }

    public synchronized void addPoint(int n, double d, double d2, boolean bl) {
        if (this._xlog) {
            if (d <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + d);
                return;
            }
            d = Math.log(d) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (d2 <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + d2);
                return;
            }
            d2 = Math.log(d2) * PlotBox._LOG10SCALE;
        }
        this._addPoint(n, d, d2, bl);
    }

    public synchronized void addPointWithErrorBars(int n, double d, double d2, double d3, double d4, boolean bl) {
        if (this._xlog) {
            if (d <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + d);
                return;
            }
            d = Math.log(d) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (d2 <= 0.0 || d3 <= 0.0 || d4 <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + d2);
                return;
            }
            d2 = Math.log(d2) * PlotBox._LOG10SCALE;
            d3 = Math.log(d3) * PlotBox._LOG10SCALE;
            d4 = Math.log(d4) * PlotBox._LOG10SCALE;
        }
        this._addPoint(n, d, d2, bl);
    }

    public synchronized void clear(boolean bl, boolean bl2, boolean bl3) {
        super.clear(bl, bl2, bl3);
        this._currentdataset = -1;
        int n = this._points.size();
        this._points = new Vector();
        this._prevx = new Vector();
        this._prevy = new Vector();
        this._painted = false;
        this._maxdataset = -1;
        this._firstinset = true;
        this._sawfirstdataset = false;
        this._xyInvalid = false;
        this._filename = null;
        this._showing = false;
        if (bl) {
            this._formats = new Vector();
            this._marks = 0;
            this._pointsPersistence = 0;
            this._sweepsPersistence = 0;
            this._bars = false;
            this._barwidth = 0.5;
            this._baroffset = 0.05;
            this._connected = true;
            this._impulses = false;
            this._reusedatasets = false;
        }
    }

    public synchronized void clear(int n) {
        this._checkDatasetIndex(n);
        this._points.setElementAt(new Vector(), n);
    }

    public synchronized void erasePoint(int n, int n2) {
        PlotPoint plotPoint;
        Vector vector;
        this._checkDatasetIndex(n);
        if (this.isShowing()) {
            this._erasePoint(this.getGraphics(), n, n2);
        }
        if ((vector = (Vector)this._points.elementAt(n)) != null && (plotPoint = (PlotPoint)vector.elementAt(n2)) != null) {
            if (plotPoint.x == this._xBottom || plotPoint.x == this._xTop || plotPoint.y == this._yBottom || plotPoint.y == this._yTop) {
                this._xyInvalid = true;
            }
            vector.removeElementAt(n2);
        }
    }

    public synchronized void fillPlot() {
        if (this._xyInvalid) {
            this._xBottom = Double.MAX_VALUE;
            this._xTop = -4.9E-324;
            this._yBottom = Double.MAX_VALUE;
            this._yTop = -4.9E-324;
            int n = 0;
            while (n < this._points.size()) {
                Vector vector = (Vector)this._points.elementAt(n);
                int n2 = 0;
                while (n2 < vector.size()) {
                    PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
                    if (plotPoint.x < this._xBottom) {
                        this._xBottom = plotPoint.x;
                    }
                    if (plotPoint.x > this._xTop) {
                        this._xTop = plotPoint.x;
                    }
                    if (plotPoint.y < this._yBottom) {
                        this._yBottom = plotPoint.y;
                    }
                    if (plotPoint.y > this._yTop) {
                        this._yTop = plotPoint.y;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        this._xyInvalid = false;
        if (this._bars) {
            if (this._yBottom > 0.0) {
                this._yBottom = 0.0;
            }
            if (this._yTop < 0.0) {
                this._yTop = 0.0;
            }
        }
        super.fillPlot();
    }

    public boolean getConnected() {
        return this._connected;
    }

    public boolean getImpulses() {
        return this._impulses;
    }

    public String getMarksStyle() {
        if (this._marks == 0) {
            return "none";
        }
        if (this._marks == 1) {
            return "points";
        }
        if (this._marks == 2) {
            return "dots";
        }
        return "various";
    }

    public int getMaxDataSets() {
        return Integer.MAX_VALUE;
    }

    public int getNumDataSets() {
        return this._points.size();
    }

    public void setBars(boolean bl) {
        this._bars = bl;
    }

    public void setBars(double d, double d2) {
        this._barwidth = d;
        this._baroffset = d2;
        this._bars = true;
    }

    public void setConnected(boolean bl) {
        this._connected = bl;
    }

    public void setConnected(boolean bl, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        format.connected = bl;
        format.connectedUseDefault = false;
    }

    public void setImpulses(boolean bl) {
        this._impulses = bl;
    }

    public void setImpulses(boolean bl, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        format.impulses = bl;
        format.impulsesUseDefault = false;
    }

    public void setMarksStyle(String string) {
        if (string.equalsIgnoreCase("none")) {
            this._marks = 0;
        } else if (string.equalsIgnoreCase("points")) {
            this._marks = 1;
        } else if (string.equalsIgnoreCase("dots")) {
            this._marks = 2;
        } else if (string.equalsIgnoreCase("various")) {
            this._marks = 3;
        }
    }

    public void setMarksStyle(String string, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        if (string.equalsIgnoreCase("none")) {
            format.marks = 0;
        } else if (string.equalsIgnoreCase("points")) {
            format.marks = 1;
        } else if (string.equalsIgnoreCase("dots")) {
            format.marks = 2;
        } else if (string.equalsIgnoreCase("various")) {
            format.marks = 3;
        }
        format.marksUseDefault = false;
    }

    public void setNumSets(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of data sets (" + n + ") must be greater than 0.");
        }
        this._currentdataset = -1;
        this._points.removeAllElements();
        this._formats.removeAllElements();
        this._prevx.removeAllElements();
        this._prevy.removeAllElements();
        int n2 = 0;
        while (n2 < n) {
            this._points.addElement(new Vector());
            this._formats.addElement(new Format());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
            ++n2;
        }
    }

    public void setPointsPersistence(int n) {
        this._pointsPersistence = n;
    }

    public void setReuseDatasets(boolean bl) {
        this._reusedatasets = bl;
    }

    public void setSweepsPersistence(int n) {
        this._sweepsPersistence = n;
    }

    /*
     * Unable to fully structure code
     */
    protected void _checkDatasetIndex(int var1_1) {
        if (var1_1 >= 0) ** GOTO lbl7
        throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
lbl-1000:
        // 1 sources

        {
            this._points.addElement(new Vector<E>());
            this._formats.addElement(new Format());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
lbl7:
            // 2 sources

            ** while (var1_1 >= this._points.size())
        }
lbl8:
        // 1 sources

    }

    protected void _drawBar(Graphics graphics, int n, long l, long l2, boolean bl) {
        if (bl) {
            if (l2 < (long)this._uly) {
                l2 = this._uly;
            }
            if (l2 > (long)this._lry) {
                l2 = this._lry;
            }
        }
        if (l2 <= (long)this._lry && l <= (long)this._lrx && l >= (long)this._ulx) {
            long l3;
            int n2 = (int)((double)l - this._barwidth * this._xscale / 2.0 + (double)n * this._baroffset * this._xscale);
            int n3 = (int)((double)n2 + this._barwidth * this._xscale);
            if (n2 < this._ulx) {
                n2 = this._ulx;
            }
            if (n3 > this._lrx) {
                n3 = this._lrx;
            }
            if (n2 >= n3) {
                n3 = n2 + 1;
            }
            if ((long)this._lry < (l3 = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                l3 = this._lry;
            }
            if ((long)this._uly > l3) {
                l3 = this._uly;
            }
            if (this._yMin >= 0.0 || l2 <= l3) {
                graphics.fillRect(n2, (int)l2, n3 - n2, (int)(l3 - l2));
            } else {
                graphics.fillRect(n2, (int)l3, n3 - n2, (int)(l2 - l3));
            }
            graphics.setColor(Color.black);
        }
    }

    protected void _drawErrorBar(Graphics graphics, int n, long l, long l2, long l3, boolean bl) {
        this._drawLine(graphics, n, l - 5L, l3, l + 5L, l3, bl);
        this._drawLine(graphics, n, l, l2, l, l3, bl);
        this._drawLine(graphics, n, l - 5L, l2, l + 5L, l2, bl);
    }

    protected void _drawImpulse(Graphics graphics, long l, long l2, boolean bl) {
        if (bl) {
            if (l2 < (long)this._uly) {
                l2 = this._uly;
            }
            if (l2 > (long)this._lry) {
                l2 = this._lry;
            }
        }
        if (l2 <= (long)this._lry && l <= (long)this._lrx && l >= (long)this._ulx) {
            double d = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale);
            if ((double)this._lry < d) {
                d = this._lry;
            }
            if ((double)this._uly > d) {
                d = this._uly;
            }
            graphics.drawLine((int)l, (int)l2, (int)l, (int)d);
        }
    }

    protected void _drawLine(Graphics graphics, int n, long l, long l2, long l3, long l4, boolean bl) {
        if (bl) {
            if (!(l3 <= (long)this._ulx && l <= (long)this._ulx || l3 >= (long)this._lrx && l >= (long)this._lrx || l4 <= (long)this._uly && l2 <= (long)this._uly || l4 >= (long)this._lry && l2 >= (long)this._lry)) {
                if (l != l3) {
                    if (l3 < (long)this._ulx) {
                        l4 = (int)(l4 + (l2 - l4) * ((long)this._ulx - l3) / (l - l3));
                        l3 = this._ulx;
                    } else if (l3 > (long)this._lrx) {
                        l4 = (int)(l4 + (l2 - l4) * ((long)this._lrx - l3) / (l - l3));
                        l3 = this._lrx;
                    }
                }
                if (l2 != l4) {
                    if (l4 < (long)this._uly) {
                        l3 = (int)(l3 + (l - l3) * ((long)this._uly - l4) / (l2 - l4));
                        l4 = this._uly;
                    } else if (l4 > (long)this._lry) {
                        l3 = (int)(l3 + (l - l3) * ((long)this._lry - l4) / (l2 - l4));
                        l4 = this._lry;
                    }
                }
                if (l != l3) {
                    if (l < (long)this._ulx) {
                        l2 = (int)(l2 + (l4 - l2) * ((long)this._ulx - l) / (l3 - l));
                        l = this._ulx;
                    } else if (l > (long)this._lrx) {
                        l2 = (int)(l2 + (l4 - l2) * ((long)this._lrx - l) / (l3 - l));
                        l = this._lrx;
                    }
                }
                if (l2 != l4) {
                    if (l2 < (long)this._uly) {
                        l = (int)(l + (l3 - l) * ((long)this._uly - l2) / (l4 - l2));
                        l2 = this._uly;
                    } else if (l2 > (long)this._lry) {
                        l = (int)(l + (l3 - l) * ((long)this._lry - l2) / (l4 - l2));
                        l2 = this._lry;
                    }
                }
            }
            if (l3 >= (long)this._ulx && l3 <= (long)this._lrx && l4 >= (long)this._uly && l4 <= (long)this._lry && l >= (long)this._ulx && l <= (long)this._lrx && l2 >= (long)this._uly && l2 <= (long)this._lry) {
                graphics.drawLine((int)l, (int)l2, (int)l3, (int)l4);
            }
        } else {
            graphics.drawLine((int)l, (int)l2, (int)l3, (int)l4);
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        super._drawPlot(graphics, bl);
        this._showing = true;
        int n = this._points.size() - 1;
        while (n >= 0) {
            Vector vector = (Vector)this._points.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                this._drawPlotPoint(graphics, n, n2);
                ++n2;
            }
            --n;
        }
        this._painted = true;
        this.notifyAll();
    }

    protected void _drawPoint(Graphics graphics, int n, long l, long l2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = l2 <= (long)this._lry && l2 >= (long)this._uly && l <= (long)this._lrx && l >= (long)this._ulx;
        if (!bl || bl2) {
            int n2 = (int)l;
            int n3 = (int)l2;
            Format format = (Format)this._formats.elementAt(n);
            int n4 = this._marks;
            if (!format.marksUseDefault) {
                n4 = format.marks;
            } else {
                switch (n4) {
                    case 0: {
                        graphics.fillRect(n2 - 6, n3 - 6, 6, 6);
                        break;
                    }
                    case 1: {
                        graphics.fillOval(n2 - 1, n3 - 1, 3, 3);
                        break;
                    }
                    case 2: {
                        graphics.fillOval(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                        break;
                    }
                    case 3: {
                        int n5 = n % 10;
                        switch (n5) {
                            case 0: {
                                graphics.fillOval(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 1: {
                                graphics.drawLine(n2 - this._radius, n3 - this._radius, n2 + this._radius, n3 + this._radius);
                                graphics.drawLine(n2 + this._radius, n3 - this._radius, n2 - this._radius, n3 + this._radius);
                                break;
                            }
                            case 2: {
                                graphics.drawRect(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 3: {
                                int[] nArray = new int[4];
                                int[] nArray2 = new int[4];
                                nArray[0] = n2;
                                nArray2[0] = n3 - this._radius;
                                nArray[1] = n2 + this._radius;
                                nArray2[1] = n3 + this._radius;
                                nArray[2] = n2 - this._radius;
                                nArray2[2] = n3 + this._radius;
                                nArray[3] = n2;
                                nArray2[3] = n3 - this._radius;
                                graphics.fillPolygon(nArray, nArray2, 4);
                                break;
                            }
                            case 4: {
                                int[] nArray = new int[5];
                                int[] nArray3 = new int[5];
                                nArray[0] = n2;
                                nArray3[0] = n3 - this._radius;
                                nArray[1] = n2 + this._radius;
                                nArray3[1] = n3;
                                nArray[2] = n2;
                                nArray3[2] = n3 + this._radius;
                                nArray[3] = n2 - this._radius;
                                nArray3[3] = n3;
                                nArray[4] = n2;
                                nArray3[4] = n3 - this._radius;
                                graphics.drawPolygon(nArray, nArray3, 5);
                                break;
                            }
                            case 5: {
                                graphics.drawOval(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 6: {
                                graphics.drawLine(n2, n3 - this._radius, n2, n3 + this._radius);
                                graphics.drawLine(n2 - this._radius, n3, n2 + this._radius, n3);
                                break;
                            }
                            case 7: {
                                graphics.fillRect(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                                break;
                            }
                            case 8: {
                                int[] nArray = new int[4];
                                int[] nArray4 = new int[4];
                                nArray[0] = n2;
                                nArray4[0] = n3 - this._radius;
                                nArray[1] = n2 + this._radius;
                                nArray4[1] = n3 + this._radius;
                                nArray[2] = n2 - this._radius;
                                nArray4[2] = n3 + this._radius;
                                nArray[3] = n2;
                                nArray4[3] = n3 - this._radius;
                                graphics.drawPolygon(nArray, nArray4, 4);
                                break;
                            }
                            case 9: {
                                int[] nArray = new int[5];
                                int[] nArray5 = new int[5];
                                nArray[0] = n2;
                                nArray5[0] = n3 - this._radius;
                                nArray[1] = n2 + this._radius;
                                nArray5[1] = n3;
                                nArray[2] = n2;
                                nArray5[2] = n3 + this._radius;
                                nArray[3] = n2 - this._radius;
                                nArray5[3] = n3;
                                nArray[4] = n2;
                                nArray5[4] = n3 - this._radius;
                                graphics.fillPolygon(nArray, nArray5, 5);
                            }
                        }
                        break;
                    }
                }
            }
        }
    }

    protected void _write(PrintWriter printWriter) {
        super._write(printWriter);
        if (this._reusedatasets) {
            printWriter.println("<reuseDatasets/>");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this._connected) {
            stringBuffer.append(" connected=\"no\"");
        }
        switch (this._marks) {
            case 1: {
                stringBuffer.append(" marks=\"points\"");
                break;
            }
            case 2: {
                stringBuffer.append(" marks=\"dots\"");
                break;
            }
            case 3: {
                stringBuffer.append(" marks=\"various\"");
            }
        }
        if (this._impulses) {
            stringBuffer.append(" stems=\"yes\"");
        }
        if (stringBuffer.length() > 0) {
            printWriter.println("<default" + stringBuffer.toString() + "/>");
        }
        if (this._bars) {
            printWriter.println("<barGraph width=\"" + this._barwidth + "\" offset=\"" + this._baroffset + "\"/>");
        }
        int n = 0;
        while (n < this._points.size()) {
            String string;
            StringBuffer stringBuffer2 = new StringBuffer();
            Format format = (Format)this._formats.elementAt(n);
            if (!format.connectedUseDefault) {
                if (this._isConnected(n)) {
                    stringBuffer2.append(" connected=\"yes\"");
                } else {
                    stringBuffer2.append(" connected=\"no\"");
                }
            }
            if (!format.impulsesUseDefault) {
                if (format.impulses) {
                    stringBuffer2.append(" stems=\"yes\"");
                } else {
                    printWriter.println(" stems=\"no\"");
                }
            }
            if (!format.marksUseDefault) {
                switch (format.marks) {
                    case 0: {
                        stringBuffer2.append(" marks=\"none\"");
                    }
                    case 1: {
                        stringBuffer2.append(" marks=\"points\"");
                    }
                    case 2: {
                        stringBuffer2.append(" marks=\"dots\"");
                    }
                    case 3: {
                        stringBuffer2.append(" marks=\"various\"");
                    }
                }
            }
            if ((string = this.getLegend(n)) != null) {
                stringBuffer2.append(" name=\"" + this.getLegend(n) + "\"");
            }
            printWriter.println("<dataset" + stringBuffer2.toString() + ">");
            Vector vector = (Vector)this._points.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
                if (!plotPoint.connected) {
                    printWriter.print("<m ");
                } else {
                    printWriter.print("<p ");
                }
                printWriter.print("x=\"" + plotPoint.x + "\" y=\"" + plotPoint.y + "\"");
                printWriter.println("/>");
                ++n2;
            }
            printWriter.println("</dataset>");
            ++n;
        }
    }

    private boolean _addLegendIfNecessary(boolean bl) {
        if (!(this._sawfirstdataset && this._currentdataset >= 0 || this._reusedatasets)) {
            this._sawfirstdataset = true;
            ++this._currentdataset;
        }
        if (!this._sawfirstdataset && this.getLegend(this._currentdataset) == null) {
            this._firstinset = true;
            this._sawfirstdataset = true;
            this.addLegend(this._currentdataset, new String("Set " + this._currentdataset));
        }
        if (this._firstinset && !this._reusedatasets) {
            bl = false;
            this._firstinset = false;
        }
        return bl;
    }

    private synchronized void _addPoint(int n, double d, double d2, boolean bl) {
        this._checkDatasetIndex(n);
        if (this._wrap && this._xRangeGiven) {
            double d3 = this._xhighgiven - this._xlowgiven;
            if (d < this._xlowgiven) {
                d += d3 * Math.floor(1.0 + (this._xlowgiven - d) / d3);
            } else if (d > this._xhighgiven && (d -= d3 * Math.floor(1.0 + (d - this._xhighgiven) / d3)) == this._xlowgiven) {
                d = this._xhighgiven;
            }
        }
        if (d < this._xBottom) {
            this._xBottom = d;
        }
        if (d > this._xTop) {
            this._xTop = d;
        }
        if (d2 < this._yBottom) {
            this._yBottom = d2;
        }
        if (d2 > this._yTop) {
            this._yTop = d2;
        }
        if (this.type == 0) {
            this._yBottom = 0.0;
        }
        PlotPoint plotPoint = new PlotPoint();
        plotPoint.x = d;
        plotPoint.y = d2;
        plotPoint.connected = bl && this._isConnected(n);
        Vector vector = (Vector)this._points.elementAt(n);
        int n2 = vector.size();
        if (n2 == 0) {
            plotPoint.connected = false;
        } else if (this._wrap && this._xRangeGiven) {
            PlotPoint plotPoint2 = (PlotPoint)vector.elementAt(n2 - 1);
            if (plotPoint2.x > d) {
                plotPoint.connected = false;
            }
        }
        vector.addElement(plotPoint);
        if (this._pointsPersistence > 0 && n2 > this._pointsPersistence) {
            this.erasePoint(n, 0);
        }
        if (this._showing && this.type != 3) {
            this.num = 0;
        }
        ++this.num;
        if (this._wrap && this._xRangeGiven && d == this._xhighgiven) {
            this._addPoint(n, this._xlowgiven, d2, false);
        }
    }

    private synchronized void _drawPlotPoint(Graphics graphics, int n, int n2) {
        if (this._pointsPersistence > 0) {
            graphics.setXORMode(this._background);
        }
        if (this._usecolor) {
            int n3 = n % this._colors.length;
            graphics.setColor(this._colors[n3]);
        } else {
            graphics.setColor(this._foreground);
        }
        Vector vector = (Vector)this._points.elementAt(n);
        PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
        long l = (long)this._lry - (long)((plotPoint.y - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((plotPoint.x - this._xMin) * this._xscale);
        long l3 = (Long)this._prevx.elementAt(n);
        long l4 = (Long)this._prevy.elementAt(n);
        if (plotPoint.connected) {
            this._drawLine(graphics, n, l2, l, l3, l4, true);
        }
        this._prevx.setElementAt(new Long(l2), n);
        this._prevy.setElementAt(new Long(l), n);
        Format format = (Format)this._formats.elementAt(n);
        if (format.impulsesUseDefault) {
            if (this._impulses) {
                this._drawImpulse(graphics, l2, l, true);
            }
        } else if (format.impulses) {
            this._drawImpulse(graphics, l2, l, true);
        }
        int n4 = this._marks;
        if (!format.marksUseDefault) {
            n4 = format.marks;
        }
        if (n4 != 0) {
            this._drawPoint(graphics, n, l2, l, true);
        }
        if (this._bars) {
            graphics.setColor(this._colors[(int)plotPoint.x]);
            this._drawBar(graphics, n, l2, l, false);
        }
        graphics.setColor(this._foreground);
        if (this._pointsPersistence > 0) {
            graphics.setPaintMode();
        }
    }

    public void setupLineWidget(LineWidget lineWidget) {
        this.lw = lineWidget;
    }

    private synchronized void _erasePoint(Graphics graphics, int n, int n2) {
        int n3;
        Object object;
        if (this._pointsPersistence > 0) {
            graphics.setXORMode(this._background);
        }
        if (this._usecolor) {
            int n4 = n % this._colors.length;
            graphics.setColor(this._colors[n4]);
        } else {
            graphics.setColor(this._foreground);
        }
        Vector vector = (Vector)this._points.elementAt(n);
        PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
        long l = (long)this._lry - (long)((plotPoint.y - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((plotPoint.x - this._xMin) * this._xscale);
        if (n2 < vector.size() - 1) {
            object = (PlotPoint)vector.elementAt(n2 + 1);
            n3 = this._ulx + (int)((((PlotPoint)object).x - this._xMin) * this._xscale);
            int n5 = this._lry - (int)((((PlotPoint)object).y - this._yMin) * this._yscale);
            if (((PlotPoint)object).connected) {
                this._drawLine(graphics, n, n3, n5, l2, l, true);
            }
            ((PlotPoint)object).connected = false;
        }
        object = (Format)this._formats.elementAt(n);
        if (((Format)object).impulsesUseDefault) {
            if (this._impulses) {
                this._drawImpulse(graphics, l2, l, true);
            }
        } else if (((Format)object).impulses) {
            this._drawImpulse(graphics, l2, l, true);
        }
        n3 = this._marks;
        if (!((Format)object).marksUseDefault) {
            n3 = ((Format)object).marks;
        }
        if (n3 != 0) {
            this._drawPoint(graphics, n, l2, l, true);
        }
        if (this._bars) {
            graphics.setColor(this._colors[(int)plotPoint.x]);
            this._drawBar(graphics, n, l2, l, true);
        }
        graphics.setColor(this._foreground);
        if (this._pointsPersistence > 0) {
            graphics.setPaintMode();
        }
    }

    private boolean _isConnected(int n) {
        if (n < 0) {
            return this._connected;
        }
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        if (format.connectedUseDefault) {
            return this._connected;
        }
        return format.connected;
    }

    private class Format {
        public boolean connected;
        public boolean connectedUseDefault = true;
        public boolean impulses;
        public boolean impulsesUseDefault = true;
        public int marks;
        public boolean marksUseDefault = true;

        private Format() {
        }

        public Format copy() {
            Format format = new Format();
            format.connected = this.connected;
            format.connectedUseDefault = this.connectedUseDefault;
            format.impulses = this.impulses;
            format.impulsesUseDefault = this.impulsesUseDefault;
            format.marks = this.marks;
            format.marksUseDefault = this.marksUseDefault;
            return format;
        }
    }
}

