/*
 * Decompiled with CFR 0.152.
 */
package ptolemy;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import ptolemy.HistoLive;
import ptolemy.LineLive;
import ptolemy.Plot;
import ptolemy.PlotBox;
import ptolemy.PlotPoint;
import starlogo.Application;
import starlogo.DoubleInsets;
import starlogo.JSLMenu;
import starlogo.LineWidget;
import starlogo.MenuListener;
import starlogo.NSLMenu;
import starlogo.PlotDialog;
import starlogo.Print;
import starlogo.PrintDialog;
import starlogo.PrintingCanceledException;
import starlogo.PtolemyBarDialog;
import starlogo.SLMenu;
import starlogo.StarLogo;
import starlogo.StarLogoFrame;
import yoyo.YoYo;

public class LineChart
extends JFrame
implements StarLogoFrame,
MenuListener {
    public PlotBox framePlot;
    public PlotBox widgetPlot;
    protected Application app;
    protected int cindex;
    protected int idCount;
    protected int type;
    protected LineWidget lw;
    protected Vector sets;
    protected PtolemyBarDialog gsd = null;
    protected PlotDialog pd = null;
    protected SLMenu slmenu = null;
    protected String preTitle;
    public boolean autoscale = true;
    static /* synthetic */ Class class$starlogo$LineWidget;

    public LineChart copy(Application application, LineWidget lineWidget) {
        LineChart lineChart = new LineChart(application, lineWidget.id, lineWidget.id, lineWidget.sets, lineWidget.type, lineWidget);
        if (this.type != 2) {
            lineChart.framePlot = ((LineLive)this.framePlot).copy(lineWidget);
            lineChart.widgetPlot = ((LineLive)this.widgetPlot).copy(lineWidget);
        } else {
            lineChart.framePlot = ((HistoLive)this.framePlot).copy(lineWidget);
            lineChart.widgetPlot = ((HistoLive)this.widgetPlot).copy(lineWidget);
        }
        lineChart.autoscale = this.autoscale;
        return lineChart;
    }

    public LineChart(Application application, int n, int n2, Vector vector, int n3, LineWidget lineWidget) {
        super("StarLogo Plot");
        this.app = application;
        this.type = n3;
        this.cindex = n;
        this.idCount = n2;
        this.lw = lineWidget;
        this.sets = vector;
        this.preTitle = lineWidget.id + ". ";
        if (n3 == 2) {
            this.framePlot = new HistoLive(lineWidget, n3);
            this.widgetPlot = new HistoLive(lineWidget, n3);
        } else {
            this.framePlot = new LineLive(lineWidget, n3);
            this.widgetPlot = new LineLive(lineWidget, n3);
        }
        ImageIcon imageIcon = new ImageIcon((class$starlogo$LineWidget == null ? (class$starlogo$LineWidget = LineChart.class$("starlogo.LineWidget")) : class$starlogo$LineWidget).getResource("gifs/icon.gif"));
        this.setIconImage(imageIcon.getImage());
        this.framePlot.setTitle("Plot " + n2, this.preTitle);
        this.widgetPlot.setColor(true);
        this.widgetPlot.setGrid(false);
        this.widgetPlot.setAxes(false);
        this.widgetPlot.addYTick("", 0.0);
        if (n3 == 1) {
            this.widgetPlot.addXTick("", 0.0);
            ((LineLive)this.widgetPlot).setMarksStyle("none");
        }
        this.slmenu = YoYo.macintoshp && !YoYo.macosxp ? new NSLMenu(this, this.app) : new JSLMenu(this, this.app);
        this.slmenu.disableMoreEditMenu();
        this.slmenu.setMenuBar(this);
        this.app.addWindow(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                LineChart.this.app.removeWindow(LineChart.this);
                LineChart.this.setVisible(false);
            }
        });
        this.getContentPane().add("Center", this.framePlot);
        this.getContentPane().setBackground(Color.white);
        this.getContentPane().setForeground(Color.white);
        this.setSize(500, 300);
        this.addNotify();
    }

    public void initWidgetPlot() {
        Frame frame = new Frame();
        frame.setLayout(null);
        frame.add(this.widgetPlot);
        frame.addNotify();
        frame.setSize(this.widgetPlot.getSize().width, this.widgetPlot.getSize().height);
    }

    public void _data() {
        if (StarLogo.DEBUG) {
            System.out.println("Data...");
        }
        if (this.gsd == null) {
            this.gsd = Application.createPtolemyBarDialog(this, this.sets, this.app, this.type, this.idCount);
        }
        this.gsd.show();
        if (this.gsd.pressedOK()) {
            this.gsd.getValues(this.lw, this);
            this.app.rancompilerp = false;
            this.app.project.markChanged();
            this.repaintWithInterface();
        }
    }

    public void _properties() {
        this.lw.sl.stopAll();
        if (this.pd == null) {
            this.pd = Application.createPlotDialog(this, this.type, this.framePlot, this.lw, this.app);
        }
        this.pd.show();
        if (this.pd.pressedOK()) {
            this.pd.getValues(this.lw, this.framePlot);
            this.pd.getValues(this.lw, this.widgetPlot);
            this.setTitle(LineWidget.getType(this.type) + this.framePlot.getTitle());
            this.app.rancompilerp = false;
            this.app.project.markChanged();
            this.repaintWithInterface();
        }
    }

    public void markChanged() {
    }

    public void clearChanged() {
    }

    public void setPlotTitle(String string) {
        this.setTitle(string);
        this.framePlot.setTitle(string, this.preTitle);
        this.widgetPlot.setTitle(string, this.preTitle);
    }

    public String getPreTitle() {
        return this.preTitle;
    }

    public String getTitle() {
        return this.framePlot.getTitle();
    }

    public String getPlotTitle() {
        return this.framePlot.getTitle();
    }

    public void setXLabel(String string) {
        this.framePlot.setXLabel(string);
        this.widgetPlot.setXLabel(string);
    }

    public void setXMin(double d) {
        this.framePlot._setXRange(d, this.framePlot.getXRange()[1]);
        this.widgetPlot._setXRange(d, this.widgetPlot.getXRange()[1]);
    }

    public void setYMin(double d) {
        this.framePlot._setYRange(d, this.framePlot.getYRange()[1]);
        this.widgetPlot._setYRange(d, this.widgetPlot.getYRange()[1]);
    }

    public void setXMax(double d) {
        this.framePlot._setXRange(this.framePlot.getXRange()[0], d);
        this.widgetPlot._setXRange(this.widgetPlot.getXRange()[0], d);
    }

    public void setYMax(double d) {
        this.framePlot._setYRange(this.framePlot.getYRange()[0], d);
        this.widgetPlot._setYRange(this.widgetPlot.getYRange()[0], d);
    }

    public void setXRange(double d, double d2) {
        this.framePlot._setXRange(d, d2);
        this.widgetPlot._setXRange(d, d2);
    }

    public void setYRange(double d, double d2) {
        this.framePlot._setYRange(d, d2);
        this.widgetPlot._setYRange(d, d2);
    }

    public String getFrameXLabel() {
        return this.framePlot.getXLabel();
    }

    public void setYLabel(String string) {
        this.framePlot.setYLabel(string);
        this.widgetPlot.setYLabel(string);
    }

    public String getFrameYLabel() {
        return this.framePlot.getYLabel();
    }

    public double getPPXCor(int n) {
        return ((LineLive)this.framePlot).ppxcor(n);
    }

    public double getPPYCor(int n) {
        return ((LineLive)this.framePlot).ppycor(n);
    }

    public void clearLegend() {
        this.framePlot.clearLegend();
    }

    public void setGrid(boolean bl) {
        this.framePlot.setGrid(bl);
        this.widgetPlot.setGrid(bl);
    }

    public void setWidgetGrid(boolean bl) {
        this.widgetPlot.setGrid(bl);
    }

    public boolean getGrid() {
        return this.framePlot.getGrid();
    }

    public void setConnected(boolean bl) {
        ((Plot)this.widgetPlot).setConnected(bl);
    }

    public boolean getConnected() {
        return ((Plot)this.widgetPlot).getConnected();
    }

    public void ppd() {
        this.ppd(this.framePlot);
        this.ppd(this.widgetPlot);
    }

    public void ppd(PlotBox plotBox) {
        ((Plot)plotBox).setConnected(true);
        ((Plot)plotBox).setMarksStyle("none");
        this._setConnected((Plot)plotBox, true);
    }

    public void ppu() {
        this.ppu(this.framePlot);
        this.ppu(this.widgetPlot);
    }

    public void ppu(PlotBox plotBox) {
        ((Plot)plotBox).setConnected(false);
        ((Plot)plotBox).setMarksStyle("points");
        this._setConnected((Plot)plotBox, false);
    }

    public void setWidgetSize(int n, int n2) {
        this.widgetPlot.setSize(n, n2);
    }

    public Dimension getWidgetSize() {
        return this.widgetPlot.getSize();
    }

    public void setSLColor(int n, int n2) {
        this.framePlot._slcolors[n] = n2;
        this.widgetPlot._slcolors[n] = n2;
    }

    public int getSLColor(int n) {
        return this.framePlot._slcolors[n];
    }

    public void setColor(int n, Color color) {
        this.framePlot._colors[n] = color;
        this.widgetPlot._colors[n] = color;
    }

    public void setPointsPersistence(int n) {
        ((LineLive)this.framePlot).setPointsPersistence(n);
        ((LineLive)this.widgetPlot).setPointsPersistence(n);
    }

    public void setHistoNum(int n) {
        ((HistoLive)this.framePlot).setNum(n);
        ((HistoLive)this.widgetPlot).setNum(n);
    }

    public void setLineNum(int n) {
        ((LineLive)this.framePlot).setNum(n);
        ((LineLive)this.widgetPlot).setNum(n);
    }

    public int getLineNum() {
        return ((LineLive)this.framePlot).num;
    }

    public int getHistoNum() {
        return ((HistoLive)this.framePlot).num;
    }

    public double[] getHistoXRange() {
        return ((HistoLive)this.framePlot).getXRange();
    }

    public double[] getLineXRange() {
        return ((LineLive)this.framePlot).getXRange();
    }

    public double[] getWidgetXRange() {
        return this.widgetPlot.getXRange();
    }

    public double[] getWidgetYRange() {
        return this.widgetPlot.getYRange();
    }

    public double[] getFrameXRange() {
        return this.framePlot.getXRange();
    }

    public double[] getFrameYRange() {
        return this.framePlot.getYRange();
    }

    public void disableDataInFormatMenu() {
        this.slmenu.disableDataInFormatMenu();
    }

    public void addLegend(int n, String string) {
        this.framePlot.addLegend(n, string);
        this.repaintFrame();
    }

    public void repaintWithInterface() {
        this.repaint();
        this.app.iface.repaint(this.lw.position);
    }

    public void repaint() {
        this.repaintFrame();
        this.repaintWidget();
    }

    public void repaintFrame() {
        this.framePlot.repaint();
    }

    public void repaintWidget() {
    }

    public void reset() {
        double[] dArray = this.type == 2 ? this.getHistoXRange() : this.getLineXRange();
        this.framePlot.clear(false, this.autoscale, this.framePlot.getGrid());
        this.widgetPlot.clear(false, this.autoscale, this.widgetPlot.getGrid());
        if (this.type == 2) {
            this.setHistoTime(0.0);
        } else {
            this.setLiveTime(0.0);
        }
        if (this.type == 0) {
            this.explicitLineXRange(dArray[0], dArray[1]);
        }
        this.repaintWithInterface();
    }

    public void setHistoTime(double d) {
        ((HistoLive)this.framePlot).time = d;
        ((HistoLive)this.widgetPlot).time = d;
    }

    public void setLiveTime(double d) {
        ((LineLive)this.framePlot).time = d;
        ((LineLive)this.widgetPlot).time = d;
    }

    public void explicitLineXRange(double d, double d2) {
        ((LineLive)this.framePlot).explicitXRange(d, d2);
        ((LineLive)this.widgetPlot).explicitXRange(d, d2);
    }

    public void explicitWidgetXRange(double d, double d2) {
        this.widgetPlot.explicitXRange(d, d2);
    }

    public void removeHistoHashPoint(int n) {
        ((HistoLive)this.framePlot).removeHashPoint(n);
        ((HistoLive)this.widgetPlot).removeHashPoint(n);
    }

    public void removeLiveHashPoint(int n) {
        ((LineLive)this.framePlot).removeHashPoint(n);
        ((LineLive)this.widgetPlot).removeHashPoint(n);
    }

    public void addDataPoint(int n, double d) {
        ((LineLive)this.framePlot).addDataPoint(n, d);
        ((LineLive)this.widgetPlot).addDataPoint(n, d);
        if (this.autoscale) {
            this.framePlot.fillPlot();
            this.widgetPlot.fillPlot();
        }
    }

    public void addDataPoint(int n, double d, double d2) {
        ((LineLive)this.framePlot).addDataPoint(n, d, d2);
        ((LineLive)this.widgetPlot).addDataPoint(n, d, d2);
        if (this.autoscale) {
            this.framePlot.fillPlot();
            this.widgetPlot.fillPlot();
        }
    }

    public void addDataPointToHash(int n, int n2, double d, double d2) {
        ((LineLive)this.framePlot).addDataPointToHash(n, n2, d, d2);
        ((LineLive)this.widgetPlot).addDataPointToHash(n, n2, d, d2);
        if (this.autoscale) {
            this.framePlot.fillPlot();
            this.widgetPlot.fillPlot();
        }
    }

    public void addHistoDataPointToHash(int n, int n2, double d, int n3) {
        ((HistoLive)this.framePlot).addDataPointToHash(n, n2, d, n3);
        ((HistoLive)this.widgetPlot).addDataPointToHash(n, n2, d, n3);
        if (this.autoscale) {
            this.framePlot.fillPlot();
            this.widgetPlot.fillPlot();
        }
    }

    public Image getWidgetImage() {
        return this.widgetPlot.getOffscreenBuffer();
    }

    public void addXTick(String string, double d) {
        this.framePlot.addXTick(string, d);
    }

    public void paintWidget(Graphics graphics) {
        this.widgetPlot.paintNoBuffer(graphics);
    }

    public void setFrameTitle(String string) {
        this.framePlot.setTitle(string, this.preTitle);
    }

    public void setBinWidth(int n, double d) {
        ((HistoLive)this.framePlot).setBinWidth(n, d);
        ((HistoLive)this.widgetPlot).setBinWidth(n, d);
    }

    public void _exportImage() {
        Image image = this.createImage(this.framePlot.getSize().width, this.framePlot.getSize().height);
        Graphics graphics = image.getGraphics();
        this.framePlot.printAll(graphics);
        StarLogo.PictInstance.savePicture(this.app.sl, image);
    }

    public void _close() {
        this.dispose();
    }

    public void _print() {
        try {
            PrintDialog printDialog = Application.createPrintDialog(this, true, true, true, false);
            printDialog.show();
            if (printDialog.canceledp()) {
                return;
            }
            DoubleInsets doubleInsets = printDialog.getMargins();
            Print print = new Print(this, "Plot Window", printDialog.getOrientation(), doubleInsets.top, doubleInsets.bottom, doubleInsets.left, doubleInsets.right, false);
            print.displayPrintingMessage(true);
            print.printComponent((Component)this.framePlot, printDialog.getResizingOption());
            printDialog.dispose();
            print.print();
        }
        catch (PrintingCanceledException printingCanceledException) {
            // empty catch block
        }
    }

    private boolean[][] _getConnected(Plot plot) {
        Vector vector = plot._points;
        boolean[][] blArrayArray = new boolean[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            blArrayArray[n] = new boolean[vector2.size()];
            int n2 = 0;
            while (n2 < vector2.size()) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                blArrayArray[n][n2] = plotPoint.connected;
                ++n2;
            }
            ++n;
        }
        return blArrayArray;
    }

    private void _setConnected(Plot plot, boolean bl) {
        Vector vector = plot._points;
        plot.setConnected(bl);
        boolean[][] blArrayArray = new boolean[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            blArrayArray[n] = new boolean[vector2.size()];
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < vector2.size()) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                plotPoint.connected = bl && !bl2;
                bl2 = false;
                ++n2;
            }
            ++n;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    private void _restoreConnected(boolean[][] blArray) {
        Vector vector = ((Plot)this.framePlot)._points;
        boolean[][] blArrayArray = new boolean[vector.size()][];
        int n = 0;
        while (n < vector.size()) {
            Vector vector2 = (Vector)vector.elementAt(n);
            blArrayArray[n] = new boolean[vector2.size()];
            int n2 = 0;
            while (n2 < vector2.size()) {
                PlotPoint plotPoint = (PlotPoint)vector2.elementAt(n2);
                plotPoint.connected = blArray[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

