/*
 * Decompiled with CFR 0.152.
 */
package ptolemy;

import java.awt.Graphics;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ptolemy.PlotBox;
import starlogo.LineWidget;

public class Histogram
extends PlotBox {
    public int _currentdataset = -1;
    public Vector _points = new Vector();
    public Vector _histogram = new Vector();
    public boolean _painted = false;
    public int num = 1;
    public int reset = 1;
    public double _barwidth = 0.5;
    public double _baroffset = 0.15;
    public double _binWidth = 1.0;
    public double _binOffset = 0.0;
    public String _filename = null;
    public boolean _showing = false;

    public void addLegend(int n, String string) {
        this._checkDatasetIndex(n);
        super.addLegend(n, string);
    }

    public PlotBox copy(LineWidget lineWidget, Histogram histogram) {
        super.copy(lineWidget, histogram);
        histogram._currentdataset = this._currentdataset;
        histogram._painted = this._painted;
        histogram.num = this.num;
        histogram.reset = this.reset;
        int n = this._points.size();
        histogram._points = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            histogram._points.addElement(((Vector)this._points.elementAt(n2)).clone());
            ++n2;
        }
        n = this._histogram.size();
        histogram._histogram = new Vector(n);
        int n3 = 0;
        while (n3 < n) {
            histogram._histogram.addElement(((Hashtable)this._histogram.elementAt(n3)).clone());
            ++n3;
        }
        histogram._barwidth = this._barwidth;
        histogram._baroffset = this._baroffset;
        histogram._binWidth = this._binWidth;
        histogram._binOffset = this._binOffset;
        histogram._filename = new String(this._filename);
        histogram._showing = this._showing;
        return histogram;
    }

    public synchronized void addPoint(int n, double d) {
        this.addPoint(n, d, 1);
    }

    public synchronized void addPoint(int n, double d, int n2) {
        double d2;
        int n3;
        this._checkDatasetIndex(n);
        int n4 = (int)Math.round((d - this._binOffset) / this._binWidth);
        Integer n5 = new Integer(n4);
        Hashtable hashtable = (Hashtable)this._histogram.elementAt(n);
        if (hashtable.containsKey(n5)) {
            n3 = 1 + (Integer)hashtable.get(n5);
            hashtable.put(n5, new Integer(n3));
        } else {
            n3 = 1;
            hashtable.put(n5, new Integer(n3));
        }
        double d3 = (double)n4 * this._binWidth + this._binOffset;
        if (d3 < this._xBottom) {
            this._xBottom = d3;
        }
        if ((d2 = d3 + this._binWidth / 2.0) > this._xTop) {
            this._xTop = d2;
        }
        if ((double)n3 > this._yTop) {
            this._yTop = n3;
        }
        this._yBottom = 0.0;
        Vector vector = (Vector)this._points.elementAt(n);
        vector.addElement(new Double(d));
        if (this._showing && this.num > 20) {
            this.repaint();
            this.num = 0;
        }
        ++this.num;
    }

    public synchronized void recalcBins() {
    }

    public synchronized void addPoint(int n, double d, double d2, boolean bl) {
        this.addPoint(n, d2);
    }

    public synchronized void clear(boolean bl, boolean bl2, boolean bl3) {
        super.clear(bl, bl2, bl3);
        this._currentdataset = -1;
        this._points = new Vector();
        this._histogram = new Vector();
        this._painted = false;
        this._filename = null;
        this._showing = false;
        if (bl) {
            this._barwidth = 0.5;
            this._baroffset = 0.15;
            this._binWidth = 1.0;
            this._binOffset = 0.0;
        }
    }

    public void setBars(double d, double d2) {
        this._barwidth = d;
        this._baroffset = d2;
    }

    public void setBinOffset(double d) {
        this._binOffset = d;
    }

    public void setBinWidth(double d) {
        this._binWidth = d;
    }

    /*
     * Unable to fully structure code
     */
    protected void _checkDatasetIndex(int var1_1) {
        if (var1_1 >= 0) ** GOTO lbl5
        throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
lbl-1000:
        // 1 sources

        {
            this._points.addElement(new Vector<E>());
            this._histogram.addElement(new Hashtable<K, V>());
lbl5:
            // 2 sources

            ** while (var1_1 >= this._points.size())
        }
lbl6:
        // 1 sources

    }

    protected void _drawBar(Graphics graphics, int n, long l, long l2, boolean bl) {
        if (bl) {
            if (l2 < (long)this._uly) {
                l2 = this._uly;
            }
            if (l2 > (long)this._lry) {
                l2 = this._lry;
            }
        }
        if (l2 <= (long)this._lry && l <= (long)this._lrx && l >= (long)this._ulx) {
            long l3;
            int n2 = (int)((double)l - this._barwidth * this._binWidth * this._xscale / 2.0 + (double)n * this._baroffset * this._binWidth * this._xscale);
            int n3 = (int)((double)n2 + this._barwidth * this._binWidth * this._xscale);
            if (n2 < this._ulx) {
                n2 = this._ulx;
            }
            if (n3 > this._lrx) {
                n3 = this._lrx;
            }
            if (n2 >= n3) {
                n3 = n2 + 1;
            }
            if ((long)this._lry < (l3 = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                l3 = this._lry;
            }
            if ((long)this._uly > l3) {
                l3 = this._uly;
            }
            if (this._yMin >= 0.0 || l2 <= l3) {
                graphics.fillRect(n2, (int)l2, n3 - n2, (int)(l3 - l2));
            } else {
                graphics.fillRect(n2, (int)l3, n3 - n2, (int)(l2 - l3));
            }
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        super._drawPlot(graphics, bl);
        this._showing = true;
        int n = this._points.size() - 1;
        while (n >= 0) {
            Hashtable hashtable = (Hashtable)this._histogram.elementAt(n);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Integer n2 = (Integer)enumeration.nextElement();
                Integer n3 = (Integer)hashtable.get(n2);
                this._drawPlotPoint(graphics, n, n2, n3);
            }
            --n;
        }
        this._painted = true;
        this.notifyAll();
    }

    protected void _write(PrintWriter printWriter) {
        super._write(printWriter);
        printWriter.println("<barGraph width=\"" + this._barwidth + "\" offset=\"" + this._baroffset + "\"/>");
        printWriter.println("<bin width=\"" + this._binWidth + " offset=\"" + this._binOffset + "\">");
        int n = 0;
        while (n < this._points.size()) {
            String string = this.getLegend(n);
            if (string != null) {
                printWriter.println("<dataset name=\"" + string + "\">");
            } else {
                printWriter.println("<dataset>");
            }
            Vector vector = (Vector)this._points.elementAt(n);
            int n2 = 0;
            while (n2 < vector.size()) {
                Double d = (Double)vector.elementAt(n2);
                printWriter.println("<p y=\"" + d + "\"/");
                ++n2;
            }
            printWriter.println("</dataset>");
            ++n;
        }
    }

    private synchronized void _drawPlotPoint(Graphics graphics, int n, int n2, int n3) {
        if (this._usecolor) {
            int n4 = n % this._colors.length;
            graphics.setColor(this._colors[n4]);
        } else {
            graphics.setColor(this._foreground);
        }
        double d = n3;
        double d2 = this._binWidth * (double)n2 + this._binOffset;
        if (this._xlog) {
            if (d2 <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + d2);
                return;
            }
            d2 = Math.log(d2) * PlotBox._LOG10SCALE;
        }
        if (this._ylog) {
            if (d <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + d);
                return;
            }
            d = Math.log(d) * PlotBox._LOG10SCALE;
        }
        long l = (long)this._lry - (long)((d - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((d2 - this._xMin) * this._xscale);
        this._drawBar(graphics, n, l2, l, true);
        graphics.setColor(this._foreground);
    }
}

