/*
 * Decompiled with CFR 0.152.
 */
package ptolemy;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ptolemy.Histogram;
import ptolemy.PlotBox;
import starlogo.LineWidget;
import starlogo.StarLogo;

public class HistoLive
extends Histogram {
    int n;
    double val;
    LineWidget lw;
    int type;
    int num;
    public double time = 0.0;
    public Hashtable hashtable = new Hashtable();

    public HistoLive(LineWidget lineWidget, int n) {
        this.lw = lineWidget;
        this.type = n;
        this.num = 10;
        this.initme();
    }

    public PlotBox copy(LineWidget lineWidget) {
        HistoLive histoLive = new HistoLive(lineWidget, this.type);
        super.copy(lineWidget, histoLive);
        histoLive.n = this.n;
        histoLive.val = this.val;
        histoLive.num = this.num;
        histoLive.time = this.time;
        return histoLive;
    }

    public void allOff() {
        this.setGrid(false);
        this.setTitle("", this.lw.tbc.getPreTitle());
        this.setXLabel("");
        this.setYLabel("");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return "False";
        }
    }

    public void initme() {
        if (StarLogo.DEBUG) {
            System.out.println("initialized lw");
        }
        this.setGrid(false);
    }

    public synchronized void addDataPointToHash(int n, int n2, double d, int n3) {
        this.addHashPoint(n, n2, d, n3);
    }

    public synchronized void addHashPoint(int n, int n2, double d, int n3) {
        Number number;
        Object object;
        this._checkDatasetIndex(n);
        Integer n4 = new Integer(n);
        Double d2 = new Double(d);
        Hashtable hashtable = null;
        if (this.hashtable.get(n4) == null) {
            hashtable = new Hashtable();
            hashtable.put(new Integer(n2), d2);
            this.hashtable.put(n4, hashtable);
        } else {
            object = new Integer(n2);
            hashtable = (Hashtable)this.hashtable.get(n4);
            if (hashtable.get(object) != null) {
                number = (Double)hashtable.get(object);
                this.erasePoint(n, (Double)number);
                int n5 = (int)Math.round(((Double)number - this._binOffset) / this._binWidth);
                Integer n6 = new Integer(n5);
                Hashtable hashtable2 = (Hashtable)this._histogram.elementAt(n);
                if (hashtable2.containsKey(n6)) {
                    int n7 = (Integer)hashtable2.get(n6) - 1;
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    hashtable2.put(n6, new Integer(n7));
                }
            }
            hashtable.put(new Integer(n2), d2);
        }
        this.addPoint(n, d, n3);
        if ((this._xTop - this._xBottom) / this._binWidth > 10.0) {
            this.hashtable.put(n4, new Hashtable());
            this._points.setElementAt(new Vector(), n);
            this._histogram.setElementAt(new Hashtable(), n);
            this._binWidth = (int)Math.round((this._xTop - this._xBottom) / 5.0);
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                number = (Integer)object.nextElement();
                Double d3 = (Double)hashtable.get(number);
                this.addHashPoint(n, (Integer)number, d3, n3);
            }
        }
    }

    public synchronized void setBinWidth(int n, double d) {
        Integer n2 = new Integer(n);
        Hashtable hashtable = (Hashtable)this.hashtable.get(n2);
        this.hashtable.put(n2, new Hashtable());
        this._points.setElementAt(new Vector(), n);
        this._histogram.setElementAt(new Hashtable(), n);
        this._binWidth = d;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n3 = (Integer)enumeration.nextElement();
            Double d2 = (Double)hashtable.get(n3);
            this.addHashPoint(n, n3, d2, this.num);
        }
    }

    public synchronized void removeHashPoint(int n) {
        Enumeration enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n2;
            Hashtable hashtable;
            Integer n3 = (Integer)enumeration.nextElement();
            if (this.hashtable.get(n3) == null || (hashtable = (Hashtable)this.hashtable.get(n3)).get(n2 = new Integer(n)) == null) continue;
            double d = (Double)hashtable.get(n2);
            this.erasePoint(n3, d);
            int n4 = (int)Math.round((d - this._binOffset) / this._binWidth);
            Integer n5 = new Integer(n4);
            Hashtable hashtable2 = (Hashtable)this._histogram.elementAt(n3);
            if (hashtable2.containsKey(n5)) {
                int n6 = (Integer)hashtable2.get(n5) - 1;
                if (n6 < 0) {
                    n6 = 0;
                }
                hashtable2.put(n5, new Integer(n6));
            }
            hashtable.remove(n2);
        }
    }

    public synchronized void erasePoint(int n, double d) {
        Vector vector;
        try {
            vector = (Vector)this._points.elementAt(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            double d2 = (Double)vector.elementAt(n2);
            if (d2 == d) {
                vector.removeElementAt(n2);
                return;
            }
            ++n2;
        }
    }

    public void setNum(int n) {
        this.num = n;
    }

    public int getNum() {
        return this.num;
    }
}

