package Plugins::SuperDateTime::Settings;

# SlimServer Copyright (C) 2001-2006 Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;
use base qw(Slim::Web::Settings);

use Slim::Utils::Log;
use Slim::Utils::Prefs;

my $prefs = preferences('plugin.superdatetime');

my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.superdatetime',
	'defaultLevel' => 'WARN',
#	'defaultLevel' => 'DEBUG',
	'description'  => 'SuperDateTime blah blah blah',
});

my %mlbTeams = (
			'Cubs' => 'Chicago Cubs',
			'White Sox' => 'Chicago Sox',
			'Arizona' => 'Arizona',
			'Atlanta' => 'Atlanta',
			'Baltimore' => 'Baltimore',
			'Boston' => 'Boston',
			'Cincinnati' => 'Cincinnati',
			'Cleveland' => 'Cleveland',
			'Colorado' => 'Colorado',
			'Detroit' => 'Detroit',
			'Florida' => 'Florida',
			'Houston' => 'Houston',
			'Kansas City' => 'Kansas City',
			'LA Angels' => 'LA Angels',
			'LA Dodgers' => 'LA Dodgers',
			'Milwaukee' => 'Milwaukee',
			'Minnesota' => 'Minnesota',
			'NY Mets' => 'NY Mets',
			'NY Yankees' => 'NY Yankees',
			'Oakland' => 'Oakland',
			'Philadelphia' => 'Philadelphia',
			'Pittsburgh' => 'Pittsburgh',
			'San Diego' => 'San Diego',
			'San Francisco' => 'San Francisco',
			'Seattle' => 'Seattle',
			'St. Louis' => 'St. Louis',
			'Tampa Bay' => 'Tampa Bay',
			'Texas' => 'Texas',
			'Toronto' => 'Toronto',
			'Washington' => 'Washington',
			'0' => 'None',
			'1' => 'All'
);

my %nbaTeams = (
			'Boston' => 'Boston',
			'Philadelphia' => 'Philadelphia',
			'New Jersey' => 'New Jersey',
			'Toronto' => 'Toronto',
			'New York' => 'New York',
			'Detroit' => 'Detroit',
			'Chicago' => 'Chicago',
			'Indiana' => 'Indiana',
			'Cleveland' => 'Cleveland',
			'Milwaukee' => 'Milwaukee',
			'Miami' => 'Miami',
			'Washington' => 'Washington',
			'Orlando' => 'Orlando',
			'Charlotte' => 'Charlotte',
			'Atlanta' => 'Atlanta',
			'Seattle' => 'Seattle',
			'Denver' => 'Denver',
			'Minnesota' => 'Minnesota',
			'Portland' => 'Portland',
			'Utah' => 'Utah',
			'Phoenix' => 'Phoenix',
			'Sacramento' => 'Sacramento',
			'LA Clippers' => 'LA Clippers',
			'LA Lakers' => 'LA Lakers',
			'Golden State' => 'Golden State',
			'San Antonio' => 'San Antonio',
			'Dallas' => 'Dallas',
			'Houston' => 'Houston',
			'Memphis' => 'Memphis',
			'NO/Oklahoma City' => 'New Orleans',
			'0' => 'None',
			'1' => 'All'
);

my %nflTeams = (
			'Dallas' => 'Dallas',
			'New York Giants' => 'New York Giants',
			'New York Jets' => 'New York Jets',
			'Philadelphia' => 'Philadelphia',
			'Washington' => 'Washington',
			'Chicago' => 'Chicago',
			'Green Bay' => 'Green Bay',
			'Minnesota' => 'Minnesota',
			'Detroit' => 'Detroit',
			'Atlanta' => 'Atlanta',
			'New Orleans' => 'New Orleans',
			'Tampa Bay' => 'Tampa Bay',
			'Carolina' => 'Carolina',
			'St. Louis' => 'St. Louis',
			'Arizona' => 'Arizona',
			'San Francisco' => 'San Francisco',
			'Seattle' => 'Seattle',
			'Denver' => 'Denver',
			'Buffalo' => 'Buffalo',
			'New England' => 'New England',
			'Miami' => 'Miami',
			'Cincinnati' => 'Cincinnati',
			'Cleveland' => 'Cleveland',
			'Pittsburgh' => 'Pittsburgh',
			'Baltimore' => 'Baltimore',
			'Tennessee' => 'Tennessee',
			'Jacksonville' => 'Jacksonville',
			'Houston' => 'Houston',
			'Indianapolis' => 'Indianapolis',
			'Denver' => 'Denver',
			'Kansas City' => 'Kansas City',
			'Oakland' => 'Oakland',
			'San Diego' => 'San Diego',
			'0' => 'None',
			'1' => 'All'
);

my %nhlTeams = (
			'New Jersey' => 'New Jersey',
			'NY Rangers' => 'NY Rangers',
			'Philadelphia' => 'Philadelphia',
			'NY Islanders' => 'NY Islanders',
			'Pittsburgh' => 'Pittsburgh',
			'Montreal' => 'Montreal',
			'Ottawa' => 'Ottawa',
			'Buffalo' => 'Buffalo',
			'Boston' => 'Boston',
			'Toronto' => 'Toronto',
			'Atlanta' => 'Atlanta',
			'Tampa Bay' => 'Tampa Bay',
			'Florida' => 'Florida',
			'Washington' => 'Washington',
			'Carolina' => 'Carolina',
			'Detroit' => 'Detroit',
			'Nashville' => 'Nashville',
			'Chicago' => 'Chicago',
			'Colorado' => 'Colorado',
			'Columbus' => 'Columbus',
			'St. Louis' => 'St. Louis',
			'Minnesota' => 'Minnesota',
			'Edmonton' => 'Edmonton',
			'Vancouver' => 'Vancouver',
			'Calgary' => 'Calgary',
			'Anaheim' => 'Anaheim',
			'Dallas' => 'Dallas',
			'Los Angeles' => 'Los Angeles',
			'San Jose' => 'San Jose',
			'Phoenix' => 'Phoenix',
			'0' => 'None',
			'1' => 'All'
);

my %cfballconf = (
			'0' => 'None',
			'80' => 'All Div I-A',
			'1' => 'ACC',
			'4' => 'Big 12',
			'10' => 'Big East',			
			'5' => 'Big Ten',			
			'12' => 'C-USA',
			'46' => 'A-Sun',
			'18' => 'IA Indep.',
			'15' => 'MAC',
			'17' => 'MWC',
			'9' => 'Pac-10',
			'37' => 'S. Belt',
			'8' => 'SEC',
			'16' => 'WAC',
			'81' => 'All Div I-AA',
			'19' => 'A 10',
			'20' => 'Big Sky',
			'40' => 'Big South',
			'21' => 'Gateway',
			'43' => 'Great West',
			'32' => 'IAA Indep.',
			'22' => 'Ivy',
			'23' => 'MAAC',
			'24' => 'MEAC',
			'25' => 'NEC',
			'26' => 'OVC',
			'27' => 'Patriot',
			'28' => 'Pioneer',
			'29' => 'Southern',
			'30' => 'Southland',
			'31' => 'SWAC',
			'1000' => 'Top-25'
);

my %cbballconf = (
			'0' => 'None',
			'50' => 'All',
			'1' => 'Am. East',
			'2' => 'ACC',
			'3' => 'A Ten',			
			'4' => 'Big East',			
			'7' => 'Big Ten',
			'46' => 'A-Sun',
			'8' => 'Big 12',
			'5' => 'Big Sky',
			'6' => 'B. South',
			'9' => 'B. West',
			'10' => 'CAA',
			'11' => 'C-USA',
			'43' => 'Indep.',
			'45' => 'HOR',
			'12' => 'Ivy',
			'13' => 'MAAC',
			'15' => 'Mid-Con',
			'14' => 'MAC',
			'16' => 'MEAC',
			'18' => 'MVC',
			'44' => 'MWC',
			'19' => 'NEC',
			'20' => 'OVC',
			'21' => 'Pac-10',
			'22' => 'Patriot',
			'23' => 'SEC',
			'24' => 'Southern',
			'25' => 'Southland',
			'26' => 'SWAC',
			'27' => 'S. Belt',
			'29' => 'WCC',
			'30' => 'WAC',
			'1000' => 'Top-25'			
);

sub name {
        return 'PLUGIN_SCREENSAVER_SUPERDATETIME';
}

sub page {
        return 'plugins/SuperDateTime/settings/basic.html';
}

sub handler {
   my ($class, $client, $params) = @_;

	my @prefs2 = qw(
		city
		wunder
		show1icon
		show13line
		v3line1t
		v3line1m
		v3line1b
		v1period
      weatherformat1t
      weatherformat1b
      weatherformat2t
      weatherformat2b
      temperature
      windunit
      offset
      stocks
      stock1format
      stock2format
      teamlogos
      mlb
      nba
      nhl
      nfl
      cbballconf
      cbb
      cfballconf
      cfb
      refresh
      time
      atime
      score
      ascore
      lweather
	);

	for my $pref (@prefs2) {
		if ($params->{'saveSettings'}) {
			if ($pref eq 'cfb') {
				# Remove empties.
				my @teams = grep { $_ ne '' } @{$params->{'cfb'}};
				$prefs->set('cfb', \@teams);
			}
			elsif ($pref eq 'cbb') {
				# Remove empties.
				my @teams = grep { $_ ne '' } @{$params->{'cbb'}};
				$prefs->set('cbb', \@teams);
			}
			elsif ($pref eq 'mlb') {
				# Remove empties.
				my @teams = grep { $_ ne '0' } @{$params->{'mlb'}};
				$prefs->set('mlb', \@teams);
			}
			elsif ($pref eq 'nfl') {
				# Remove empties.
				my @teams = grep { $_ ne '0' } @{$params->{'nfl'}};
				$prefs->set('nfl', \@teams);
			}			
			elsif ($pref eq 'nba') {
				# Remove empties.
				my @teams = grep { $_ ne '0' } @{$params->{'nba'}};
				$prefs->set('nba', \@teams);
			}
			elsif ($pref eq 'nhl') {
				# Remove empties.
				my @teams = grep { $_ ne '0' } @{$params->{'nhl'}};
				$prefs->set('nhl', \@teams);
			}
			elsif ($pref eq 'v1period') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'v1period'}};
				$prefs->set('v1period', \@items);
			}
			elsif ($pref eq 'weatherformat1t') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'weatherformat1t'}};
				$prefs->set('weatherformat1t', \@items);
			}
			elsif ($pref eq 'weatherformat1b') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'weatherformat1b'}};
				$prefs->set('weatherformat1b', \@items);
			}
			elsif ($pref eq 'v3line1t') {			
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'v3line1t'}};
				$prefs->set('v3line1t', \@items);
			}
			elsif ($pref eq 'v3line1m') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'v3line1m'}};
				$prefs->set('v3line1m', \@items);
			}
			elsif ($pref eq 'v3line1b') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'v3line1b'}};
				$prefs->set('v3line1b', \@items);
			}
			elsif ($pref eq 'weatherformat2t') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'weatherformat2t'}};
				$prefs->set('weatherformat2t', \@items);
			}	
			elsif ($pref eq 'weatherformat2b') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'weatherformat2b'}};
				$prefs->set('weatherformat2b', \@items);
			}
			elsif ($pref eq 'show1icon') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'show1icon'}};
				$prefs->set('show1icon', \@items);
			}
			elsif ($pref eq 'show13line') {
				#Remove hidden one that forces array saving- is there a better way to do this?
				my @items = grep { $_ ne 'deleteme' } @{$params->{'show13line'}};
				$prefs->set('show13line', \@items);
			}			
			else {
				$prefs->set($pref, $params->{$pref});
			}

			Plugins::SuperDateTime::Plugin::refreshSoon($client);
		}

		$params->{'prefs'}->{$pref} = $prefs->get($pref);
   }

	$params->{'mlbTeams'} = \%mlbTeams;
	$params->{'nflTeams'} = \%nflTeams;
	$params->{'nbaTeams'} = \%nbaTeams;
	$params->{'nhlTeams'} = \%nhlTeams;
	$params->{'cfballconf'} = \%cfballconf;
	$params->{'cbballconf'} = \%cbballconf;
	
	return $class->SUPER::handler($client, $params);
}

1;

__END__
