/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ContextCache;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContextManager {
    private static final String[] DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES = new String[]{"org.springframework.test.context.web.ServletTestExecutionListener", "org.springframework.test.context.support.DependencyInjectionTestExecutionListener", "org.springframework.test.context.support.DirtiesContextTestExecutionListener", "org.springframework.test.context.transaction.TransactionalTestExecutionListener"};
    private static final Log logger = LogFactory.getLog(TestContextManager.class);
    static final ContextCache contextCache = new ContextCache();
    private final TestContext testContext;
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>();

    public TestContextManager(Class<?> testClass) {
        this(testClass, null);
    }

    public TestContextManager(Class<?> testClass, String defaultContextLoaderClassName) {
        this.testContext = new TestContext(testClass, contextCache, defaultContextLoaderClassName);
        this.registerTestExecutionListeners(this.retrieveTestExecutionListeners(testClass));
    }

    protected final TestContext getTestContext() {
        return this.testContext;
    }

    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        for (TestExecutionListener listener : testExecutionListeners) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Registering TestExecutionListener: " + listener));
            }
            this.testExecutionListeners.add(listener);
        }
    }

    public final List<TestExecutionListener> getTestExecutionListeners() {
        return this.testExecutionListeners;
    }

    private List<TestExecutionListener> getReversedTestExecutionListeners() {
        ArrayList<TestExecutionListener> listenersReversed = new ArrayList<TestExecutionListener>(this.getTestExecutionListeners());
        Collections.reverse(listenersReversed);
        return listenersReversed;
    }

    /*
     * WARNING - void declaration
     */
    private TestExecutionListener[] retrieveTestExecutionListeners(Class<?> clazz) {
        Assert.notNull(clazz, (String)"Class must not be null");
        Class<TestExecutionListeners> annotationType = TestExecutionListeners.class;
        ArrayList<Class<TestExecutionListener>> classesList = new ArrayList<Class<TestExecutionListener>>();
        Class declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        boolean defaultListeners = false;
        if (declaringClass == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("@TestExecutionListeners is not present for class [" + clazz + "]: using defaults."));
            }
            classesList.addAll(this.getDefaultTestExecutionListenerClasses());
            defaultListeners = true;
        } else {
            while (declaringClass != null) {
                void var8_8;
                TestExecutionListeners testExecutionListeners = declaringClass.getAnnotation(annotationType);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Retrieved @TestExecutionListeners [" + testExecutionListeners + "] for declaring class [" + declaringClass + "]."));
                }
                Object[] valueListenerClasses = testExecutionListeners.value();
                Object[] objectArray = testExecutionListeners.listeners();
                if (!ObjectUtils.isEmpty((Object[])valueListenerClasses) && !ObjectUtils.isEmpty((Object[])objectArray)) {
                    String msg = String.format("Test class [%s] has been configured with @TestExecutionListeners' 'value' [%s] and 'listeners' [%s] attributes. Use one or the other, but not both.", declaringClass, ObjectUtils.nullSafeToString((Object[])valueListenerClasses), ObjectUtils.nullSafeToString((Object[])objectArray));
                    logger.error((Object)msg);
                    throw new IllegalStateException(msg);
                }
                if (!ObjectUtils.isEmpty((Object[])valueListenerClasses)) {
                    Object[] objectArray2 = valueListenerClasses;
                }
                if (var8_8 != null) {
                    classesList.addAll(0, Arrays.asList(var8_8));
                }
                declaringClass = testExecutionListeners.inheritListeners() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
            }
        }
        ArrayList<Object> listeners = new ArrayList<Object>(classesList.size());
        for (Class clazz2 : classesList) {
            try {
                listeners.add(BeanUtils.instantiateClass((Class)clazz2));
            }
            catch (NoClassDefFoundError err) {
                if (defaultListeners) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Could not instantiate default TestExecutionListener class [" + clazz2.getName() + "]. Specify custom listener classes or make the default listener classes available."));
                    continue;
                }
                throw err;
            }
        }
        return listeners.toArray(new TestExecutionListener[listeners.size()]);
    }

    protected Set<Class<? extends TestExecutionListener>> getDefaultTestExecutionListenerClasses() {
        LinkedHashSet<Class<? extends TestExecutionListener>> defaultListenerClasses = new LinkedHashSet<Class<? extends TestExecutionListener>>();
        for (String className : DEFAULT_TEST_EXECUTION_LISTENER_CLASS_NAMES) {
            try {
                defaultListenerClasses.add(this.getClass().getClassLoader().loadClass(className));
            }
            catch (Throwable t) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Could not load default TestExecutionListener class [" + className + "]. Specify custom listener classes or make the default listener classes available."), t);
            }
        }
        return defaultListenerClasses;
    }

    public void beforeTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeTestClass(): class [" + testClass + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestClass(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before class' callback for test class [" + testClass + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void prepareTestInstance(Object testInstance) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("prepareTestInstance(): instance [" + testInstance + "]"));
        }
        this.getTestContext().updateState(testInstance, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.prepareTestInstance(this.getTestContext());
            }
            catch (Exception ex) {
                logger.error((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to prepare test instance [" + testInstance + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        Assert.notNull((Object)testInstance, (String)"Test instance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("beforeTestMethod(): instance [" + testInstance + "], method [" + testMethod + "]"));
        }
        this.getTestContext().updateState(testInstance, testMethod, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before' execution of test method [" + testMethod + "] for test instance [" + testInstance + "]"), (Throwable)ex);
                throw ex;
            }
        }
    }

    public void afterTestMethod(Object testInstance, Method testMethod, Throwable exception) throws Exception {
        Assert.notNull((Object)testInstance, (String)"testInstance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestMethod(): instance [" + testInstance + "], method [" + testMethod + "], exception [" + exception + "]"));
        }
        this.getTestContext().updateState(testInstance, testMethod, exception);
        Exception afterTestMethodException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestMethod(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after' execution for test: method [" + testMethod + "], instance [" + testInstance + "], exception [" + exception + "]"), (Throwable)ex);
                if (afterTestMethodException != null) continue;
                afterTestMethodException = ex;
            }
        }
        if (afterTestMethodException != null) {
            throw afterTestMethodException;
        }
    }

    public void afterTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("afterTestClass(): class [" + testClass + "]"));
        }
        this.getTestContext().updateState(null, null, null);
        Exception afterTestClassException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestClass(this.getTestContext());
            }
            catch (Exception ex) {
                logger.warn((Object)("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after class' callback for test class [" + testClass + "]"), (Throwable)ex);
                if (afterTestClassException != null) continue;
                afterTestClassException = ex;
            }
        }
        if (afterTestClassException != null) {
            throw afterTestClassException;
        }
    }
}

