/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockMultipartHttpServletRequest
extends MockHttpServletRequest
implements MultipartHttpServletRequest {
    private final MultiValueMap<String, MultipartFile> multipartFiles = new LinkedMultiValueMap();

    public MockMultipartHttpServletRequest() {
        this.setMethod("POST");
        this.setContentType("multipart/form-data");
    }

    public void addFile(MultipartFile file) {
        Assert.notNull((Object)file, (String)"MultipartFile must not be null");
        this.multipartFiles.add((Object)file.getName(), (Object)file);
    }

    public Iterator<String> getFileNames() {
        return this.multipartFiles.keySet().iterator();
    }

    public MultipartFile getFile(String name) {
        return (MultipartFile)this.multipartFiles.getFirst((Object)name);
    }

    public List<MultipartFile> getFiles(String name) {
        List multipartFiles = (List)this.multipartFiles.get((Object)name);
        if (multipartFiles != null) {
            return multipartFiles;
        }
        return Collections.emptyList();
    }

    public Map<String, MultipartFile> getFileMap() {
        return this.multipartFiles.toSingleValueMap();
    }

    public MultiValueMap<String, MultipartFile> getMultiFileMap() {
        return new LinkedMultiValueMap(this.multipartFiles);
    }

    public String getMultipartContentType(String paramOrFileName) {
        MultipartFile file = this.getFile(paramOrFileName);
        if (file != null) {
            return file.getContentType();
        }
        return null;
    }

    public HttpMethod getRequestMethod() {
        return HttpMethod.valueOf((String)this.getMethod());
    }

    public HttpHeaders getRequestHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Enumeration<String> headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            headers.put(headerName, (List)Collections.list(this.getHeaders(headerName)));
        }
        return headers;
    }

    public HttpHeaders getMultipartHeaders(String paramOrFileName) {
        String contentType = this.getMultipartContentType(paramOrFileName);
        if (contentType != null) {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", contentType);
            return headers;
        }
        return null;
    }
}

