/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class RawArgParser {
    private static final int INIT_STATE = 0;
    private static final int SKIPPING_SPACES_STATE = 1;
    private static final int COLLECTING_ARG_STATE = 2;
    private static final int IN_DOUBLE_QUOTE_STATE = 3;
    private static final int IN_SINGLE_QUOTE_STATE = 4;
    private Stack args = new Stack();

    public RawArgParser(String[] rawArgs) {
        if (rawArgs.length > 0) {
            this.args.addAll(this.parse(rawArgs[0]));
            for (int i = 1; i < rawArgs.length; ++i) {
                this.args.push(rawArgs[i]);
            }
        }
    }

    public List getArgs() {
        return this.args;
    }

    private List parse(String command) {
        ArrayList<String> tokens = new ArrayList<String>();
        int state = 0;
        StringBuffer token = new StringBuffer();
        block7: for (int i = 0; i < command.length(); ++i) {
            char c = command.charAt(i);
            switch (state) {
                case 0: {
                    if (c == ' ') {
                        state = 1;
                        continue block7;
                    }
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 4;
                        continue block7;
                    }
                    token.append(c);
                    state = 2;
                    continue block7;
                }
                case 1: {
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 4;
                        continue block7;
                    }
                    if (c == ' ') continue block7;
                    token.append(c);
                    state = 2;
                    continue block7;
                }
                case 3: {
                    if (c == '\"') {
                        state = 2;
                        continue block7;
                    }
                    token.append(c);
                    continue block7;
                }
                case 4: {
                    if (c == '\'') {
                        state = 2;
                        continue block7;
                    }
                    token.append(c);
                    continue block7;
                }
                case 2: {
                    if (c == ' ') {
                        tokens.add(token.toString());
                        token = new StringBuffer();
                        state = 1;
                        continue block7;
                    }
                    if (c == '\"') {
                        state = 3;
                        continue block7;
                    }
                    if (c == '\'') {
                        state = 4;
                        continue block7;
                    }
                    token.append(c);
                    continue block7;
                }
                default: {
                    throw new IllegalStateException("Unknown parsing state: " + state);
                }
            }
        }
        if (state == 2 && token.length() > 0) {
            tokens.add(token.toString());
        } else if (state == 3 || state == 4) {
            throw new IllegalArgumentException("Unterminated quote: " + command);
        }
        return tokens;
    }
}

