/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;

public class KCode {
    public static final KCode NIL = new KCode(null);
    public static final KCode NONE = new KCode("NONE");
    public static final KCode UTF8 = new KCode("UTF8");
    public static final KCode SJIS = new KCode("SJIS");
    public static final KCode EUC = new KCode("EUC");
    private String kcode;

    private KCode(String kcode) {
        this.kcode = kcode;
    }

    public static KCode create(Ruby runtime, String lang) {
        if (lang == null) {
            return NIL;
        }
        switch (lang.charAt(0)) {
            case 'E': 
            case 'e': {
                runtime.getWarnings().warn("JRuby supports only Unicode regexp.");
                return EUC;
            }
            case 'S': 
            case 's': {
                runtime.getWarnings().warn("JRuby supports only Unicode regexp.");
                return SJIS;
            }
            case 'U': 
            case 'u': {
                return UTF8;
            }
            case 'A': 
            case 'N': 
            case 'a': 
            case 'n': {
                return NONE;
            }
        }
        return NIL;
    }

    public IRubyObject kcode(Ruby runtime) {
        if (this.kcode == null) {
            return runtime.getNil();
        }
        return runtime.newString(this.kcode);
    }

    public CharsetDecoder decoder() {
        if (this == UTF8) {
            return Charset.forName("UTF-8").newDecoder();
        }
        return Charset.forName("ISO-8859-1").newDecoder();
    }

    public CharsetEncoder encoder() {
        if (this == UTF8) {
            return Charset.forName("UTF-8").newEncoder();
        }
        return Charset.forName("ISO-8859-1").newEncoder();
    }

    public int flags() {
        return 0;
    }
}

