/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.antlr.GroovySourceAST;
import org.codehaus.groovy.antlr.LineColumn;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.treewalker.VisitorAdapter;
import org.codehaus.groovy.groovydoc.GroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyConstructorDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyExecutableMemberDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyParameter;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyProgramElementDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyType;

public class SimpleGroovyClassDocAssembler
extends VisitorAdapter {
    private Stack stack;
    private Map classDocs;
    private SimpleGroovyClassDoc currentClassDoc;
    private SimpleGroovyConstructorDoc currentConstructorDoc;
    private SimpleGroovyMethodDoc currentMethodDoc;
    private SourceBuffer sourceBuffer;
    private String packagePath;
    private Pattern previousJavaDocCommentPattern;
    private static final String FS = "/";
    private List importedClassesAndPackages;
    private List links;

    public SimpleGroovyClassDocAssembler(String packagePath, String file, SourceBuffer sourceBuffer, List links) {
        this.sourceBuffer = sourceBuffer;
        this.packagePath = packagePath;
        this.links = links;
        this.stack = new Stack();
        this.classDocs = new HashMap();
        String className = file;
        if (file != null) {
            int idx = file.lastIndexOf(".");
            className = file.substring(0, idx);
        }
        this.importedClassesAndPackages = new ArrayList();
        this.importedClassesAndPackages.add(packagePath + "/*");
        this.importedClassesAndPackages.add("groovy/lang/*");
        this.importedClassesAndPackages.add("groovy/util/*");
        this.currentClassDoc = new SimpleGroovyClassDoc(this.importedClassesAndPackages, className, links);
        this.currentClassDoc.setFullPathName(packagePath + FS + className);
        this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        this.previousJavaDocCommentPattern = Pattern.compile("(?s)/\\*\\*(.*?)\\*/");
    }

    public Map getGroovyClassDocs() {
        this.postProcessClassDocs();
        return this.classDocs;
    }

    private void postProcessClassDocs() {
        Iterator classDocIterator = this.classDocs.values().iterator();
        while (classDocIterator.hasNext()) {
            GroovyConstructorDoc[] constructors;
            SimpleGroovyClassDoc classDoc = (SimpleGroovyClassDoc)classDocIterator.next();
            if (!classDoc.isClass() || (constructors = classDoc.constructors()) == null || constructors.length != 0) continue;
            SimpleGroovyConstructorDoc constructorDoc = new SimpleGroovyConstructorDoc(classDoc.name());
            classDoc.add(constructorDoc);
        }
    }

    public void visitInterfaceDef(GroovySourceAST t, int visit) {
        this.currentClassDoc.setAsInterfaceDefinition();
    }

    public void visitImport(GroovySourceAST t, int visit) {
        if (visit == 1) {
            GroovySourceAST child = t.childOfType(87);
            if (child == null) {
                child = t.childOfType(84);
            }
            String importTextWithSlashesInsteadOfDots = this.recurseDownImportBranch(child);
            this.importedClassesAndPackages.add(importTextWithSlashesInsteadOfDots);
        }
    }

    public String recurseDownImportBranch(GroovySourceAST t) {
        if (t != null) {
            if (t.getType() == 87) {
                GroovySourceAST firstChild = (GroovySourceAST)t.getFirstChild();
                GroovySourceAST secondChild = (GroovySourceAST)firstChild.getNextSibling();
                return this.recurseDownImportBranch(firstChild) + FS + this.recurseDownImportBranch(secondChild);
            }
            if (t.getType() == 84) {
                return t.getText();
            }
            if (t.getType() == 109) {
                return t.getText();
            }
        }
        return "";
    }

    public void visitExtendsClause(GroovySourceAST t, int visit) {
        GroovySourceAST superClassNode;
        if (visit == 1 && (superClassNode = t.childOfType(84)) != null) {
            String superClassName = superClassNode.getText();
            this.currentClassDoc.setSuperClassName(superClassName);
        }
    }

    public void visitClassDef(GroovySourceAST t, int visit) {
        if (visit == 1) {
            String className = t.childOfType(84).getText();
            this.currentClassDoc = (SimpleGroovyClassDoc)this.classDocs.get(this.packagePath + FS + className);
            if (this.currentClassDoc == null) {
                this.currentClassDoc = new SimpleGroovyClassDoc(this.importedClassesAndPackages, className, this.importedClassesAndPackages);
            }
            String commentText = this.getJavaDocCommentsBeforeNode(t);
            this.currentClassDoc.setRawCommentText(commentText);
            this.currentClassDoc.setFullPathName(this.packagePath + FS + this.currentClassDoc.name());
            this.classDocs.put(this.currentClassDoc.getFullPathName(), this.currentClassDoc);
        }
    }

    public void visitCtorIdent(GroovySourceAST t, int visit) {
        if (visit == 1 && !this.insideAnonymousInnerClass()) {
            this.currentConstructorDoc = new SimpleGroovyConstructorDoc(this.currentClassDoc.name());
            String commentText = this.getJavaDocCommentsBeforeNode(t);
            this.currentConstructorDoc.setRawCommentText(commentText);
            this.processModifiers(t, this.currentConstructorDoc);
            this.addParametersTo(this.currentConstructorDoc, t, visit);
            this.currentClassDoc.add(this.currentConstructorDoc);
        }
    }

    public void visitMethodDef(GroovySourceAST t, int visit) {
        if (visit == 1 && !this.insideAnonymousInnerClass()) {
            String methodName = t.childOfType(84).getText();
            this.currentMethodDoc = new SimpleGroovyMethodDoc(methodName, this.links);
            String commentText = this.getJavaDocCommentsBeforeNode(t);
            this.currentMethodDoc.setRawCommentText(commentText);
            this.processModifiers(t, this.currentMethodDoc);
            String returnTypeName = this.getTypeNodeAsText(t.childOfType(12), "def");
            SimpleGroovyType returnType = new SimpleGroovyType(returnTypeName);
            this.currentMethodDoc.setReturnType(returnType);
            this.addParametersTo(this.currentMethodDoc, t, visit);
            this.currentClassDoc.add(this.currentMethodDoc);
        }
    }

    private boolean insideAnonymousInnerClass() {
        GroovySourceAST grandParentNode = this.getGrandParentNode();
        return grandParentNode != null && grandParentNode.getType() == 190;
    }

    private void processModifiers(GroovySourceAST t, SimpleGroovyProgramElementDoc programElementDoc) {
        GroovySourceAST modifiers = t.childOfType(5);
        if (modifiers != null) {
            boolean seenNonPublicVisibilityModifier = false;
            block4: for (AST currentModifier = modifiers.getFirstChild(); currentModifier != null; currentModifier = currentModifier.getNextSibling()) {
                int type = currentModifier.getType();
                switch (type) {
                    case 111: 
                    case 113: {
                        seenNonPublicVisibilityModifier = true;
                        continue block4;
                    }
                    case 80: {
                        programElementDoc.setStatic(true);
                    }
                }
            }
            if (!seenNonPublicVisibilityModifier) {
                programElementDoc.setPublic(true);
            }
        }
    }

    private String getJavaDocCommentsBeforeNode(GroovySourceAST t) {
        String returnValue = "";
        String text = this.sourceBuffer.getSnippet(new LineColumn(1, 1), new LineColumn(t.getLine(), t.getColumn()));
        if (text != null) {
            Matcher m;
            int closingBlockIndex;
            int openBlockIndex = text.lastIndexOf("{");
            int lastBlockIndex = Math.max(openBlockIndex, closingBlockIndex = text.lastIndexOf("}"));
            if (lastBlockIndex > 0) {
                text = text.substring(lastBlockIndex);
            }
            if ((m = this.previousJavaDocCommentPattern.matcher(text)).find()) {
                returnValue = m.group(1);
            }
        }
        return returnValue;
    }

    private String getText(GroovySourceAST node) {
        String returnValue = null;
        if (node != null) {
            returnValue = node.getText();
        }
        return returnValue;
    }

    private String getTypeNodeAsText(GroovySourceAST typeNode, String defaultText) {
        String returnValue = defaultText;
        if (typeNode != null && typeNode.getType() == 12 && typeNode.getNumberOfChildren() > 0) {
            GroovySourceAST child = (GroovySourceAST)typeNode.getFirstChild();
            switch (child.getType()) {
                case 101: {
                    returnValue = "boolean";
                    break;
                }
                case 102: {
                    returnValue = "byte";
                    break;
                }
                case 103: {
                    returnValue = "char";
                    break;
                }
                case 108: {
                    returnValue = "double";
                    break;
                }
                case 106: {
                    returnValue = "float";
                    break;
                }
                case 105: {
                    returnValue = "int";
                    break;
                }
                case 107: {
                    returnValue = "long";
                    break;
                }
                case 104: {
                    returnValue = "short";
                    break;
                }
                case 100: {
                    returnValue = "void";
                    break;
                }
                case 84: {
                    returnValue = child.getText();
                }
            }
        }
        return returnValue;
    }

    private void addParametersTo(SimpleGroovyExecutableMemberDoc executableMemberDoc, GroovySourceAST t, int visit) {
        GroovySourceAST parametersNode = t.childOfType(19);
        if (parametersNode != null && parametersNode.getNumberOfChildren() > 0) {
            for (GroovySourceAST currentNode = (GroovySourceAST)parametersNode.getFirstChild(); currentNode != null; currentNode = (GroovySourceAST)currentNode.getNextSibling()) {
                String parameterTypeName = this.getTypeNodeAsText(currentNode.childOfType(12), "def");
                String parameterName = this.getText(currentNode.childOfType(84));
                SimpleGroovyParameter parameter = new SimpleGroovyParameter(parameterName);
                parameter.setTypeName(parameterTypeName);
                executableMemberDoc.add(parameter);
            }
        }
    }

    public void push(GroovySourceAST t) {
        this.stack.push(t);
    }

    public GroovySourceAST pop() {
        if (!this.stack.empty()) {
            return (GroovySourceAST)this.stack.pop();
        }
        return null;
    }

    private GroovySourceAST getParentNode() {
        Object parentNode = null;
        Object currentNode = this.stack.pop();
        if (!this.stack.empty()) {
            parentNode = this.stack.peek();
        }
        this.stack.push(currentNode);
        return parentNode;
    }

    private GroovySourceAST getGrandParentNode() {
        Object grandParentNode = null;
        Object currentNode = this.stack.pop();
        if (!this.stack.empty()) {
            Object parentNode = this.stack.pop();
            if (!this.stack.empty()) {
                grandParentNode = this.stack.peek();
            }
            this.stack.push(parentNode);
        }
        this.stack.push(currentNode);
        return grandParentNode;
    }
}

