/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.lib.conf.ValueListener;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.ParseException;

public abstract class Value
implements Cloneable {
    private static final String[] EMPTY_ALIASES = new String[0];
    private static final Localizer s_loc = Localizer.forPackage(Value.class);
    private String prop = null;
    private String loadKey = null;
    private String def = null;
    private String[] aliases = null;
    private String getter = null;
    private ValueListener listen = null;
    private boolean aliasListComprehensive = false;
    private Class scope = null;

    public Value() {
    }

    public Value(String prop) {
        this.setProperty(prop);
    }

    public String getProperty() {
        return this.prop;
    }

    public void setProperty(String prop) {
        this.prop = prop;
    }

    public String getLoadKey() {
        return this.loadKey;
    }

    public void setLoadKey(String loadKey) {
        this.loadKey = loadKey;
    }

    public String[] getAliases() {
        return this.aliases == null ? EMPTY_ALIASES : this.aliases;
    }

    public void setAliases(String[] aliases) {
        String[] aStrings = new String[aliases.length];
        System.arraycopy(aliases, 0, aStrings, 0, aStrings.length);
        this.aliases = aStrings;
    }

    public void setAlias(String key, String value) {
        this.aliases = this.setAlias(key, value, this.aliases);
    }

    protected String[] setAlias(String key, String value, String[] aliases) {
        if (aliases == null) {
            aliases = EMPTY_ALIASES;
        }
        for (int i = 0; i < aliases.length; i += 2) {
            if (!key.equals(aliases[i])) continue;
            aliases[i + 1] = value;
            return aliases;
        }
        String[] newAliases = new String[aliases.length + 2];
        System.arraycopy(aliases, 0, newAliases, 2, aliases.length);
        newAliases[0] = key;
        newAliases[1] = value;
        return newAliases;
    }

    public boolean isAliasListComprehensive() {
        return this.aliasListComprehensive;
    }

    public void setAliasListComprehensive(boolean aliasListIsComprehensive) {
        this.aliasListComprehensive = aliasListIsComprehensive;
    }

    public String alias(String str) {
        return this.alias(str, this.aliases, false);
    }

    protected String alias(String str, String[] aliases, boolean nullNotFound) {
        if (str != null) {
            str = str.trim();
        }
        if (aliases == null || aliases.length == 0) {
            return nullNotFound ? null : str;
        }
        boolean empty = str != null && str.length() == 0;
        for (int i = 1; i < aliases.length; i += 2) {
            if (!StringUtils.equals((String)str, (String)aliases[i]) && (!empty || aliases[i] != null)) continue;
            return aliases[i - 1];
        }
        return nullNotFound ? null : str;
    }

    public String unalias(String str) {
        return this.unalias(str, this.aliases, false);
    }

    protected String unalias(String str, String[] aliases, boolean nullNotFound) {
        boolean empty;
        if (str != null) {
            str = str.trim();
        }
        boolean bl = empty = str != null && str.length() == 0;
        if (str == null || empty && this.def != null) {
            str = this.def;
        }
        if (aliases != null) {
            for (int i = 0; i < aliases.length; i += 2) {
                if (!StringUtils.equals((String)str, (String)aliases[i]) && !StringUtils.equals((String)str, (String)aliases[i + 1]) && (!empty || aliases[i] != null)) continue;
                return aliases[i + 1];
            }
        }
        if (this.isAliasListComprehensive() && aliases != null) {
            throw new ParseException(s_loc.get("invalid-enumerated-config", this.getProperty(), str, Arrays.asList(aliases)));
        }
        return nullNotFound ? null : str;
    }

    public String getDefault() {
        return this.def;
    }

    public void setDefault(String def) {
        this.def = def;
    }

    public String getInstantiatingGetter() {
        return this.getter;
    }

    public void setInstantiatingGetter(String getter) {
        this.getter = getter;
    }

    public Class getScope() {
        return this.scope;
    }

    public void setScope(Class cls) {
        this.scope = cls;
    }

    public String getString() {
        return this.alias(this.getInternalString());
    }

    public void setString(String val) {
        String str = this.unalias(val);
        try {
            this.setInternalString(str);
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new ParseException(this.prop + ": " + val, (Throwable)re);
        }
    }

    public void setObject(Object obj) {
        if (obj == null && this.def != null) {
            this.setString(null);
        } else {
            try {
                this.setInternalObject(obj);
            }
            catch (ParseException pe) {
                throw pe;
            }
            catch (RuntimeException re) {
                throw new ParseException(this.prop + ": " + obj, (Throwable)re);
            }
        }
    }

    public abstract Class getValueType();

    protected abstract String getInternalString();

    protected abstract void setInternalString(String var1);

    protected abstract void setInternalObject(Object var1);

    public ValueListener getListener() {
        return this.listen;
    }

    public void setListener(ValueListener listen) {
        this.listen = listen;
    }

    public void valueChanged() {
        if (this.listen != null) {
            this.listen.valueChanged(this);
        }
    }

    public int hashCode() {
        String str = this.getString();
        int strHash = str == null ? 0 : str.hashCode();
        int propHash = this.prop == null ? 0 : this.prop.hashCode();
        return strHash ^ propHash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Value)) {
            return false;
        }
        Value o = (Value)other;
        return StringUtils.equals((String)this.prop, (String)o.getProperty()) && StringUtils.equals((String)this.getString(), (String)o.getString());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }
}

