/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.security.AccessController;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.schema.DriverDataSource;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.jdbc.ConfiguringConnectionDecorator;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.DecoratingDataSource;
import org.apache.openjpa.lib.jdbc.DelegatingDataSource;
import org.apache.openjpa.lib.jdbc.JDBCEventConnectionDecorator;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.lib.jdbc.LoggingConnectionDecorator;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.StoreException;
import org.apache.openjpa.util.UserException;

public class DataSourceFactory {
    private static final Localizer _loc = Localizer.forPackage(DataSourceFactory.class);

    public static DataSource newDataSource(JDBCConfiguration conf, boolean factory2) {
        String driver;
        String string = driver = factory2 ? conf.getConnection2DriverName() : conf.getConnectionDriverName();
        if (StringUtils.isEmpty((String)driver)) {
            throw new UserException(_loc.get("no-driver", driver)).setFatal(true);
        }
        ClassLoader loader = conf.getClassResolverInstance().getClassLoader(DataSourceFactory.class, null);
        String props = factory2 ? conf.getConnection2Properties() : conf.getConnectionProperties();
        try {
            Class<?> driverClass;
            try {
                driverClass = Class.forName(driver, true, loader);
            }
            catch (ClassNotFoundException cnfe) {
                driverClass = Class.forName(driver);
            }
            if (Driver.class.isAssignableFrom(driverClass)) {
                DriverDataSource ds = conf.newDriverDataSourceInstance();
                ds.setClassLoader(loader);
                ds.setConnectionDriverName(driver);
                ds.setConnectionProperties(Configurations.parseProperties(props));
                if (!factory2) {
                    ds.setConnectionFactoryProperties(Configurations.parseProperties(conf.getConnectionFactoryProperties()));
                    ds.setConnectionURL(conf.getConnectionURL());
                    ds.setConnectionUserName(conf.getConnectionUserName());
                    ds.setConnectionPassword(conf.getConnectionPassword());
                } else {
                    ds.setConnectionFactoryProperties(Configurations.parseProperties(conf.getConnectionFactory2Properties()));
                    ds.setConnectionURL(conf.getConnection2URL());
                    ds.setConnectionUserName(conf.getConnection2UserName());
                    ds.setConnectionPassword(conf.getConnection2Password());
                }
                return ds;
            }
            if (DataSource.class.isAssignableFrom(driverClass)) {
                return (DataSource)Configurations.newInstance(driver, conf, props, (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(DataSource.class)));
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new StoreException(e).setFatal(true);
        }
        throw new UserException(_loc.get("bad-driver", driver)).setFatal(true);
    }

    public static DecoratingDataSource decorateDataSource(DataSource ds, JDBCConfiguration conf, boolean factory2) {
        Options opts = Configurations.parseProperties(factory2 ? conf.getConnectionFactory2Properties() : conf.getConnectionFactoryProperties());
        Log jdbcLog = conf.getLog("openjpa.jdbc.JDBC");
        Log sqlLog = conf.getLog("openjpa.jdbc.SQL");
        DecoratingDataSource dds = new DecoratingDataSource(ds);
        try {
            List decs;
            ArrayList<ConnectionDecorator> decorators = new ArrayList<ConnectionDecorator>();
            decorators.addAll(Arrays.asList(conf.getConnectionDecoratorInstances()));
            JDBCEventConnectionDecorator ecd = new JDBCEventConnectionDecorator();
            Configurations.configureInstance((Object)ecd, (Configuration)conf, opts);
            JDBCListener[] listeners = conf.getJDBCListenerInstances();
            for (int i = 0; i < listeners.length; ++i) {
                ecd.addListener(listeners[i]);
            }
            decorators.add(ecd);
            if (ds instanceof DriverDataSource && (decs = ((DriverDataSource)ds).createConnectionDecorators()) != null) {
                decorators.addAll(decs);
            }
            LoggingConnectionDecorator lcd = new LoggingConnectionDecorator();
            Configurations.configureInstance((Object)lcd, (Configuration)conf, opts);
            lcd.getLogs().setJDBCLog(jdbcLog);
            lcd.getLogs().setSQLLog(sqlLog);
            decorators.add(lcd);
            dds.addDecorators(decorators);
            return dds;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new StoreException(e).setFatal(true);
        }
    }

    public static DecoratingDataSource installDBDictionary(DBDictionary dict, DecoratingDataSource ds, JDBCConfiguration conf, boolean factory2) {
        DataSource inner = ds.getInnermostDelegate();
        if (inner instanceof DriverDataSource) {
            ((DriverDataSource)inner).initDBDictionary(dict);
        }
        Connection conn = null;
        try {
            Iterator itr = ds.getDecorators().iterator();
            while (itr.hasNext()) {
                ConnectionDecorator cd = (ConnectionDecorator)itr.next();
                if (!(cd instanceof LoggingConnectionDecorator)) continue;
                ((LoggingConnectionDecorator)cd).setWarningHandler(dict);
            }
            ConfiguringConnectionDecorator ccd = new ConfiguringConnectionDecorator();
            ccd.setTransactionIsolation(conf.getTransactionIsolationConstant());
            if (factory2 || !conf.isConnectionFactoryModeManaged()) {
                if (!dict.supportsMultipleNontransactionalResultSets) {
                    ccd.setAutoCommit(Boolean.FALSE);
                } else {
                    ccd.setAutoCommit(Boolean.TRUE);
                }
            }
            Options opts = Configurations.parseProperties(factory2 ? conf.getConnectionFactory2Properties() : conf.getConnectionFactoryProperties());
            Configurations.configureInstance((Object)ccd, (Configuration)conf, opts);
            ds.addDecorator(ccd);
            ds.addDecorator(dict);
            conn = !factory2 ? ds.getConnection(conf.getConnectionUserName(), conf.getConnectionPassword()) : ds.getConnection(conf.getConnection2UserName(), conf.getConnection2Password());
            DecoratingDataSource decoratingDataSource = ds;
            return decoratingDataSource;
        }
        catch (Exception e) {
            throw new StoreException(e).setFatal(true);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    public static DataSource defaultsDataSource(DataSource ds, String user, String pass) {
        if (user == null && pass == null) {
            return ds;
        }
        if ("".equals(user) && "".equals(pass)) {
            return ds;
        }
        return new DefaultsDataSource(ds, user, pass);
    }

    public static void closeDataSource(DataSource ds) {
        if (ds instanceof DelegatingDataSource) {
            ds = ((DelegatingDataSource)ds).getInnermostDelegate();
        }
        ImplHelper.close(ds);
    }

    private static class DefaultsDataSource
    extends DelegatingDataSource {
        private final String _user;
        private final String _pass;

        public DefaultsDataSource(DataSource ds, String user, String pass) {
            super(ds);
            this._user = user;
            this._pass = pass;
        }

        public Connection getConnection() throws SQLException {
            return super.getConnection(this._user, this._pass);
        }

        public Connection getConnection(String user, String pass) throws SQLException {
            return super.getConnection(user, pass);
        }
    }
}

