/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.SchemaLocationResolver;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.eclipse.persistence.sdo.helper.delegates.SDOXSDHelperDelegate;

public class SDOXSDHelperDelegator
implements SDOXSDHelper {
    private Map sdoXSDHelperDelegates;
    private HelperContext aHelperContext;

    public SDOXSDHelperDelegator() {
        this.sdoXSDHelperDelegates = new WeakHashMap();
    }

    public SDOXSDHelperDelegator(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.sdoXSDHelperDelegates = new WeakHashMap();
    }

    public String getLocalName(Type type) {
        return this.getSDOXSDHelperDelegate().getLocalName(type);
    }

    public String getLocalName(Property property) {
        return this.getSDOXSDHelperDelegate().getLocalName(property);
    }

    public String getNamespaceURI(Property property) {
        return this.getSDOXSDHelperDelegate().getNamespaceURI(property);
    }

    public boolean isAttribute(Property property) {
        return this.getSDOXSDHelperDelegate().isAttribute(property);
    }

    public boolean isElement(Property property) {
        return this.getSDOXSDHelperDelegate().isElement(property);
    }

    public boolean isMixed(Type type) {
        return this.getSDOXSDHelperDelegate().isMixed(type);
    }

    public boolean isXSD(Type type) {
        return this.getSDOXSDHelperDelegate().isXSD(type);
    }

    public Property getGlobalProperty(String uri, String propertyName, boolean isElement) {
        return this.getSDOXSDHelperDelegate().getGlobalProperty(uri, propertyName, isElement);
    }

    public Property getGlobalProperty(QName qname, boolean isElement) {
        return this.getSDOXSDHelperDelegate().getGlobalProperty(qname, isElement);
    }

    public String getAppinfo(Type type, String source) {
        return this.getSDOXSDHelperDelegate().getAppinfo(type, source);
    }

    public String getAppinfo(Property property, String source) {
        return this.getSDOXSDHelperDelegate().getAppinfo(property, source);
    }

    public List define(String xsd) {
        return this.getSDOXSDHelperDelegate().define(xsd);
    }

    public List define(Reader xsdReader, String schemaLocation) {
        return this.getSDOXSDHelperDelegate().define(xsdReader, schemaLocation);
    }

    public List define(Source xsdSource, SchemaResolver schemaResolver) {
        return this.getSDOXSDHelperDelegate().define(xsdSource, schemaResolver);
    }

    public List define(InputStream xsdInputStream, String schemaLocation) {
        return this.getSDOXSDHelperDelegate().define(xsdInputStream, schemaLocation);
    }

    public String generate(List types) {
        return this.getSDOXSDHelperDelegate().generate(types);
    }

    public String generate(List types, Map namespaceToSchemaLocation) {
        return this.getSDOXSDHelperDelegate().generate(types, namespaceToSchemaLocation);
    }

    public String generate(List types, SchemaLocationResolver schemaLocationResolver) {
        return this.getSDOXSDHelperDelegate().generate(types, schemaLocationResolver);
    }

    public Map buildAppInfoMap(List appInfoElements) {
        return this.getSDOXSDHelperDelegate().buildAppInfoMap(appInfoElements);
    }

    public void addGlobalProperty(QName qname, Property prop, boolean isElement) {
        this.getSDOXSDHelperDelegate().addGlobalProperty(qname, prop, isElement);
    }

    private ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader.getParent() != null && classLoader.toString().indexOf(".wrappers") != -1) {
            AbstractSessionLog.getLog().log(1, "{0} matched classLoader: {1} to parent cl: {2}", new Object[]{this.getClass().getName(), classLoader.toString(), classLoader.getParent().toString()}, false);
            classLoader = classLoader.getParent();
        } else if (classLoader.getParent() != null && classLoader.toString().indexOf(".web.") != -1) {
            AbstractSessionLog.getLog().log(1, "{0} matched classLoader: {1} to parent cl: {2}", new Object[]{this.getClass().getName(), classLoader.toString(), classLoader.getParent().toString()}, false);
            classLoader = classLoader.getParent();
        }
        return classLoader;
    }

    private SDOXSDHelperDelegate getSDOXSDHelperDelegate() {
        ClassLoader contextClassLoader = this.getContextClassLoader();
        SDOXSDHelperDelegate sdoXSDHelperDelegate = (SDOXSDHelperDelegate)this.sdoXSDHelperDelegates.get(contextClassLoader);
        if (null == sdoXSDHelperDelegate) {
            sdoXSDHelperDelegate = new SDOXSDHelperDelegate(this.getHelperContext());
            this.sdoXSDHelperDelegates.put(contextClassLoader, sdoXSDHelperDelegate);
            AbstractSessionLog.getLog().log(1, "{0} creating new {1} keyed on classLoader: {2}", new Object[]{this.getClass().getName(), sdoXSDHelperDelegate, contextClassLoader.toString()}, false);
        }
        return sdoXSDHelperDelegate;
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public void reset() {
        this.getSDOXSDHelperDelegate().reset();
    }
}

