/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.delegates;

import commonj.sdo.DataObject;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XMLDocument;
import commonj.sdo.impl.HelperProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sdo.helper.SDOClassLoader;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.delegates.SDOXMLHelperDelegate;
import org.eclipse.persistence.sessions.Project;
import org.xml.sax.InputSource;

public class SDOXMLHelperDelegator
implements SDOXMLHelper {
    private Map sdoXMLHelperDelegates;
    private HelperContext aHelperContext;

    public SDOXMLHelperDelegator() {
        this.sdoXMLHelperDelegates = new WeakHashMap();
    }

    public SDOXMLHelperDelegator(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.sdoXMLHelperDelegates = new WeakHashMap();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.getSDOXMLHelperDelegate().setTimeZone(timeZone);
    }

    public void setTimeZoneQualified(boolean timeZoneQualified) {
        this.getSDOXMLHelperDelegate().setTimeZoneQualified(timeZoneQualified);
    }

    public XMLDocument load(String inputString) {
        return this.getSDOXMLHelperDelegate().load(inputString);
    }

    public XMLDocument load(InputStream inputStream) throws IOException {
        return this.getSDOXMLHelperDelegate().load(inputStream);
    }

    public XMLDocument load(InputStream inputStream, String locationURI, Object options) throws IOException {
        return this.getSDOXMLHelperDelegate().load(inputStream, locationURI, options);
    }

    public XMLDocument load(InputSource inputSource, String locationURI, Object options) throws IOException {
        return this.getSDOXMLHelperDelegate().load(inputSource, locationURI, options);
    }

    public XMLDocument load(Reader inputReader, String locationURI, Object options) throws IOException {
        return this.getSDOXMLHelperDelegate().load(inputReader, locationURI, options);
    }

    public XMLDocument load(Source source, String locationURI, Object options) throws IOException {
        return this.getSDOXMLHelperDelegate().load(source, locationURI, options);
    }

    public String save(DataObject dataObject, String rootElementURI, String rootElementName) {
        return this.getSDOXMLHelperDelegate().save(dataObject, rootElementURI, rootElementName);
    }

    public void save(DataObject dataObject, String rootElementURI, String rootElementName, OutputStream outputStream) throws IOException {
        this.getSDOXMLHelperDelegate().save(dataObject, rootElementURI, rootElementName, outputStream);
    }

    public void save(XMLDocument xmlDocument, OutputStream outputStream, Object options) throws IOException {
        this.getSDOXMLHelperDelegate().save(xmlDocument, outputStream, options);
    }

    public void save(XMLDocument xmlDocument, Writer outputWriter, Object options) throws IOException {
        this.getSDOXMLHelperDelegate().save(xmlDocument, outputWriter, options);
    }

    public void save(XMLDocument xmlDocument, Result result, Object options) throws IOException {
        this.getSDOXMLHelperDelegate().save(xmlDocument, result, options);
    }

    public XMLDocument createDocument(DataObject dataObject, String rootElementURI, String rootElementName) {
        return this.getSDOXMLHelperDelegate().createDocument(dataObject, rootElementURI, rootElementName);
    }

    public void setLoader(SDOClassLoader loader) {
        this.getSDOXMLHelperDelegate().setLoader(loader);
    }

    public SDOClassLoader getLoader() {
        return this.getSDOXMLHelperDelegate().getLoader();
    }

    public void setXmlContext(XMLContext xmlContext) {
        this.getSDOXMLHelperDelegate().setXmlContext(xmlContext);
    }

    public XMLContext getXmlContext() {
        return this.getSDOXMLHelperDelegate().getXmlContext();
    }

    public void addDescriptors(List descriptors) {
        this.getSDOXMLHelperDelegate().addDescriptors(descriptors);
    }

    public void setTopLinkProject(Project toplinkProject) {
        this.getSDOXMLHelperDelegate().setTopLinkProject(toplinkProject);
    }

    public Project getTopLinkProject() {
        return this.getSDOXMLHelperDelegate().getTopLinkProject();
    }

    public void setXmlMarshaller(XMLMarshaller xmlMarshaller) {
        this.getSDOXMLHelperDelegate().setXmlMarshaller(xmlMarshaller);
    }

    public XMLMarshaller getXmlMarshaller() {
        return this.getSDOXMLHelperDelegate().getXmlMarshaller();
    }

    public void setXmlUnmarshaller(XMLUnmarshaller xmlUnmarshaller) {
        this.getSDOXMLHelperDelegate().setXmlUnmarshaller(xmlUnmarshaller);
    }

    public XMLUnmarshaller getXmlUnmarshaller() {
        return this.getSDOXMLHelperDelegate().getXmlUnmarshaller();
    }

    private ClassLoader getContextClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader.getParent() != null && classLoader.toString().indexOf(".wrappers") != -1) {
            AbstractSessionLog.getLog().log(1, "{0} matched classLoader: {1} to parent cl: {2}", new Object[]{this.getClass().getName(), classLoader.toString(), classLoader.getParent().toString()}, false);
            classLoader = classLoader.getParent();
        } else if (classLoader.getParent() != null && classLoader.toString().indexOf(".web.") != -1) {
            AbstractSessionLog.getLog().log(1, "{0} matched classLoader: {1} to parent cl: {2}", new Object[]{this.getClass().getName(), classLoader.toString(), classLoader.getParent().toString()}, false);
            classLoader = classLoader.getParent();
        }
        return classLoader;
    }

    private SDOXMLHelperDelegate getSDOXMLHelperDelegate() {
        ClassLoader contextClassLoader = this.getContextClassLoader();
        SDOXMLHelperDelegate sdoXMLHelperDelegate = (SDOXMLHelperDelegate)this.sdoXMLHelperDelegates.get(contextClassLoader);
        if (null == sdoXMLHelperDelegate) {
            sdoXMLHelperDelegate = new SDOXMLHelperDelegate(this.getHelperContext());
            this.sdoXMLHelperDelegates.put(contextClassLoader, sdoXMLHelperDelegate);
            AbstractSessionLog.getLog().log(1, "{0} creating new {1} keyed on classLoader: {2}", new Object[]{this.getClass().getName(), sdoXMLHelperDelegate, contextClassLoader.toString()}, false);
        }
        return sdoXMLHelperDelegate;
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public void reset() {
        this.getSDOXMLHelperDelegate().reset();
    }

    public XMLConversionManager getXmlConversionManager() {
        return this.getSDOXMLHelperDelegate().getXmlConversionManager();
    }
}

