/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Struct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.oracle.OraclePLSQLType;
import org.eclipse.persistence.platform.database.oracle.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.PLSQLargument;
import org.eclipse.persistence.sessions.DatabaseRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLSQLrecord
implements ComplexDatabaseType,
OraclePLSQLType,
Cloneable {
    protected String recordName;
    protected String typeName;
    boolean hasCompatibleType = false;
    protected String compatibleType;
    protected List<PLSQLargument> fields = new ArrayList<PLSQLargument>();
    protected PLSQLStoredProcedureCall call;

    @Override
    public PLSQLrecord clone() {
        try {
            PLSQLrecord clone = (PLSQLrecord)super.clone();
            clone.fields = new ArrayList<PLSQLargument>(this.fields.size());
            for (PLSQLargument f : this.fields) {
                clone.fields.add(f.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public boolean isComplexDatabaseType() {
        return true;
    }

    @Override
    public boolean isJDBCType() {
        return false;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String name) {
        this.recordName = name;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public boolean hasCompatibleType() {
        return this.hasCompatibleType;
    }

    public void setHasCompatibleType(boolean hasCompatibleType) {
        this.hasCompatibleType = hasCompatibleType;
    }

    @Override
    public String getCompatibleType() {
        return this.compatibleType;
    }

    public void setCompatibleType(String compatibleType) {
        this.compatibleType = compatibleType;
        if (compatibleType != null && compatibleType.length() > 0) {
            this.hasCompatibleType = true;
        }
    }

    @Override
    public int getSqlCode() {
        if (this.hasCompatibleType) {
            return 2002;
        }
        return 1111;
    }

    @Override
    public int getConversionCode() {
        return this.getSqlCode();
    }

    public PLSQLStoredProcedureCall getCall() {
        return this.call;
    }

    @Override
    public void setCall(PLSQLStoredProcedureCall call) {
        this.call = call;
    }

    public void addField(String fieldName, DatabaseType databaseType) {
        this.fields.add(new PLSQLargument(fieldName, -1, DatasourceCall.IN, databaseType));
    }

    public void addField(String fieldName, DatabaseType databaseType, int precision, int scale) {
        this.fields.add(new PLSQLargument(fieldName, -1, DatasourceCall.IN, databaseType, precision, scale));
    }

    public void addField(String fieldName, DatabaseType databaseType, int length) {
        this.fields.add(new PLSQLargument(fieldName, -1, DatasourceCall.IN, databaseType, length));
    }

    @Override
    public int computeInIndex(PLSQLargument inArg, int newIndex, ListIterator<PLSQLargument> i) {
        if (this.hasCompatibleType) {
            return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeInIndex(inArg, newIndex);
        }
        i.remove();
        inArg.inIndex = newIndex;
        for (PLSQLargument f : this.fields) {
            f.inIndex = newIndex++;
            i.add(f);
        }
        return newIndex;
    }

    @Override
    public int computeOutIndex(PLSQLargument outArg, int newIndex, ListIterator<PLSQLargument> i) {
        if (this.hasCompatibleType) {
            return DatabaseType.DatabaseTypeHelper.databaseTypeHelper.computeOutIndex(outArg, newIndex);
        }
        i.remove();
        outArg.outIndex = newIndex;
        for (PLSQLargument f : this.fields) {
            f.outIndex = newIndex++;
            f.direction = DatasourceCall.OUT;
            i.add(f);
        }
        return newIndex;
    }

    @Override
    public void buildInDeclare(StringBuilder sb, PLSQLargument inArg) {
        sb.append("  ");
        sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(inArg));
        sb.append(" ");
        sb.append(this.getTypeName());
        sb.append(";\n");
        if (this.hasCompatibleType) {
            sb.append("  ");
            sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildCompatible(inArg));
            sb.append(" ");
            sb.append(this.getCompatibleType());
            sb.append(" := :");
            sb.append(inArg.inIndex);
            sb.append(";\n");
        }
    }

    @Override
    public void buildOutDeclare(StringBuilder sb, PLSQLargument outArg) {
        sb.append("  ");
        sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(outArg));
        sb.append(" ");
        sb.append(this.getTypeName());
        sb.append(";\n");
        if (this.hasCompatibleType) {
            sb.append("  ");
            sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildCompatible(outArg));
            sb.append(" ");
            sb.append(this.getCompatibleType());
            sb.append(" := ");
            sb.append(this.compatibleType);
            sb.append("(");
            int len = this.fields.size();
            for (int i = 0; i < len; ++i) {
                sb.append("null");
                if (i >= len - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            sb.append(";\n");
        }
    }

    @Override
    public void buildBeginBlock(StringBuilder sb, PLSQLargument arg) {
        String target = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(arg);
        String compat = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildCompatible(arg);
        if (arg.direction == DatasourceCall.IN | arg.direction == DatasourceCall.INOUT) {
            for (PLSQLargument f : this.fields) {
                sb.append("  ");
                sb.append(target);
                sb.append('.');
                sb.append(f.name);
                sb.append(" := ");
                if (this.hasCompatibleType) {
                    sb.append(compat);
                    sb.append('.');
                    sb.append(f.name);
                } else {
                    sb.append(":");
                    sb.append(f.inIndex);
                }
                sb.append(";\n");
            }
        }
    }

    @Override
    public void buildOutAssignment(StringBuilder sb, PLSQLargument outArg) {
        String target = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(outArg);
        String compat = DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildCompatible(outArg);
        for (PLSQLargument f : this.fields) {
            sb.append("  ");
            if (this.hasCompatibleType) {
                sb.append(compat);
                sb.append('.');
                sb.append(f.name);
            } else {
                sb.append(":");
                sb.append(f.outIndex);
            }
            sb.append(" := ");
            sb.append(target);
            sb.append('.');
            sb.append(f.name);
            sb.append(";\n");
        }
        if (this.hasCompatibleType) {
            sb.append("  :");
            sb.append(outArg.outIndex);
            sb.append(" := ");
            sb.append(compat);
            sb.append(";\n");
        }
    }

    @Override
    public void translate(PLSQLargument arg, AbstractRecord translationRow, AbstractRecord copyOfTranslationRow, Vector copyOfTranslationFields, Vector translationRowFields, Vector translationRowValues) {
        if (this.hasCompatibleType) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(arg, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues);
        } else {
            for (PLSQLargument f : this.fields) {
                DatabaseType.DatabaseTypeHelper.databaseTypeHelper.translate(f, translationRow, copyOfTranslationRow, copyOfTranslationFields, translationRowFields, translationRowValues);
            }
        }
    }

    @Override
    public void buildOutputRow(PLSQLargument outArg, AbstractRecord outputRow, DatabaseRecord newOutputRow, Vector outputRowFields, Vector outputRowValues) {
        if (this.hasCompatibleType) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(outArg, outputRow, newOutputRow, outputRowFields, outputRowValues);
            Object value = newOutputRow.get(outArg.name);
            AbstractRecord nestedRow = ((ObjectRelationalDataTypeDescriptor)this.call.getQuery().getDescriptor()).buildRowFromStructure((Struct)value);
            newOutputRow.mergeFrom(nestedRow);
        } else {
            for (PLSQLargument f : this.fields) {
                DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildOutputRow(f, outputRow, newOutputRow, outputRowFields, outputRowValues);
            }
        }
    }

    @Override
    public void logParameter(StringBuilder sb, Integer direction, PLSQLargument arg, AbstractRecord translationRow, DatabasePlatform platform) {
        if (this.hasCompatibleType) {
            DatabaseType.DatabaseTypeHelper.databaseTypeHelper.logParameter(sb, direction, arg, translationRow, platform);
        } else {
            Iterator<PLSQLargument> i = this.fields.iterator();
            while (i.hasNext()) {
                PLSQLargument f = i.next();
                f.databaseTypeWrapper.getWrappedType().logParameter(sb, direction, f, translationRow, platform);
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
        }
    }
}

