/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.xdb;

import java.io.StringReader;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.platform.database.oracle.XMLTypePlaceholder;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.platform.xml.XMLComparer;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DirectToXMLTypeMapping
extends DirectToFieldMapping {
    protected boolean shouldReadWholeDocument = false;
    private XMLTransformer xmlTransformer = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLTransformer();
    private XMLComparer xmlComparer;
    private XMLParser xmlParser;

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.setFieldClassification(XMLTypePlaceholder.class);
    }

    public DirectToXMLTypeMapping() {
        this.xmlTransformer.setFormattedOutput(false);
        this.xmlParser = XMLPlatformFactory.getInstance().getXMLPlatform().newXMLParser();
        this.xmlComparer = new XMLComparer();
    }

    public void setShouldReadWholeDocument(boolean readWholeDocument) {
        this.shouldReadWholeDocument = readWholeDocument;
    }

    public boolean shouldReadWholeDocument() {
        return this.shouldReadWholeDocument;
    }

    public Object getAttributeValue(Object fieldValue, AbstractSession session) throws DescriptorException {
        Object attributeValue = fieldValue;
        try {
            if (attributeValue != null && this.getAttributeClassification() != ClassConstants.STRING) {
                String xml = (String)attributeValue;
                StringReader reader = new StringReader(xml);
                return this.xmlParser.parse(reader);
            }
        }
        catch (Exception ex) {
            throw ConversionException.couldNotBeConverted(fieldValue, this.getAttributeClassification(), ex);
        }
        return attributeValue;
    }

    public boolean isDirectToXMLTypeMapping() {
        return true;
    }

    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        Object attributeValue = this.getAttributeValueFromObject(original);
        if (attributeValue != null) {
            if (this.getAttributeClassification() == ClassConstants.DOCUMENT || this.getAttributeClassification() == ClassConstants.NODE) {
                Document doc = (Document)attributeValue;
                this.setAttributeValueInObject(clone, doc.cloneNode(true));
            } else {
                super.buildClone(original, clone, unitOfWork);
            }
        }
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        if (this.getAttributeClassification() == ClassConstants.STRING) {
            return firstObject.equals(secondObject);
        }
        Object one = this.getFieldValue(this.getAttributeValueFromObject(firstObject), session);
        Object two = this.getFieldValue(this.getAttributeValueFromObject(secondObject), session);
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one instanceof Node && two instanceof Node) {
            return this.xmlComparer.isNodeEqual((Node)one, (Node)two);
        }
        return one.equals(two);
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        Object fieldValue = row.get(this.field);
        Object attributeValue = this.getAttributeValue(fieldValue, executionSession);
        return attributeValue;
    }
}

