/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.jpa.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.IdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Record;

public class UnitOfWorkIdentityMapAccessor
extends IdentityMapAccessor {
    public UnitOfWorkIdentityMapAccessor(AbstractSession session, IdentityMapManager identityMapManager) {
        super(session, identityMapManager);
    }

    public void clearQueryCache() {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache();
    }

    public void clearQueryCache(ReadQuery query) {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache(query);
    }

    public void clearQueryCache(String sessionQueryName) {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache((ReadQuery)this.session.getQuery(sessionQueryName));
    }

    public void clearQueryCache(String descriptorQueryName, Class queryClass) {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache((ReadQuery)this.session.getDescriptor(queryClass).getQueryManager().getQuery(descriptorQueryName));
    }

    public boolean containsObjectInIdentityMap(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        if (this.getIdentityMapManager().containsKey(primaryKey, theClass, descriptor)) {
            return true;
        }
        return ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(primaryKey, theClass, descriptor);
    }

    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, AbstractRecord translationRow, int valueHolderPolicy, boolean shouldReturnInvalidatedObjects) throws QueryException {
        return super.getAllFromIdentityMap(selectionCriteria, theClass, (Record)translationRow, valueHolderPolicy, true);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        return super.getFromIdentityMapWithDeferredLock(primaryKey, theClass, true, descriptor);
    }

    public Object getFromIdentityMap(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        Object objectFromCache = super.getFromIdentityMap(primaryKey, theClass, true, descriptor);
        if (objectFromCache != null) {
            return objectFromCache;
        }
        return this.getAndCloneCacheKeyFromParent(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAndCloneCacheKeyFromParent(Vector primaryKey, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        Object unregisteredDeletedClone;
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)this.getSession();
        IdentityMapAccessor parentIdentityMapAccessor = unitOfWork.getParent().getIdentityMapAccessorInstance();
        CacheKey cacheKey = parentIdentityMapAccessor.getCacheKeyForObject(primaryKey, theClass, descriptor);
        if (cacheKey == null && unitOfWork.getParent().isUnitOfWork()) {
            ((UnitOfWorkIdentityMapAccessor)parentIdentityMapAccessor).getAndCloneCacheKeyFromParent(primaryKey, theClass, shouldReturnInvalidatedObjects, descriptor);
            cacheKey = parentIdentityMapAccessor.getCacheKeyForObject(primaryKey, theClass, descriptor);
        }
        Object objectFromCache = null;
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            ConcurrencyManager concurrencyManager = cacheKey.getMutex();
            synchronized (concurrencyManager) {
                objectFromCache = cacheKey.getObject();
                try {
                    while (cacheKey.isAcquired() && objectFromCache == null) {
                        cacheKey.getMutex().wait(5L);
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (objectFromCache == null) {
                    return null;
                }
            }
        }
        return null;
        if (this.getSession().isClassReadOnly(theClass, descriptor)) {
            return objectFromCache;
        }
        if (this.getSession() instanceof RepeatableWriteUnitOfWork && (unregisteredDeletedClone = ((RepeatableWriteUnitOfWork)this.getSession()).getUnregisteredDeletedCloneForOriginal(objectFromCache)) != null) {
            return unregisteredDeletedClone;
        }
        return unitOfWork.cloneAndRegisterObject(objectFromCache, cacheKey, descriptor);
    }

    public Object getQueryResult(ReadQuery query, Vector parameters, boolean checkExpiry) {
        return ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().getQueryResult(query, parameters, checkExpiry);
    }

    public void putQueryResult(ReadQuery query, Vector parameters, Object results) {
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessorInstance().putQueryResult(query, parameters, results);
    }

    public void initializeAllIdentityMaps() {
        super.initializeAllIdentityMaps();
        ((UnitOfWorkImpl)this.getSession()).getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

