/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.Map;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.IsolatedClientSession;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ExclusiveIsolatedClientSession
extends IsolatedClientSession {
    public ExclusiveIsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy) {
        this(parent, connectionPolicy, null);
    }

    public ExclusiveIsolatedClientSession(ServerSession parent, ConnectionPolicy connectionPolicy, Map properties) {
        super(parent, connectionPolicy, properties);
        this.accessor = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, AbstractRecord translationRow, DatabaseQuery query) throws DatabaseException {
        if (query.getAccessor() == null) {
            if (this.getAccessor() == null) {
                this.getParent().acquireClientConnection(this);
            }
            query.setAccessor(this.getAccessor());
        }
        try {
            Object object = query.getAccessor().executeCall(call, translationRow, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                query.setAccessor(null);
                if (!this.isActive()) {
                    this.releaseWriteConnection();
                }
            }
        }
    }

    public Accessor getAccessor() {
        return this.writeConnection;
    }

    public void setAccessor(Accessor accessor) {
        this.setWriteConnection(accessor);
    }

    protected void releaseWriteConnection() {
        if (!this.isActive) {
            super.releaseWriteConnection();
        }
    }

    public void postConnectExternalConnection(Accessor accessor) {
        super.postConnectExternalConnection(accessor);
        this.getParent().getEventManager().postAcquireExclusiveConnection(this, accessor);
    }

    public void preDisconnectExternalConnection(Accessor accessor) {
        super.preDisconnectExternalConnection(accessor);
        this.getParent().getEventManager().preReleaseExclusiveConnection(this, accessor);
    }

    public boolean isExclusiveConnectionRequired() {
        return this.isActive();
    }
}

