/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Map;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingUnmarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeDirectCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChoiceCollectionMappingMarshalNodeValue
extends NodeValue
implements ContainerValue {
    private XMLChoiceCollectionMapping xmlChoiceCollectionMapping;
    private Map<XMLField, NodeValue> fieldToNodeValues;
    private NodeValue choiceElementNodeValue;
    private XMLField xmlField;

    public XMLChoiceCollectionMappingMarshalNodeValue(XMLChoiceCollectionMapping mapping, XMLField xmlField) {
        this.xmlChoiceCollectionMapping = mapping;
        this.xmlField = xmlField;
        this.initializeNodeValue();
    }

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return this.choiceElementNodeValue.isOwningNode(xPathFragment);
    }

    public void setFieldToNodeValues(Map<XMLField, NodeValue> fieldToNodeValues) {
        this.fieldToNodeValues = fieldToNodeValues;
    }

    private void initializeNodeValue() {
        XMLMapping xmlMapping = this.xmlChoiceCollectionMapping.getChoiceElementMappings().get(this.xmlField);
        this.choiceElementNodeValue = xmlMapping instanceof XMLCompositeDirectCollectionMapping ? new XMLCompositeDirectCollectionMappingNodeValue((XMLCompositeDirectCollectionMapping)xmlMapping) : new XMLCompositeCollectionMappingNodeValue((XMLCompositeCollectionMapping)xmlMapping);
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, AbstractSession session, NamespaceResolver namespaceResolver) {
        Object value = this.xmlChoiceCollectionMapping.getAttributeValueFromObject(object);
        if (value == null) {
            return false;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object iterator = cp.iteratorFor(value);
        while (cp.hasNext(iterator)) {
            Object nextValue = cp.next(iterator, session);
            this.marshalSingleValue(xPathFragment, marshalRecord, object, nextValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
        }
        return true;
    }

    @Override
    public void marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, AbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        NodeValue associatedNodeValue;
        XMLField associatedField = this.xmlChoiceCollectionMapping.getClassToFieldMappings().get(value.getClass());
        if (associatedField != null && (associatedNodeValue = this.fieldToNodeValues.get(associatedField)) != null) {
            XPathFragment frag = associatedField.getXPathFragment();
            while (frag != null) {
                ContainerValue nestedNodeValue;
                if (associatedNodeValue.isOwningNode(frag)) {
                    nestedNodeValue = (ContainerValue)((Object)((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementNodeValue());
                    nestedNodeValue.marshalSingleValue(frag, marshalRecord, object, value, session, namespaceResolver, marshalContext);
                    break;
                }
                if ((frag = frag.getNextFragment()) != null) continue;
                nestedNodeValue = (ContainerValue)((Object)((XMLChoiceCollectionMappingUnmarshalNodeValue)associatedNodeValue).getChoiceElementNodeValue());
                nestedNodeValue.marshalSingleValue(frag, marshalRecord, object, value, session, namespaceResolver, marshalContext);
            }
        }
    }

    @Override
    public boolean isMarshalNodeValue() {
        return true;
    }

    @Override
    public boolean isUnmarshalNodeValue() {
        return false;
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlChoiceCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public ContainerPolicy getContainerPolicy() {
        return this.xmlChoiceCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public XMLChoiceCollectionMapping getMapping() {
        return this.xmlChoiceCollectionMapping;
    }
}

