/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.ArithmeticFunctionNode;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class SizeNode
extends ArithmeticFunctionNode {
    public void validate(ParseTreeContext context) {
        if (this.left != null) {
            this.left.validate(context);
        }
        TypeHelper typeHelper = context.getTypeHelper();
        this.setType(typeHelper.getIntType());
    }

    public Expression generateExpression(GenerationContext context) {
        DotNode dotNode = (DotNode)this.getLeft();
        Node prefix = dotNode.getLeft();
        String variableName = ((AttributeNode)dotNode.getRight()).getAttributeName();
        if (!dotNode.endsWithCollectionField(context)) {
            throw JPQLException.invalidSizeArgument(context.getParseTreeContext().getQueryInfo(), this.getLine(), this.getColumn(), variableName);
        }
        Expression whereClause = prefix.generateExpression(context);
        whereClause = whereClause.size(variableName);
        return whereClause;
    }
}

