/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.sequencing;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.sequencing.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.tables.TableMetadata;

public class TableGeneratorMetadata
extends TableMetadata {
    private Integer m_allocationSize;
    private Integer m_initialValue;
    private String m_generatorName;
    private String m_pkColumnValue;
    private String m_pkColumnName;
    private String m_valueColumnName;

    protected TableGeneratorMetadata() {
        super("<table-generator>");
    }

    public TableGeneratorMetadata(Annotation tableGenerator, MetadataAccessibleObject accessibleObject) {
        super(tableGenerator, accessibleObject);
        this.m_allocationSize = (Integer)MetadataHelper.invokeMethod("allocationSize", tableGenerator);
        this.m_initialValue = (Integer)MetadataHelper.invokeMethod("initialValue", tableGenerator);
        this.m_generatorName = (String)MetadataHelper.invokeMethod("name", tableGenerator);
        this.m_pkColumnName = (String)MetadataHelper.invokeMethod("pkColumnName", tableGenerator);
        this.m_pkColumnValue = (String)MetadataHelper.invokeMethod("pkColumnValue", tableGenerator);
        this.m_valueColumnName = (String)MetadataHelper.invokeMethod("valueColumnName", tableGenerator);
        this.setName((String)MetadataHelper.invokeMethod("table", tableGenerator));
    }

    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof TableGeneratorMetadata) {
            TableGeneratorMetadata generator = (TableGeneratorMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_allocationSize, generator.getAllocationSize())) {
                return false;
            }
            if (!this.valuesMatch(this.m_initialValue, generator.getInitialValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_generatorName, generator.getGeneratorName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_pkColumnValue, generator.getPkColumnValue())) {
                return false;
            }
            if (!this.valuesMatch(this.m_pkColumnName, generator.getPkColumnName())) {
                return false;
            }
            return this.valuesMatch(this.m_valueColumnName, generator.getValueColumnName());
        }
        return false;
    }

    public Integer getAllocationSize() {
        return this.m_allocationSize;
    }

    public String getCatalogContext() {
        return "metadata_default_table_generator_catalog";
    }

    public String getGeneratorName() {
        return this.m_generatorName;
    }

    public String getIdentifier() {
        return this.m_generatorName;
    }

    public Integer getInitialValue() {
        return this.m_initialValue;
    }

    public String getNameContext() {
        return "metadata_default_table_generator_name";
    }

    public String getPkColumnName() {
        return this.m_pkColumnName;
    }

    public String getPkColumnValue() {
        return this.m_pkColumnValue;
    }

    public String getSchemaContext() {
        return "metadata_default_table_generator_schema";
    }

    public String getValueColumnName() {
        return this.m_valueColumnName;
    }

    public void setAllocationSize(Integer allocationSize) {
        this.m_allocationSize = allocationSize;
    }

    public void setGeneratorName(String generatorName) {
        this.m_generatorName = generatorName;
    }

    public void setInitialValue(Integer initialValue) {
        this.m_initialValue = initialValue;
    }

    public void setPkColumnName(String pkColumnName) {
        this.m_pkColumnName = pkColumnName;
    }

    public void setPkColumnValue(String pkColumnValue) {
        this.m_pkColumnValue = pkColumnValue;
    }

    public void setValueColumnName(String valueColumnName) {
        this.m_valueColumnName = valueColumnName;
    }
}

