/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.PrivateOwned;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CascadeTypes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationshipAccessor
extends MappingAccessor {
    private boolean m_privateOwned;
    private CascadeTypes m_cascadeTypes;
    protected Class m_referenceClass;
    private Class m_targetEntity;
    private Enum m_fetch;
    private Enum m_joinFetch;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();
    private String m_targetEntityName;

    protected RelationshipAccessor(String xmlElement) {
        super(xmlElement);
    }

    protected RelationshipAccessor(Annotation annotation, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(annotation, accessibleObject, classAccessor);
        Object joinColumn;
        this.m_fetch = annotation == null ? this.getDefaultFetchType() : (Enum)MetadataHelper.invokeMethod("fetch", annotation);
        this.m_targetEntity = annotation == null ? Void.TYPE : (Class)MetadataHelper.invokeMethod("targetEntity", annotation);
        this.m_cascadeTypes = annotation == null ? null : new CascadeTypes((Enum[])MetadataHelper.invokeMethod("cascade", annotation), accessibleObject);
        Object joinFetch = this.getAnnotation(JoinFetch.class);
        if (joinFetch != null) {
            this.m_joinFetch = (Enum)MetadataHelper.invokeMethod("value", joinFetch);
        }
        this.m_privateOwned = this.isAnnotationPresent(PrivateOwned.class);
        Object joinColumns = this.getAnnotation(JoinColumns.class);
        if (joinColumns != null) {
            for (Annotation jColumn : (Annotation[])MetadataHelper.invokeMethod("value", joinColumns)) {
                this.m_joinColumns.add(new JoinColumnMetadata(jColumn, accessibleObject));
            }
        }
        if ((joinColumn = this.getAnnotation(JoinColumn.class)) != null) {
            this.m_joinColumns.add(new JoinColumnMetadata((Annotation)joinColumn, accessibleObject));
        }
    }

    public CascadeTypes getCascadeTypes() {
        return this.m_cascadeTypes;
    }

    @Override
    public abstract Enum getDefaultFetchType();

    public Enum getFetch() {
        return this.m_fetch;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    protected abstract String getLoggingContext();

    protected DatabaseMapping getOwningMapping(String mappedBy) {
        MetadataDescriptor ownerDescriptor = this.getReferenceDescriptor();
        DatabaseMapping mapping = ownerDescriptor.getMappingForAttributeName(mappedBy, this);
        if (mapping == null) {
            throw ValidationException.noMappedByAttributeFound(ownerDescriptor.getJavaClass(), mappedBy, this.getJavaClass(), this.getAttributeName());
        }
        return mapping;
    }

    public String getPrivateOwned() {
        return null;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        MetadataDescriptor descriptor;
        try {
            descriptor = super.getReferenceDescriptor();
        }
        catch (Exception exception) {
            descriptor = null;
        }
        if (descriptor == null || descriptor.isEmbeddable() || descriptor.isEmbeddableCollection()) {
            throw ValidationException.nonEntityTargetInRelationship(this.getJavaClass(), this.getReferenceClass(), this.getAnnotatedElement());
        }
        return descriptor;
    }

    public Class getTargetEntity() {
        return this.m_targetEntity;
    }

    public String getTargetEntityName() {
        return this.m_targetEntityName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.initXMLObjects(this.m_joinColumns, accessibleObject);
        this.initXMLObject(this.m_cascadeTypes, accessibleObject);
        this.m_targetEntity = this.initXMLClassName(this.m_targetEntityName);
    }

    public boolean isLazy() {
        Enum fetchType = this.getFetch();
        if (fetchType == null) {
            fetchType = this.getDefaultFetchType();
        }
        return fetchType.equals(FetchType.LAZY);
    }

    public boolean isPrivateOwned() {
        return this.m_privateOwned;
    }

    protected void processCascadeTypes(ForeignReferenceMapping mapping) {
        if (this.m_cascadeTypes != null) {
            for (Enum cascadeType : this.m_cascadeTypes.getTypes()) {
                this.setCascadeType(cascadeType, mapping);
            }
        }
        if (this.getDescriptor().isCascadePersist() && !mapping.isCascadePersist()) {
            this.setCascadeType((Enum)CascadeType.PERSIST, mapping);
        }
    }

    protected List<JoinColumnMetadata> processJoinColumns() {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.processJoinColumns(this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns(), this.getReferenceDescriptor());
        }
        return this.processJoinColumns(this.m_joinColumns, this.getReferenceDescriptor());
    }

    protected List<JoinColumnMetadata> processJoinColumns(List<JoinColumnMetadata> joinColumns, MetadataDescriptor descriptor) {
        if (joinColumns.isEmpty()) {
            if (descriptor.hasCompositePrimaryKey()) {
                for (String primaryKeyField : descriptor.getPrimaryKeyFieldNames()) {
                    JoinColumnMetadata joinColumn = new JoinColumnMetadata();
                    joinColumn.setReferencedColumnName(primaryKeyField);
                    joinColumn.setName(primaryKeyField);
                    joinColumns.add(joinColumn);
                }
            } else {
                joinColumns.add(new JoinColumnMetadata());
            }
        } else {
            for (JoinColumnMetadata joinColumn : joinColumns) {
                joinColumn.setReferencedColumnName(descriptor.getPrimaryKeyJoinColumnAssociation(joinColumn.getReferencedColumnName()));
            }
        }
        if (descriptor.hasCompositePrimaryKey()) {
            if (joinColumns.size() != descriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
            for (JoinColumnMetadata joinColumn : joinColumns) {
                if (!joinColumn.isPrimaryKeyFieldNotSpecified() && !joinColumn.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
        } else if (joinColumns.size() > 1) {
            throw ValidationException.excessiveJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
        }
        return joinColumns;
    }

    public void processRelationship() {
        if (!this.isProcessed()) {
            if (this.hasColumn()) {
                throw ValidationException.invalidColumnAnnotationOnRelationship(this.getJavaClass(), this.getAttributeName());
            }
            if (this.hasConvert()) {
                throw ValidationException.invalidMappingForConverter(this.getJavaClass(), this.getAttributeName());
            }
            if (!(this.getTargetEntity() == ValueHolderInterface.class || this.getTargetEntity() == Void.TYPE && this.getReferenceClass().getName().equalsIgnoreCase(ValueHolderInterface.class.getName()))) {
                this.process();
            }
            this.setIsProcessed();
        }
    }

    protected void setCascadeType(Enum type, ForeignReferenceMapping mapping) {
        if (type.equals(CascadeType.ALL)) {
            mapping.setCascadeAll(true);
        } else if (type.equals(CascadeType.MERGE)) {
            mapping.setCascadeMerge(true);
        } else if (type.equals(CascadeType.PERSIST)) {
            mapping.setCascadePersist(true);
        } else if (type.equals(CascadeType.REFRESH)) {
            mapping.setCascadeRefresh(true);
        } else if (type.equals(CascadeType.REMOVE)) {
            mapping.setCascadeRemove(true);
        }
    }

    public void setCascadeTypes(CascadeTypes cascadeTypes) {
        this.m_cascadeTypes = cascadeTypes;
    }

    public void setFetch(Enum fetch) {
        this.m_fetch = fetch;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setJoinFetch(Enum joinFetch) {
        this.m_joinFetch = joinFetch;
    }

    public void setPrivateOwned(String ignore) {
        this.m_privateOwned = true;
    }

    public void setTargetEntity(Class targetEntity) {
        this.m_targetEntity = targetEntity;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.m_targetEntityName = targetEntityName;
    }

    public boolean usesIndirection() {
        if (this.getProject().weaveEager()) {
            return true;
        }
        return this.isLazy();
    }
}

