/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryProvider;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.jpa.PersistenceInitializationActivator;
import org.eclipse.persistence.internal.jpa.deployment.Archive;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class OSGiInitializer
implements PersistenceInitializationActivator {
    private ClassLoader classLoader;
    protected boolean shouldCreateInternalLoader = true;

    public OSGiInitializer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected boolean callPredeploy(SEPersistenceUnitInfo persistenceUnitInfo, Map m, PersistenceInitializationActivator persistenceActivator) {
        String providerClassName = persistenceUnitInfo.getPersistenceProviderClassName();
        if (persistenceActivator.isPersistenceProviderSupported(providerClassName)) {
            String puName = PersistenceUnitProcessor.buildPersistenceUnitName(persistenceUnitInfo.getPersistenceUnitRootUrl(), persistenceUnitInfo.getPersistenceUnitName());
            EntityManagerSetupImpl emSetupImpl = EntityManagerFactoryProvider.getEntityManagerSetupImpl(puName);
            if (emSetupImpl != null && !emSetupImpl.isUndeployed()) {
                return false;
            }
            AbstractSessionLog.getLog().log(2, "cmp_init_invoke_predeploy", persistenceUnitInfo.getPersistenceUnitName());
            Map mergedProperties = EntityManagerFactoryProvider.mergeMaps(m, persistenceUnitInfo.getProperties());
            String weaving = "false";
            mergedProperties.put("eclipselink.weaving", weaving);
            this.shouldCreateInternalLoader = false;
            persistenceUnitInfo.setNewTempClassLoader(this.classLoader);
            if (emSetupImpl == null) {
                emSetupImpl = new EntityManagerSetupImpl();
                EntityManagerFactoryProvider.addEntityManagerSetupImpl(persistenceUnitInfo.getPersistenceUnitRootUrl() + persistenceUnitInfo.getPersistenceUnitName(), emSetupImpl);
            }
            persistenceUnitInfo.setClassLoader(this.classLoader);
            emSetupImpl.predeploy(persistenceUnitInfo, mergedProperties);
            return true;
        }
        return false;
    }

    protected void initPersistenceUnits(Archive archive, Map m, PersistenceInitializationActivator persistenceActivator) {
        for (SEPersistenceUnitInfo persistenceUnitInfo : PersistenceUnitProcessor.getPersistenceUnits(archive, this.classLoader)) {
            this.callPredeploy(persistenceUnitInfo, m, persistenceActivator);
        }
    }

    public void initialize(Map m, PersistenceInitializationActivator persistenceActivator) {
        Set<Archive> pars = PersistenceUnitProcessor.findPersistenceArchives(this.classLoader);
        for (Archive archive : pars) {
            AbstractSessionLog.getLog().log(2, "cmp_init_initialize", archive);
            this.initPersistenceUnits(archive, m, persistenceActivator);
        }
    }

    public boolean isPersistenceProviderSupported(String providerClassName) {
        return providerClassName == null || providerClassName.equals("") || providerClassName.equals(EntityManagerFactoryProvider.class.getName()) || providerClassName.equals(PersistenceProvider.class.getName());
    }

    public static void initializeTopLinkLoggingFile() {
        String loggingFile = System.getProperty("eclipselink.logging.file");
        try {
            if (loggingFile != null) {
                AbstractSessionLog.getLog().setWriter(new FileWriter(loggingFile));
            }
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(6, "cmp_init_default_logging_file_is_invalid", loggingFile, e);
        }
    }

    protected Set loadEntityClasses(Collection entityNames, ClassLoader classLoader) {
        HashSet entityClasses = new HashSet();
        AbstractSessionLog.getLog().log(2, "cmp_loading_entities_using_loader", classLoader);
        for (String entityClassName : entityNames) {
            try {
                entityClasses.add(classLoader.loadClass(entityClassName));
            }
            catch (ClassNotFoundException cnfEx) {
                throw ValidationException.entityClassNotFound(entityClassName, classLoader, cnfEx);
            }
        }
        return entityClasses;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TempEntityLoader
    extends URLClassLoader {
        Collection classNames;
        boolean shouldOverrideLoadClassForCollectionMembers;

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.getParent().getResources(name);
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames, boolean shouldOverrideLoadClassForCollectionMembers) {
            super(urls, parent);
            this.classNames = classNames;
            this.shouldOverrideLoadClassForCollectionMembers = shouldOverrideLoadClassForCollectionMembers;
        }

        public TempEntityLoader(URL[] urls, ClassLoader parent, Collection classNames) {
            this(urls, parent, classNames, true);
        }

        protected boolean shouldOverrideLoadClass(String name) {
            if (this.shouldOverrideLoadClassForCollectionMembers) {
                return this.classNames != null && this.classNames.contains(name);
            }
            return !name.startsWith("java.") && !name.startsWith("javax.") && (this.classNames == null || !this.classNames.contains(name));
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.shouldOverrideLoadClass(name)) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
            return super.loadClass(name, resolve);
        }
    }
}

