#include "headers.h"
#include "cryptopp/sha.h"
#include "db.h"
#include "net.h"
#include "init.h"
#include "wallet_func.h"
#undef printf
#include <boost/asio.hpp>
#include <boost/iostreams/concepts.hpp>
#include <boost/iostreams/stream.hpp>
#include <boost/algorithm/string.hpp>
#include "json/json_spirit_reader_template.h"
#include "json/json_spirit_writer_template.h"
#include "json/json_spirit_utils.h"
#define printf OutputDebugStringF

using namespace std;
using namespace boost;
using namespace boost::asio;
using namespace json_spirit;


int64 g_MiningShareTargetInt=0;
int64 g_MiningTestWorkShares=0;
int64 g_MiningTestWorkInvalids=0;

int64 g_qShareTimeWindow=8;
uint256 g_MiningShareTargetHash;
string g_MiningIDString;

CCriticalSection g_MineControl,g_MineStatusControl;
std::vector<MINING_POOL*> g_MinePoolList;
std::vector<std::string> g_MineStatusList;
int64 g_MiningRPCDelay=60000;
bool g_bTrustedMiningOnly=false;


extern CCriticalSection cs_main;

void Mining_AddPool(MINING_POOL *pPool);
void Mining_RemovePool(int id);
Object CallRPC(const string& host, const string& port, const string& base64UserString, const string& strMethod, const Array& params);

void Mining_AddPool(MINING_POOL *pPool)
{
    MINING_POOL *pNewPool= new MINING_POOL;
    *pNewPool=*pPool;
    pNewPool->pThreads=0;
    pNewPool->nRunning=0;
    pNewPool->qLastHeight=-1;
    pNewPool->qLastGetWork=0;
    pNewPool->pCallRPC=0;
    pNewPool->nQuit=0;
    pNewPool->nFirstWork=0;
    pNewPool->pCRIT = new CCriticalSection;



    std::string userpass=pNewPool->user + ":" + pNewPool->pass;
    pNewPool->strUserPass64 = EncodeBase64(userpass);


    {
        MUTEX_LOCK(g_MineControl);
        Mining_RemovePool(pNewPool->id);
        g_MinePoolList.push_back(pNewPool);
    }
}

void Mining_RemovePool(int id)
{
    MUTEX_LOCK(g_MineControl);

    for(int x=0;x<g_MinePoolList.size();x++)
    {
        if(id==g_MinePoolList[x]->id)
        {
            g_MinePoolList[x]->nQuit=1;
            for(int z=0;z<g_MinePoolList[x]->nRunning;z++)  g_MinePoolList[x]->pThreads[z].nQuit=1;
            g_MinePoolList[x]->id=-1;
        }
    }
}


void SolidCoinMiner(void* parg)
{
    unsigned char *blockdata = new unsigned char[512];
    int nCountAtOnce=0;
    uint256 hashTarget;
    uint256 endhash;
    MINING_POOL_THREAD *pThreadPool=(MINING_POOL_THREAD*)parg;

    bool bGetNewData=true;
    SetThreadPriority(THREAD_PRIORITY_LOWEST);

    BLOCK_DATA *pBlock=(BLOCK_DATA*)blockdata;

    int64 nStartTime=0;
    int64 nMilliStart=0;

    while (1)
    {
        if (pThreadPool->nQuit)
        {
            pThreadPool->nQuit++;
            delete[] blockdata;
            return;
        }
        if (fShutdown)
        {
            delete[] blockdata;
            return;
        }
        if(pThreadPool->nHasWork==0)
        {
            Sleep(1);
            continue;
        }

        if(pThreadPool->nHasWork==1)
        {
            MUTEX_LOCK(*pThreadPool->pCRIT);
            *pBlock = *pThreadPool->pBlockData;
            nStartTime = pBlock->nTime+1;
            pBlock->nNonce1 = ((uint64)pThreadPool->nID<<32);
            hashTarget=*pThreadPool->pTarget;
            pThreadPool->nHasWork=2;
            nMilliStart=GetTimeMillis();
        }

		if(g_bTrustedMiningOnly && (pBlock->nBlockNum%2)==1 )
		{
			Sleep(100);
			continue;
		}

        pBlock->nTime=nStartTime+ ((GetTimeMillis()-nMilliStart)/1000);    //update time

        nCountAtOnce=0;
        while(++nCountAtOnce<200)
        {
            ++pBlock->nNonce1;
            BlockHash_1(endhash,blockdata);
            if(endhash < hashTarget)
            {
                pThreadPool->qShareCount++;     //increase share count
                MUTEX_LOCK(*pThreadPool->pCRIT);
                pThreadPool->pBlockFoundList->push_back(*pBlock); //submit solution
                break;
            }
        }
        pThreadPool->qCurHashCount+=nCountAtOnce;
    }
}

struct CALLRPC_THREAD
{
    std::string name;
    std::string host;
    std::string port;
    std::string userpass64;
    std::string method;
    Array params;

    Object result;
    std::string error;
    bool bFinished;
};
void GetRPCThread(void* parg)
{
    CALLRPC_THREAD *pThread = (CALLRPC_THREAD*)parg;
    try
    {
        pThread->result = CallRPC(pThread->host,pThread->port,pThread->userpass64,pThread->method,pThread->params);
    }
    catch (std::exception& e)
    {
        pThread->error = str(boost::format("%s - %s error: %s") % pThread->name % pThread->method % e.what());
    }
    catch (Object& objError)
    {
        pThread->error = str(boost::format("%s - %s error") % pThread->name % pThread->method);
    }
    pThread->bFinished=true;
}

CALLRPC_THREAD* DoCallRPC(const std::string &method, Array &params, MINING_POOL *pPool)
{
    CALLRPC_THREAD *pThread = new CALLRPC_THREAD;

    pThread->name = pPool->name;
    pThread->host = pPool->host;
    pThread->port = itostr(pPool->nPort);
    pThread->userpass64 = pPool->strUserPass64;
    pThread->method=method;
    pThread->params = params;
    pThread->bFinished=false;
    CreateThread(GetRPCThread, pThread);
    return pThread;
}

void HandlePool(MINING_POOL *pPool)
{
    //see if blockcount has changed since we last got a share
    CALLRPC_THREAD *pRPCThread = (CALLRPC_THREAD*)pPool->pCallRPC;

    if(pRPCThread && pRPCThread->bFinished)
    {
        if(pRPCThread->error.length())
        {
            g_MineStatusList.push_back(pRPCThread->error);
            goto END_RPC;
        }

        try
        {
            if(pRPCThread->method=="sc_getwork")
            {
                const Value& result = find_value(pRPCThread->result, "result");
                const Value& error  = find_value(pRPCThread->result, "error");
                if (error.type() != null_type)
                {
                    Object obj = error.get_obj();
                    Value msg = find_value(obj, "message");
                    throw runtime_error(msg.get_str());
                }
                else if (result.type() == obj_type)
                {
                    Object obj = result.get_obj();
                    Value data = find_value(obj, "data");
                    Value target = find_value(obj, "target_share");
                    vector<unsigned char> vchData = ParseHex(data.get_str());
                    if (vchData.size() != 128)
                    {
                        throw runtime_error("Wrong data size returned");
                    }

                    CBlock block1;
                    block1.blk = *((BLOCK_DATA*)&vchData[0]);
                    CBigNum bn;
                    bn.SetHex(target.get_str());

                    {
                        MUTEX_LOCK(*pPool->pCRIT);
                        pPool->hashTarget = bn.getuint256();
                        pPool->blk = block1.blk;
                        pPool->qLastHeight=g_qBlockBestHeight;

                        if(!pPool->pThreads)
                        {
                            if(pPool->nFirstWork<2)
                            {
                                g_MineStatusList.push_back(str(boost::format("First work received at %s") % pPool->name));
                                pPool->nFirstWork++;
                            }


                            pPool->pThreads = new MINING_POOL_THREAD[pPool->nThreads];
                            while(pPool->nRunning<pPool->nThreads)
                            {
                                MINING_POOL_THREAD *pMineThread=&pPool->pThreads[pPool->nRunning];
                                pMineThread->nID=pPool->nRunning;
                                pMineThread->qShareCount=0;
                                pMineThread->nHasWork=0;
                                pMineThread->nQuit=0;
                                pMineThread->qLastHashCount=0;
                                pMineThread->qCurHashCount=0;
                                pMineThread->pTarget=&pPool->hashTarget;
                                pMineThread->pCRIT=pPool->pCRIT;
                                pMineThread->pBlockData=&pPool->blk;
                                pMineThread->pBlockFoundList=&pPool->blockFoundList;
                                CreateThread(SolidCoinMiner,pMineThread);
                                pPool->nRunning++;
                            }
                        }

                        debugprintf(VERBOSE, "GETWORK: Got work (%s prevhash) %"PRI64d" height:\n",pPool->blk.hashPrevBlock.ToString().c_str(),g_qBlockBestHeight);
                        int x=0;
                        while(x<pPool->nThreads)
                        {
                            pPool->pThreads[x].nHasWork=1;
                            x++;
                        }
                    }
                }
            }
        }
        catch (std::exception& e)
        {
            debugprintf(ERR, "%s - %s error: %s \n",pPool->name.c_str(),pRPCThread->method.c_str() ,e.what());
            pRPCThread->error = str(boost::format("%s - %s error: %s") % pRPCThread->name % pRPCThread->method % e.what());
            g_MineStatusList.push_back(pRPCThread->error);
        }
END_RPC:
        delete pRPCThread;
        pRPCThread=0;
        pPool->pCallRPC=0;
    }

    if((GetTimeMillis()-pPool->qLastGetWork)>=g_MiningRPCDelay || ((GetTimeMillis()-pPool->qLastGetWork)>=1000 && pPool->qLastHeight!=g_qBlockBestHeight) )
    {
        if(pPool->qLastHeight!=g_qBlockBestHeight)
        {
            //stop mining threads until we get new work
            MUTEX_LOCK(*pPool->pCRIT);
            int x=0;
            while(x<pPool->nRunning)    pPool->pThreads[x++].nHasWork=0;
        }
        pPool->qLastGetWork=GetTimeMillis();

        if(pRPCThread==0)
        {
            Array params;

            if(pPool->nFirstWork==0)
            {
                g_MineStatusList.push_back(str(boost::format("Starting miners at %s") % pPool->name));
                pPool->nFirstWork++;
            }
            pPool->pCallRPC=pRPCThread=DoCallRPC("sc_getwork",params,pPool);
        }
    }

    //submit any shares found

    {
        MUTEX_LOCK(*pPool->pCRIT);
        if(pPool->blockFoundList.size())
        {
            unsigned char *pBlockData = new unsigned char[128*pPool->blockFoundList.size()];
            for(int x=0;x<pPool->blockFoundList.size();x++) memcpy(pBlockData+(x*128),&pPool->blockFoundList[x],128);
            Array params;
            params.push_back(HexStr(pBlockData,pBlockData+(128*pPool->blockFoundList.size()) ));
            if(pRPCThread==0)
            {
                pPool->pCallRPC=pRPCThread=DoCallRPC("sc_testwork",params,pPool);
            }
            pPool->blockFoundList.clear();
        }
    }
}
void SolidCoinMineController(void* parg)
{
    int64 nHPSTimerStart=0;
    int64 nMilliTime=0;
    int64 nMiningStart=GetTimeMillis();
    int64 qLastShares=0;
    int64 qLastInvalids=0;
    bool bAutoStartCheck=true;
    std::vector<MINING_SPEEDS> *speedlist=0;
    std::vector<MINING_SPEEDS> testworkspeeds;

	g_bTrustedMiningOnly = Setting_GetBOOL("trustedminingonly");
    g_MiningRPCDelay = Setting_GetINT64("mining_workmaxperiod")*1000;
    g_MiningShareTargetInt = Setting_GetINT64("mining_sharetarget");
    g_MiningIDString = Setting_Get("mining_id");
    g_qShareTimeWindow= Setting_GetINT64("mining_servertimewindow");
    if(g_qShareTimeWindow<1)    g_qShareTimeWindow=1;
    if(g_qShareTimeWindow>30)   g_qShareTimeWindow=30;


    if(g_MiningShareTargetInt>0)
    {
        CBigNum bn=g_bnBlockProofOfWorkLimit;
        bn= bn/g_MiningShareTargetInt;
        g_MiningShareTargetHash = bn.getuint256();
    }

    while(1)
    {
        if(fShutdown) return;
        bool bUpdateGUI=false;
        speedlist=0;

        if (bAutoStartCheck && GetTimeMillis() - nMiningStart > 30000)
        {
            MUTEX_LOCK(cs_main);
            for(int x=0;x<g_MiningPoolList.size();x++)
            {
                MINING_POOL *pPool=&g_MiningPoolList[x];

                if(pPool->bAutoStart==false || pPool->nRunning) continue;
                pPool->id=x;
                Mining_AddPool(pPool);
                pPool->nRunning=1;
                pPool->qLastHashPerSec=0;
                pPool->qTotalHash=0;
                pPool->qTotalShares=0;
            }
            bAutoStartCheck=false;
        }

        if (GetTimeMillis() - nHPSTimerStart > 500)
        {
            nMilliTime = GetTimeMillis()-nHPSTimerStart;
            speedlist = new std::vector<MINING_SPEEDS>;
            bUpdateGUI=true;
            nHPSTimerStart=GetTimeMillis();
        }

        {
            MUTEX_LOCK(g_MineControl);
            for(int x=0;x<g_MinePoolList.size();x++)
            {
                if(g_MinePoolList[x]->nQuit)
                {
                    int nCount=0;   //make sure all worker threads have quit
                    for(int z=0;z<g_MinePoolList[x]->nRunning;z++)
                    {
                        if(g_MinePoolList[x]->pThreads[z].nQuit==2) nCount++;
                    }
                    if(nCount==g_MinePoolList[x]->nRunning && g_MinePoolList[x]->nQuit==1)
                    {
                        CalledUpdateMiningStatus(str(boost::format("All mining threads closed at %s") % g_MinePoolList[x]->name));
                        g_MinePoolList[x]->nQuit=2;
                    }

                    CALLRPC_THREAD *pRPCThread = (CALLRPC_THREAD*)g_MinePoolList[x]->pCallRPC;
                    if(pRPCThread && pRPCThread->bFinished)
                    {
                        delete pRPCThread;
                        g_MinePoolList[x]->pCallRPC=0;

                    }
                    if(g_MinePoolList[x]->nQuit==2 && g_MinePoolList[x]->pCallRPC==0)
                    {
                        delete g_MinePoolList[x];
                        g_MinePoolList.erase(g_MinePoolList.begin()+x);     //remove pool
                        x--;    //since we've removed an item , need to decrement x
                    }
                    continue;
                }

                HandlePool(g_MinePoolList[x]);
                if(bUpdateGUI)
                {
                    MINING_SPEEDS speed;
                    speed.nID=g_MinePoolList[x]->id;
                    speed.qHash=0;
                    speed.qShares=0;
                    for(int z=0;z<g_MinePoolList[x]->nRunning;z++)
                    {
                        MINING_POOL_THREAD*pThreadPool=&g_MinePoolList[x]->pThreads[z];
                        speed.qShares+=pThreadPool->qShareCount;
                        if(pThreadPool->qCurHashCount>pThreadPool->qLastHashCount)
                        {
                            speed.qHash+=pThreadPool->qCurHashCount-pThreadPool->qLastHashCount;
                            pThreadPool->qLastHashCount=pThreadPool->qCurHashCount;
                        }
                    }
                    speedlist->push_back(speed);
                }
            }
        }

        BOOST_FOREACH(std::string s,g_MineStatusList)
        {
            UIThreadCall(boost::bind(CalledUpdateMiningStatus,s));
        }
        g_MineStatusList.clear();

        if(bUpdateGUI)
        {
            MINING_SPEEDS speed;
            if(g_MiningTestWorkShares!=qLastShares || g_MiningTestWorkInvalids!=qLastInvalids)
            {
                int64 qShares=g_MiningTestWorkShares-qLastShares;
                qLastShares=g_MiningTestWorkShares;
                qLastInvalids=g_MiningTestWorkInvalids;
                speed.qTime=GetTimeMillis();
                speed.qShares=qShares;
                testworkspeeds.push_back(speed);
            }

            speed.nID=-1;
            speed.qShares=0;

            std::vector<MINING_SPEEDS>::iterator iter;
            for(iter=testworkspeeds.begin();iter!=testworkspeeds.end();)
            {
                if(GetTimeMillis()-iter->qTime > 30000)
                {
                    iter = testworkspeeds.erase(iter);
                }
                else
                {
                    speed.qShares+=iter->qShares;
                    ++iter;
                }
            }

            speed.qHash=(speed.qShares*131072)/30;
            speed.qShares=g_MiningTestWorkShares;
            speed.qInvalid=g_MiningTestWorkInvalids;

            speedlist->push_back(speed);
        }

        if(bUpdateGUI)
        {
            UIThreadCall(boost::bind(CalledUpdateMiningHash,nMilliTime,speedlist));
        }
        Sleep(20);
    }


}
