// Copyright (c) 2011 RealSolid. Please read license.txt for applicable licensing.

#ifndef DEFINES_H
#define DEFINES_H

#define CPF_PERCENT 0.05
#define TRUST_FUND_NUM  10

#define GEN_KEY "04dd58690a26059b569e458c30480f20cd2875693fb6008c1157db7168370156ef19a37bc7440541bd692f7cea15db7c50bf19cd233d2c983267962bae4a914907"
#define CPF_KEY "04180c4694b407675b133fa4d67c2640d8e8e7345e4e14b6c45fa632c1480186e3a9e6d644dfceee5262e7455f88cdb823e4f4b2984f7878f9fa62fb2489df6c60"

extern const int VERSION;
typedef boost::int64_t  int64;
typedef boost::uint64_t   uint64;
typedef boost::int32_t  int32;
typedef boost::uint32_t   uint32;

extern const uint64 TRUST_FUND_AMOUNT;
extern const unsigned int MAX_BLOCK_SIZE;
extern const unsigned int MAX_TX_SIZE;
extern const unsigned int MAX_BLOCK_SIZE_GEN;
extern const int MAX_BLOCK_SIGOPS;
extern const int64 COIN;
extern const int64 CENT;
extern const int64 MIN_TX_FEE;
//static const int COINBASE_MATURITY = 100;
extern const int COINBASE_MATURITY;
// Threshold for nLockTime: below this value it is interpreted as block number, otherwise as UNIX timestamp.
extern const int LOCKTIME_THRESHOLD; // Tue Nov  5 00:53:20 1985 UTC
extern const int fHaveUPnP;


extern uint32 nTransactionsUpdated;
extern double dHashesPerSec;
extern int64 nHPSTimerStart;
extern int64 g_qTimeBestReceived;

#endif
