/*
 * Decompiled with CFR 0.152.
 */
package org.uddi4j.response;

import org.uddi4j.UDDIElement;
import org.uddi4j.UDDIException;
import org.uddi4j.datatype.Name;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServiceInfo
extends UDDIElement {
    public static final String UDDI_TAG = "serviceInfo";
    protected Element base = null;
    String serviceKey = null;
    String businessKey = null;
    Name name = null;

    public ServiceInfo() {
    }

    public ServiceInfo(String serviceKey, String name) {
        this.serviceKey = serviceKey;
        this.name = new Name(name);
    }

    public ServiceInfo(Element base) throws UDDIException {
        super(base);
        this.serviceKey = base.getAttribute("serviceKey");
        this.businessKey = base.getAttribute("businessKey");
        NodeList nl = null;
        nl = this.getChildElementsByTagName(base, "name");
        if (nl.getLength() > 0) {
            this.name = new Name((Element)nl.item(0));
        }
    }

    public void setServiceKey(String s) {
        this.serviceKey = s;
    }

    public void setBusinessKey(String s) {
        this.businessKey = s;
    }

    public void setName(Name s) {
        this.name = s;
    }

    public void setName(String s) {
        this.name = new Name();
        this.name.setText(s);
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Name getName() {
        return this.name;
    }

    public String getNameString() {
        return this.name.getText();
    }

    public void saveToXML(Element parent) {
        this.base = parent.getOwnerDocument().createElement(UDDI_TAG);
        if (this.serviceKey != null) {
            this.base.setAttribute("serviceKey", this.serviceKey);
        }
        if (this.businessKey != null) {
            this.base.setAttribute("businessKey", this.businessKey);
        }
        if (this.name != null) {
            this.name.saveToXML(this.base);
        }
        parent.appendChild(this.base);
    }
}

