/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.registry;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Int;
import com.jniwrapper.Int32;
import com.jniwrapper.NoSuchFunctionException;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.Str;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.FunctionName;
import com.jniwrapper.win32.Handle;
import com.jniwrapper.win32.system.AdvApi32;

class WinRegistry
extends AdvApi32 {
    private static final String FUNCTION_CLOSE_KEY = "RegCloseKey";
    private static final FunctionName FUNCTION_CREATE_KEY_EX = new FunctionName("RegCreateKeyEx");
    private static final FunctionName FUNCTION_DELETE_KEY = new FunctionName("RegDeleteKey");
    private static final FunctionName FUNCTION_DELETE_KEY_EX = new FunctionName("RegDeleteKeyEx");
    private static final FunctionName FUNCTION_DELETE_VALUE = new FunctionName("RegDeleteValue");
    private static final FunctionName FUNCTION_ENUM_KEY_EX = new FunctionName("RegEnumKeyEx");
    private static final FunctionName FUNCTION_ENUM_VALUE = new FunctionName("RegEnumValue");
    private static final String FUNCTION_FLUSH_KEY = "RegFlushKey";
    private static final FunctionName FUNCTION_LOAD_KEY = new FunctionName("RegLoadKey");
    private static final String FUNCTION_NOTIFY_CHANGE_KEY_VALUE = "RegNotifyChangeKeyValue";
    private static final FunctionName FUNCTION_OPEN_KEY_EX = new FunctionName("RegOpenKeyEx");
    private static final String FUNCTION_OVERRIDE_PREDEF_KEY = "RegOverridePredefKey";
    private static final FunctionName FUNCTION_QUERY_INFO_KEY = new FunctionName("RegQueryInfoKey");
    private static final FunctionName FUNCTION_QUERY_VALUE_EX = new FunctionName("RegQueryValueEx");
    private static final FunctionName FUNCTION_REPLACE_KEY = new FunctionName("RegReplaceKey");
    private static final FunctionName FUNCTION_RESTORE_KEY = new FunctionName("RegRestoreKey");
    private static final FunctionName FUNCTION_SAVE_KEY = new FunctionName("RegSaveKey");
    private static final FunctionName FUNCTION_SET_VALUE_EX = new FunctionName("RegSetValueEx");
    private static final FunctionName FUNCTION_UNLOAD_KEY = new FunctionName("RegUnLoadKey");
    private static Boolean DeleteKeyExAvailable = null;

    WinRegistry() {
    }

    public static long closeKey(Handle key) {
        Function function = WinRegistry.get(FUNCTION_CLOSE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key);
        return result.getValue();
    }

    public static long createKey(int key, String subKey, long options, long accessType, Handle resultKey) {
        return WinRegistry.createKey(new Handle(key), subKey, options, accessType, resultKey);
    }

    public static long createKey(Handle key, String subKey, long options, long accessType, Handle resultKey) {
        return WinRegistry.createKey(key, subKey, options, accessType, resultKey, null);
    }

    public static long createKey(Handle key, String subKey, long options, long accessType, Handle resultKey, UInt32 disposition) {
        Function function = WinRegistry.get(FUNCTION_CREATE_KEY_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer.Const((Parameter)new Str(subKey)), new UInt32(0L), new Pointer(null, true), new UInt32(options), new UInt32(accessType), new Pointer(null, true), new Pointer((Parameter)resultKey), new Pointer((Parameter)disposition, disposition == null)});
        return result.getValue();
    }

    public static long deleteKey(Handle key, String subKey) {
        Function function = WinRegistry.get(FUNCTION_DELETE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)new Str(subKey));
        return result.getValue();
    }

    public static long deleteKey(Handle key, String subKey, int samDesired) {
        if (WinRegistry.isDeleteExFunctionAvailable()) {
            return WinRegistry.deleteKeyEx(key, subKey, samDesired);
        }
        return WinRegistry.deleteKey(key, subKey);
    }

    private static boolean isDeleteExFunctionAvailable() {
        if (DeleteKeyExAvailable == null) {
            try {
                WinRegistry.get(FUNCTION_DELETE_KEY_EX);
                DeleteKeyExAvailable = Boolean.TRUE;
            }
            catch (NoSuchFunctionException e) {
                DeleteKeyExAvailable = Boolean.FALSE;
            }
        }
        return DeleteKeyExAvailable;
    }

    public static long deleteKeyEx(Handle key, String subKey, int samDesired) {
        Function function = WinRegistry.get(FUNCTION_DELETE_KEY_EX);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)new Str(subKey), (Parameter)new UInt32((long)samDesired), (Parameter)new UInt32());
        return result.getValue();
    }

    public static long deleteValue(Handle key, String valueName) {
        Function function = WinRegistry.get(FUNCTION_DELETE_VALUE);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)new Str(valueName));
        return result.getValue();
    }

    public static long enumKeyEx(Handle key, int index, Str name, UInt32 cName, Str className, UInt32 cClassName) {
        Function function = WinRegistry.get(FUNCTION_ENUM_KEY_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new UInt32((long)index), new Pointer.OutOnly((Parameter)name), new Pointer((Parameter)cName), new Pointer(null, true), new Pointer((Parameter)className, className == null), new Pointer((Parameter)cClassName, cClassName == null), new Handle()});
        return result.getValue();
    }

    public static long enumValue(Handle key, int index, Str valueName, UInt32 cValueName, UInt32 type, Pointer data, UInt32 cData) {
        Function function = WinRegistry.get(FUNCTION_ENUM_VALUE);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new UInt32((long)index), new Pointer.OutOnly((Parameter)valueName), new Pointer((Parameter)cValueName), new Pointer(null, true), new Pointer((Parameter)type, type == null), data == null ? new Pointer.Void() : data, new Pointer((Parameter)cData, cData == null)});
        return result.getValue();
    }

    public static long getValue(Handle key, String name, int type, Parameter value) {
        Function function = WinRegistry.get(FUNCTION_QUERY_VALUE_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer((Parameter)new Str(name), name == null), new Pointer(null, true), new Pointer((Parameter)new Int32(type)), new Pointer(value), new Pointer((Parameter)new Int32(value.getLength()))});
        return result.getValue();
    }

    public static long getValueInfo(Handle key, String name, Int32 type, Int32 size) {
        Function function = WinRegistry.get(FUNCTION_QUERY_VALUE_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer((Parameter)new Str(name), name == null), new Pointer(null, true), new Pointer((Parameter)type), new Pointer(null, true), new Pointer((Parameter)size)});
        return result.getValue();
    }

    public static long setValue(Handle key, String name, int type, Parameter value, int valueSize) {
        Function function = WinRegistry.get(FUNCTION_SET_VALUE_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer((Parameter)new Str(name), name == null), new UInt32(0L), new UInt32((long)type), new Pointer.Const(value), new Int32(valueSize)});
        return result.getValue();
    }

    public static long flushKey(Handle key) {
        Function function = WinRegistry.get(FUNCTION_FLUSH_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key);
        return result.getValue();
    }

    public static long loadKey(Handle key, String subKey, String file) {
        Function function = WinRegistry.get(FUNCTION_LOAD_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)new Str(subKey), (Parameter)new Str(file));
        return result.getValue();
    }

    public static long saveKey(Handle key, String file) {
        Function function = WinRegistry.get(FUNCTION_SAVE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)new Str(file), (Parameter)new Pointer(null, true));
        return result.getValue();
    }

    public static long unloadKey(Handle key, String subKey) {
        Function function = WinRegistry.get(FUNCTION_UNLOAD_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)new Str(subKey));
        return result.getValue();
    }

    public static long notifyChangeValue(Handle key, boolean watchSubtree, int notifyFilter, Handle event, boolean asynchronous) {
        Function function = WinRegistry.get(FUNCTION_NOTIFY_CHANGE_KEY_VALUE);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Bool(watchSubtree), new UInt32((long)notifyFilter), event, new Bool(asynchronous)});
        return result.getValue();
    }

    public static long openKey(Handle key, String subKey, int accessMask, Handle resultKey) {
        Function function = WinRegistry.get(FUNCTION_OPEN_KEY_EX);
        Int result = new Int();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer.Const((Parameter)new Str(subKey), subKey == null), new UInt32(0L), new UInt32((long)accessMask), new Pointer.OutOnly((Parameter)resultKey)});
        return result.getValue();
    }

    public static long overridePredefinedKey(Handle key, Handle newKey) {
        Function function = WinRegistry.get(FUNCTION_OVERRIDE_PREDEF_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)newKey);
        return result.getValue();
    }

    public static long queryInfoKey(Handle key, Str className, UInt32 cClassName, UInt32 subKeys, UInt32 cMaxSubKeyLen, UInt32 cMaxClassLen, UInt32 cValues, UInt32 cMaxValueNameLen, UInt32 cMaxValueLen) {
        Function function = WinRegistry.get(FUNCTION_QUERY_INFO_KEY);
        Int32 result = new Int32();
        function.invoke((Parameter)result, new Parameter[]{key, new Pointer((Parameter)className, className == null), new Pointer((Parameter)cClassName, cClassName == null), new Pointer.Void(), new Pointer((Parameter)subKeys, subKeys == null), new Pointer((Parameter)cMaxSubKeyLen, cMaxSubKeyLen == null), new Pointer((Parameter)cMaxClassLen, cMaxClassLen == null), new Pointer((Parameter)cValues, cValues == null), new Pointer((Parameter)cMaxValueNameLen, cMaxValueNameLen == null), new Pointer((Parameter)cMaxValueLen, cMaxValueLen == null), new Pointer.Void(), new Pointer.Void()});
        return result.getValue();
    }

    public static long replaceKey(Handle key, String subKey, String newFile, String oldFile) {
        Function function = WinRegistry.get(FUNCTION_REPLACE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)new Str(subKey), (Parameter)new Str(newFile), (Parameter)new Str(oldFile));
        return result.getValue();
    }

    public static long restoreKey(Handle key, String file, int flags) {
        Function function = WinRegistry.get(FUNCTION_RESTORE_KEY);
        Int result = new Int();
        function.invoke((Parameter)result, (Parameter)key, (Parameter)new Str(file), (Parameter)new UInt32((long)flags));
        return result.getValue();
    }
}

