/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.Bool;
import com.jniwrapper.util.FlagSet;
import com.jniwrapper.win32.hook.HookEventObject;
import com.jniwrapper.win32.hook.KeyboardHookStruct;

public class LowLevelKeyboardEvent
extends HookEventObject {
    private KeyboardHookStruct _keyboardData;
    private long _messageID;
    private Bool _consume;

    LowLevelKeyboardEvent(Object source, long message, KeyboardHookStruct keyboardData, Bool consume) {
        super(source);
        this._keyboardData = keyboardData;
        this._messageID = message;
        this._consume = consume;
    }

    public long getMessageID() {
        return this._messageID;
    }

    public long getVirtualKeyCode() {
        return this._keyboardData.getVkCode().getValue();
    }

    public long getScanCode() {
        return this._keyboardData.getScanCode().getValue();
    }

    public boolean isExtendedKey() {
        FlagSet flagSet = new FlagSet(this._keyboardData.getFlags().getValue());
        return flagSet.getBit(0);
    }

    public boolean isInjected() {
        FlagSet flagSet = new FlagSet(this._keyboardData.getFlags().getValue());
        return flagSet.getBit(4);
    }

    public boolean isAltPressed() {
        FlagSet flagSet = new FlagSet(this._keyboardData.getFlags().getValue());
        return flagSet.getBit(5);
    }

    public boolean isPressed() {
        FlagSet flagSet = new FlagSet(this._keyboardData.getFlags().getValue());
        return !flagSet.getBit(7);
    }

    public long getTime() {
        return this._keyboardData.getTime().getValue();
    }

    public void consume() {
        this._consume.setValue(true);
    }
}

