/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.hook;

import com.jniwrapper.win32.ui.Wnd;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EventsFilter {
    public static final int MAX_RANGES = 30;
    public static final int MAX_WINDOWS = 10;
    private List ranges = new ArrayList(30);
    private List windows = new ArrayList(10);
    private boolean allowAllEvents = false;
    private boolean allowAllWindows = false;

    public EventsFilter() {
        this.setAllowAllWindows(false);
        this.setAllowAllEvents(false);
    }

    private void addRange(Range range) {
        if (this.ranges.size() == 30) {
            throw new RuntimeException("Reached the limit: 30 of suppored ranges");
        }
        if (this.allowAllEvents) {
            this.ranges.clear();
            this.allowAllEvents = false;
        }
        for (int i = 0; i < this.ranges.size(); ++i) {
            boolean rangesAreOverlapped;
            Range aRange = (Range)this.ranges.get(i);
            boolean bl = rangesAreOverlapped = aRange.overlapsWith(range) || range.overlapsWith(aRange);
            if (!rangesAreOverlapped) continue;
            this.ranges.remove(aRange);
            this.addRange(aRange.concatenate(range));
            return;
        }
        this.ranges.add(range);
        Collections.sort(this.ranges);
    }

    private void removeRange(Range range) {
        for (int i = 0; i < this.ranges.size(); ++i) {
            Range aRange = (Range)this.ranges.get(i);
            boolean rangesAreOverlapped = aRange.overlapsWith(range);
            if (rangesAreOverlapped) {
                this.ranges.remove(aRange);
                Range[] ranges = aRange.detach(range);
                if (ranges != null) {
                    for (int index = 0; index < ranges.length; ++index) {
                        this.addRange(ranges[index]);
                    }
                    return;
                }
            }
            if (!(rangesAreOverlapped = range.overlapsWith(aRange))) continue;
            this.ranges.remove(aRange);
            Collections.sort(this.ranges);
            return;
        }
    }

    public EventsFilter addEvent(int eventID) {
        this.addRange(new Range(eventID));
        return this;
    }

    public EventsFilter removeEvent(int eventID) {
        this.removeRange(new Range(eventID));
        return this;
    }

    public EventsFilter addEvents(int[] eventIDs) {
        if (eventIDs == null) {
            throw new NullPointerException("Invalid eventIDs");
        }
        if (eventIDs.length == 0) {
            return this;
        }
        for (int i = 0; i < eventIDs.length; ++i) {
            this.addEvent(eventIDs[i]);
        }
        return this;
    }

    public EventsFilter removeEvents(int[] eventIDs) {
        if (eventIDs == null) {
            throw new NullPointerException("Invalid eventIDs");
        }
        for (int i = 0; i < eventIDs.length; ++i) {
            this.removeEvent(eventIDs[i]);
        }
        return this;
    }

    public EventsFilter addEventsRange(int lowerBound, int upperBound) {
        this.addRange(new Range(lowerBound, upperBound));
        return this;
    }

    public EventsFilter removeEventsRange(int lowerBound, int upperBound) {
        this.removeRange(new Range(lowerBound, upperBound));
        return this;
    }

    public EventsFilter addKeyboardEventsRange() {
        return this.addEventsRange(256, 264);
    }

    public EventsFilter removeKeyboardEventsRange() {
        return this.removeEventsRange(256, 264);
    }

    public EventsFilter addMouseEventsRange() {
        return this.addEventsRange(512, 522);
    }

    public EventsFilter removeMouseEventsRange() {
        return this.removeEventsRange(512, 522);
    }

    public EventsFilter addWindow(Wnd wnd) {
        return this.addWindow(wnd, false);
    }

    public EventsFilter addWindow(Wnd wnd, boolean listenAllChildWindows) {
        if (this.allowAllWindows) {
            this.windows.clear();
            this.allowAllWindows = false;
        }
        WindowRecord windowRecord = new WindowRecord(wnd, listenAllChildWindows);
        this.windows.add(windowRecord);
        return this;
    }

    public EventsFilter removeWindow(Wnd wnd) {
        this.windows.remove(new WindowRecord(wnd));
        return this;
    }

    public List getRanges() {
        return Collections.unmodifiableList(this.ranges);
    }

    public List getWindows() {
        return Collections.unmodifiableList(this.windows);
    }

    public void setAllowAllWindows(boolean value) {
        if (value) {
            this.removeAllWindows();
            this.addWindow(new Wnd(-1L));
        } else {
            this.removeAllWindows();
        }
        this.allowAllWindows = value;
    }

    public boolean getAllowAllWindows() {
        return this.allowAllWindows;
    }

    public void setAllowAllEvents(boolean value) {
        if (value) {
            this.removeAllEvents();
            this.addEventsRange(1, Integer.MAX_VALUE);
        } else {
            this.removeAllEvents();
        }
        this.allowAllEvents = value;
    }

    public boolean isAllowAllEvents() {
        return this.allowAllEvents;
    }

    public EventsFilter removeAllWindows() {
        this.windows.clear();
        this.allowAllWindows = false;
        return this;
    }

    public EventsFilter removeAllEvents() {
        this.ranges.clear();
        this.allowAllEvents = false;
        return this;
    }

    public static class WindowRecord {
        private Wnd wnd;
        private boolean includeChildWindows;

        WindowRecord(Wnd wnd, boolean includeChildWindows) {
            this.wnd = wnd;
            this.includeChildWindows = includeChildWindows;
        }

        WindowRecord(Wnd wnd) {
            this(wnd, false);
        }

        public Wnd getWnd() {
            return this.wnd;
        }

        public boolean isIncludeChildWindows() {
            return this.includeChildWindows;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof WindowRecord)) {
                return false;
            }
            WindowRecord that = (WindowRecord)o;
            return this.wnd.equals((Object)that.wnd);
        }

        public int hashCode() {
            int result = this.wnd.hashCode();
            result = 31 * result + (this.includeChildWindows ? 1 : 0);
            return result;
        }
    }

    public static final class Range
    implements Comparable {
        private final int lowerBound;
        private final int upperBound;

        Range(int lowerBound, Integer upperBound) {
            if (upperBound < lowerBound) {
                throw new IllegalArgumentException("Upper bound cannot be less than lower bound");
            }
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
        }

        public Range(int lowerBound, int upperBound) {
            this(lowerBound, new Integer(upperBound));
        }

        public Range(int lowerBound) {
            this(lowerBound, new Integer(lowerBound));
        }

        public int getLowerBound() {
            return this.lowerBound;
        }

        public int getUpperBound() {
            return this.upperBound;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Range)) {
                return false;
            }
            Range that = (Range)o;
            return this.lowerBound == that.lowerBound && this.lowerBound == that.lowerBound;
        }

        public int hashCode() {
            int result = this.lowerBound;
            result = 31 * result + this.lowerBound;
            return result;
        }

        public int compareTo(Object o) {
            Range anotherRange = (Range)o;
            return this.getLowerBound() - anotherRange.getLowerBound();
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Range[");
            if (this.getUpperBound() == this.getLowerBound()) {
                buffer.append(this.getLowerBound());
            } else {
                buffer.append(this.getLowerBound()).append("..").append(this.getUpperBound());
            }
            buffer.append(']');
            return buffer.toString();
        }

        private boolean isInRange(int value) {
            int upperBound = this.getUpperBound();
            if (upperBound < Integer.MAX_VALUE) {
                ++upperBound;
            }
            return this.getLowerBound() <= value && value <= upperBound;
        }

        public boolean overlapsWith(Range anotherRange) {
            if (anotherRange == null) {
                throw new NullPointerException("Invalid range");
            }
            int bound = anotherRange.getLowerBound();
            return this.isInRange(bound);
        }

        public Range concatenate(Range anotherRange) {
            if (anotherRange == null) {
                throw new NullPointerException("Invalid range");
            }
            int lowerBound = Math.min(this.getLowerBound(), anotherRange.getLowerBound());
            int upperBownd = Math.max(this.getUpperBound(), anotherRange.getUpperBound());
            return new Range(lowerBound, upperBownd);
        }

        public Range[] detach(Range anotherRange) {
            Range[] result;
            if (anotherRange == null) {
                throw new NullPointerException("Invalid range");
            }
            if (anotherRange.getUpperBound() >= this.getUpperBound()) {
                if (this.getLowerBound() == anotherRange.getLowerBound()) {
                    return null;
                }
                result = new Range[]{new Range(this.getLowerBound(), anotherRange.getLowerBound() - 1)};
            } else {
                result = new Range[]{new Range(this.getLowerBound(), anotherRange.getLowerBound() - 1), new Range(anotherRange.getUpperBound() + 1, this.getUpperBound())};
            }
            return result;
        }
    }
}

