/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32;

import com.jniwrapper.Bool;
import com.jniwrapper.Function;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.UInt32;
import com.jniwrapper.win32.system.Kernel32;

public class Handle
extends Pointer.Void {
    private static final String FUNCTION_CloseHandle = "CloseHandle";
    private static final String FUNCTION_WaitForSingleObject = "WaitForSingleObject";
    public static final int INFINITE_TIMEOUT = -1;
    public static final int STATUS_WAIT_0 = 0;
    public static final int STATUS_ABANDONED_WAIT_0 = 128;
    public static final int STATUS_TIMEOUT = 258;
    public static final int INVALID_HANDLE_VALUE = -1;

    public Handle() {
    }

    public Handle(long value) {
        super(value);
    }

    public Object clone() {
        return new Handle(this.getValue());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Handle)) {
            return false;
        }
        Handle anotherHandle = (Handle)((Object)obj);
        return this.getValue() == anotherHandle.getValue();
    }

    public static long waitFor(Handle handle, long timeout) {
        Function function = Kernel32.getInstance().getFunction(FUNCTION_WaitForSingleObject);
        UInt32 waitStatus = new UInt32();
        function.invoke((Parameter)waitStatus, (Parameter)handle, (Parameter)new UInt32(timeout));
        return waitStatus.getValue();
    }

    public static long waitFor(Handle handle) {
        return Handle.waitFor(handle, -1L);
    }

    public static boolean closeHandle(Handle handle) {
        if (handle == null || handle.isNull()) {
            throw new IllegalArgumentException();
        }
        Function function = Kernel32.getInstance().getFunction(FUNCTION_CloseHandle);
        Bool functionResult = new Bool();
        function.invoke((Parameter)functionResult, (Parameter)handle);
        return functionResult.getValue();
    }
}

