/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;

public class XmlFoldParser
implements FoldParser {
    private static final char[] MARKUP_CLOSING_TAG_START = new char[]{'<', '/'};
    private static final char[] MARKUP_SHORT_TAG_END = new char[]{'/', '>'};
    private static final char[] MLC_END = new char[]{'-', '-', '>'};

    public List getFolds(RSyntaxTextArea rSyntaxTextArea) {
        ArrayList<Fold> arrayList = new ArrayList<Fold>();
        Fold fold = null;
        int n = rSyntaxTextArea.getLineCount();
        boolean bl = false;
        int n2 = 0;
        try {
            for (int i = 0; i < n; ++i) {
                for (Token token = rSyntaxTextArea.getTokenListForLine(i); token != null && token.isPaintable(); token = token.getNextToken()) {
                    if (token.isComment()) {
                        if (bl) {
                            if (!token.endsWith(MLC_END)) continue;
                            int n3 = token.offset + token.textCount - 1;
                            if (fold == null) {
                                fold = new Fold(1, rSyntaxTextArea, n2);
                                fold.setEndOffset(n3);
                                arrayList.add(fold);
                                fold = null;
                            } else {
                                fold = fold.createChild(1, n2);
                                fold.setEndOffset(n3);
                                fold = fold.getParent();
                            }
                            bl = false;
                            n2 = 0;
                            continue;
                        }
                        if (token.type != 2) continue;
                        bl = true;
                        n2 = token.offset;
                        continue;
                    }
                    if (token.type == 25 && token.isSingleChar('<')) {
                        if (fold == null) {
                            fold = new Fold(0, rSyntaxTextArea, token.offset);
                            arrayList.add(fold);
                            continue;
                        }
                        fold = fold.createChild(0, token.offset);
                        continue;
                    }
                    if (token.is(25, MARKUP_SHORT_TAG_END)) {
                        if (fold == null) continue;
                        Fold fold2 = fold.getParent();
                        fold.removeFromParent();
                        fold = fold2;
                        continue;
                    }
                    if (!token.is(25, MARKUP_CLOSING_TAG_START) || fold == null) continue;
                    fold.setEndOffset(token.offset);
                    Fold fold3 = fold.getParent();
                    if (fold.isOnSingleLine()) {
                        fold.removeFromParent();
                    }
                    fold = fold3;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return arrayList;
    }
}

