/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fife.io.UnicodeWriter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenTypes;
import org.fife.ui.rtextarea.Gutter;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Theme {
    private Font baseFont;
    private Color bgColor;
    private Color caretColor;
    private Color selectionBG;
    private boolean selectionRoundedEdges;
    private Color currentLineHighlight;
    private boolean fadeCurrentLineHighlight;
    private Color marginLineColor;
    private Color markAllHighlightColor;
    private Color markOccurrencesColor;
    private Color matchedBracketFG;
    private Color matchedBracketBG;
    private boolean matchedBracketAnimate;
    private Color hyperlinkFG;
    private SyntaxScheme scheme;
    private Color gutterBorderColor;
    private Color lineNumberColor;
    private String lineNumberFont;
    private int lineNumberFontSize;
    private Color foldIndicatorFG;
    private Color foldBG;
    static /* synthetic */ Class class$org$fife$ui$rsyntaxtextarea$Token;

    private Theme() {
    }

    public Theme(RSyntaxTextArea rSyntaxTextArea) {
        this.baseFont = rSyntaxTextArea.getFont();
        this.bgColor = rSyntaxTextArea.getBackground();
        this.caretColor = rSyntaxTextArea.getCaretColor();
        this.selectionBG = rSyntaxTextArea.getSelectionColor();
        this.selectionRoundedEdges = rSyntaxTextArea.getRoundedSelectionEdges();
        this.currentLineHighlight = rSyntaxTextArea.getCurrentLineHighlightColor();
        this.fadeCurrentLineHighlight = rSyntaxTextArea.getFadeCurrentLineHighlight();
        this.marginLineColor = rSyntaxTextArea.getMarginLineColor();
        this.markAllHighlightColor = rSyntaxTextArea.getMarkAllHighlightColor();
        this.markOccurrencesColor = rSyntaxTextArea.getMarkOccurrencesColor();
        this.matchedBracketBG = rSyntaxTextArea.getMatchedBracketBGColor();
        this.matchedBracketFG = rSyntaxTextArea.getMatchedBracketBorderColor();
        this.matchedBracketAnimate = rSyntaxTextArea.getAnimateBracketMatching();
        this.hyperlinkFG = rSyntaxTextArea.getHyperlinkForeground();
        this.scheme = rSyntaxTextArea.getSyntaxScheme();
        Gutter gutter = RSyntaxUtilities.getGutter(rSyntaxTextArea);
        if (gutter != null) {
            this.bgColor = gutter.getBackground();
            this.gutterBorderColor = gutter.getBorderColor();
            this.lineNumberColor = gutter.getLineNumberColor();
            this.lineNumberFont = gutter.getLineNumberFont().getFamily();
            this.lineNumberFontSize = gutter.getLineNumberFont().getSize();
            this.foldIndicatorFG = gutter.getFoldIndicatorForeground();
            this.foldBG = gutter.getFoldBackground();
        }
    }

    public void apply(RSyntaxTextArea rSyntaxTextArea) {
        rSyntaxTextArea.setFont(this.baseFont);
        rSyntaxTextArea.setBackground(this.bgColor);
        rSyntaxTextArea.setCaretColor(this.caretColor);
        rSyntaxTextArea.setSelectionColor(this.selectionBG);
        rSyntaxTextArea.setRoundedSelectionEdges(this.selectionRoundedEdges);
        rSyntaxTextArea.setCurrentLineHighlightColor(this.currentLineHighlight);
        rSyntaxTextArea.setFadeCurrentLineHighlight(this.fadeCurrentLineHighlight);
        rSyntaxTextArea.setMarginLineColor(this.marginLineColor);
        rSyntaxTextArea.setMarkAllHighlightColor(this.markAllHighlightColor);
        rSyntaxTextArea.setMarkOccurrencesColor(this.markOccurrencesColor);
        rSyntaxTextArea.setMatchedBracketBGColor(this.matchedBracketBG);
        rSyntaxTextArea.setMatchedBracketBorderColor(this.matchedBracketFG);
        rSyntaxTextArea.setAnimateBracketMatching(this.matchedBracketAnimate);
        rSyntaxTextArea.setHyperlinkForeground(this.hyperlinkFG);
        rSyntaxTextArea.setSyntaxScheme(this.scheme);
        Gutter gutter = RSyntaxUtilities.getGutter(rSyntaxTextArea);
        if (gutter != null) {
            gutter.setBackground(this.bgColor);
            gutter.setBorderColor(this.gutterBorderColor);
            gutter.setLineNumberColor(this.lineNumberColor);
            String string = this.lineNumberFont != null ? this.lineNumberFont : this.baseFont.getFamily();
            int n = this.lineNumberFontSize > 0 ? this.lineNumberFontSize : this.baseFont.getSize();
            Font font = new Font(string, 0, n);
            gutter.setLineNumberFont(font);
            gutter.setFoldIndicatorForeground(this.foldIndicatorFG);
            gutter.setFoldBackground(this.foldBG);
        }
    }

    private static final String colorToString(Color color) {
        int n = color.getRGB() & 0xFFFFFF;
        String string = Integer.toHexString(n);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Theme load(InputStream inputStream) throws IOException {
        Theme theme = new Theme();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        try {
            XmlHandler.load(theme, bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
        }
        return theme;
    }

    public void save(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        try {
            Object object;
            Object object2;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, "RSyntaxTheme", null);
            Element element = document.getDocumentElement();
            element.setAttribute("version", "1.0");
            Element element2 = document.createElement("baseFont");
            if (!this.baseFont.getFamily().equals(RSyntaxTextArea.getDefaultFont().getFamily())) {
                element2.setAttribute("family", this.baseFont.getFamily());
            }
            element2.setAttribute("size", Integer.toString(this.baseFont.getSize()));
            element.appendChild(element2);
            element2 = document.createElement("background");
            element2.setAttribute("color", Theme.colorToString(this.bgColor));
            element.appendChild(element2);
            element2 = document.createElement("caret");
            element2.setAttribute("color", Theme.colorToString(this.caretColor));
            element.appendChild(element2);
            element2 = document.createElement("selection");
            element2.setAttribute("bg", Theme.colorToString(this.selectionBG));
            element2.setAttribute("roundedEdges", Boolean.toString(this.selectionRoundedEdges));
            element.appendChild(element2);
            element2 = document.createElement("currentLineHighlight");
            element2.setAttribute("color", Theme.colorToString(this.currentLineHighlight));
            element2.setAttribute("fade", Boolean.toString(this.fadeCurrentLineHighlight));
            element.appendChild(element2);
            element2 = document.createElement("marginLine");
            element2.setAttribute("fg", Theme.colorToString(this.marginLineColor));
            element.appendChild(element2);
            element2 = document.createElement("markAllHighlight");
            element2.setAttribute("color", Theme.colorToString(this.markAllHighlightColor));
            element.appendChild(element2);
            element2 = document.createElement("markOccurrencesHighlight");
            element2.setAttribute("color", Theme.colorToString(this.markOccurrencesColor));
            element.appendChild(element2);
            element2 = document.createElement("matchedBracket");
            element2.setAttribute("fg", Theme.colorToString(this.matchedBracketFG));
            element2.setAttribute("bg", Theme.colorToString(this.matchedBracketBG));
            element2.setAttribute("animate", Boolean.toString(this.matchedBracketAnimate));
            element.appendChild(element2);
            element2 = document.createElement("hyperlinks");
            element2.setAttribute("fg", Theme.colorToString(this.hyperlinkFG));
            element.appendChild(element2);
            element2 = document.createElement("gutterBorder");
            element2.setAttribute("color", Theme.colorToString(this.gutterBorderColor));
            element.appendChild(element2);
            element2 = document.createElement("lineNumbers");
            element2.setAttribute("fg", Theme.colorToString(this.lineNumberColor));
            if (this.lineNumberFont != null) {
                element2.setAttribute("lineNumberFont", this.lineNumberFont);
            }
            if (this.lineNumberFontSize > 0) {
                element2.setAttribute("lineNumberFontSize", Integer.toString(this.lineNumberFontSize));
            }
            element.appendChild(element2);
            element2 = document.createElement("foldIndicator");
            element2.setAttribute("fg", Theme.colorToString(this.foldIndicatorFG));
            element2.setAttribute("iconBg", Theme.colorToString(this.foldBG));
            element.appendChild(element2);
            element2 = document.createElement("tokenStyles");
            Field[] fieldArray = TokenTypes.class.getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Font font;
                Color color;
                object2 = fieldArray[i];
                int n = ((Field)object2).getInt(null);
                if (n == 35 || (object = this.scheme.getStyle(n)) == null) continue;
                Element element3 = document.createElement("style");
                element3.setAttribute("token", ((Field)object2).getName());
                Color color2 = ((Style)object).foreground;
                if (color2 != null) {
                    element3.setAttribute("fg", Theme.colorToString(color2));
                }
                if ((color = ((Style)object).background) != null) {
                    element3.setAttribute("bg", Theme.colorToString(color));
                }
                if ((font = ((Style)object).font) != null) {
                    if (!font.getFamily().equals(this.baseFont.getFamily())) {
                        element3.setAttribute("fontFamily", font.getFamily());
                    }
                    if (font.getSize() != this.baseFont.getSize()) {
                        element3.setAttribute("fontSize", Integer.toString(font.getSize()));
                    }
                    if (font.isBold()) {
                        element3.setAttribute("bold", "true");
                    }
                    if (font.isItalic()) {
                        element3.setAttribute("italic", "true");
                    }
                }
                if (((Style)object).underline) {
                    element3.setAttribute("underline", "true");
                }
                element2.appendChild(element3);
            }
            element.appendChild(element2);
            DOMSource dOMSource = new DOMSource(document);
            object2 = new StreamResult(new PrintWriter(new UnicodeWriter(bufferedOutputStream, "UTF-8")));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            object = transformerFactory.newTransformer();
            ((Transformer)object).setOutputProperty("indent", "yes");
            ((Transformer)object).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            ((Transformer)object).setOutputProperty("encoding", "UTF-8");
            ((Transformer)object).setOutputProperty("doctype-system", "theme.dtd");
            ((Transformer)object).transform(dOMSource, (Result)object2);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Error generating XML: " + exception.getMessage());
        }
        finally {
            bufferedOutputStream.close();
        }
    }

    private static final Color stringToColor(String string) {
        if (string != null && (string.length() == 6 || string.length() == 7)) {
            if (string.charAt(0) == '$') {
                string = string.substring(1);
            }
            return new Color(Integer.parseInt(string, 16));
        }
        return null;
    }

    private static class XmlHandler
    extends DefaultHandler {
        private Theme theme;

        private XmlHandler() {
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public static void load(Theme theme, InputStream inputStream) throws IOException {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            try {
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                XmlHandler xmlHandler = new XmlHandler();
                xmlHandler.theme = theme;
                xMLReader.setEntityResolver(xmlHandler);
                xMLReader.setContentHandler(xmlHandler);
                xMLReader.setDTDHandler(xmlHandler);
                xMLReader.setErrorHandler(xmlHandler);
                InputSource inputSource = new InputSource(inputStream);
                inputSource.setEncoding("UTF-8");
                xMLReader.parse(inputSource);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(exception.toString());
            }
        }

        private static final int parseInt(Attributes attributes, String string, int n) {
            int n2 = n;
            String string2 = attributes.getValue(string);
            if (string2 != null) {
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
            return n2;
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException {
            return new InputSource(this.getClass().getResourceAsStream("/theme.dtd"));
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("background".equals(string3)) {
                String string4 = attributes.getValue("color");
                if (string4 != null) {
                    this.theme.bgColor = Theme.stringToColor(string4);
                } else {
                    String string5 = attributes.getValue("image");
                    if (string5 != null) {
                        throw new IllegalArgumentException("Not yet implemented");
                    }
                }
            } else if ("baseFont".equals(string3)) {
                String string6 = attributes.getValue("family");
                int n = Integer.parseInt(attributes.getValue("size"));
                if (string6 != null) {
                    this.theme.baseFont = new Font(string6, 0, n);
                } else {
                    this.theme.baseFont = RSyntaxTextArea.getDefaultFont();
                    this.theme.baseFont = this.theme.baseFont.deriveFont((float)n * 1.0f);
                }
            } else if ("caret".equals(string3)) {
                String string7 = attributes.getValue("color");
                this.theme.caretColor = Theme.stringToColor(string7);
            } else if ("currentLineHighlight".equals(string3)) {
                String string8 = attributes.getValue("color");
                this.theme.currentLineHighlight = Theme.stringToColor(string8);
                String string9 = attributes.getValue("fade");
                boolean bl = Boolean.valueOf(string9);
                this.theme.fadeCurrentLineHighlight = bl;
            } else if ("foldIndicator".equals(string3)) {
                String string10 = attributes.getValue("fg");
                this.theme.foldIndicatorFG = Theme.stringToColor(string10);
                string10 = attributes.getValue("iconBg");
                this.theme.foldBG = Theme.stringToColor(string10);
            } else if ("gutterBorder".equals(string3)) {
                String string11 = attributes.getValue("color");
                this.theme.gutterBorderColor = Theme.stringToColor(string11);
            } else if ("lineNumbers".equals(string3)) {
                String string12 = attributes.getValue("fg");
                this.theme.lineNumberColor = Theme.stringToColor(string12);
                this.theme.lineNumberFont = attributes.getValue("fontFamily");
                this.theme.lineNumberFontSize = XmlHandler.parseInt(attributes, "fontSize", -1);
            } else if ("marginLine".equals(string3)) {
                String string13 = attributes.getValue("fg");
                this.theme.marginLineColor = Theme.stringToColor(string13);
            } else if ("markAllHighlight".equals(string3)) {
                String string14 = attributes.getValue("color");
                this.theme.markAllHighlightColor = Theme.stringToColor(string14);
            } else if ("markOccurrencesHighlight".equals(string3)) {
                String string15 = attributes.getValue("color");
                this.theme.markOccurrencesColor = Theme.stringToColor(string15);
            } else if ("matchedBracket".equals(string3)) {
                String string16 = attributes.getValue("fg");
                this.theme.matchedBracketFG = Theme.stringToColor(string16);
                String string17 = attributes.getValue("bg");
                this.theme.matchedBracketBG = Theme.stringToColor(string17);
                String string18 = attributes.getValue("animate");
                this.theme.matchedBracketAnimate = Boolean.valueOf(string18);
            } else if ("hyperlinks".equals(string3)) {
                String string19 = attributes.getValue("fg");
                this.theme.hyperlinkFG = Theme.stringToColor(string19);
            } else if ("selection".equals(string3)) {
                String string20 = attributes.getValue("bg");
                this.theme.selectionBG = Theme.stringToColor(string20);
                String string21 = attributes.getValue("roundedEdges");
                this.theme.selectionRoundedEdges = Boolean.valueOf(string21);
            } else if ("tokenStyles".equals(string3)) {
                this.theme.scheme = new SyntaxScheme(this.theme.baseFont, false);
            } else if ("style".equals(string3)) {
                String string22 = attributes.getValue("token");
                Field field = null;
                try {
                    field = (class$org$fife$ui$rsyntaxtextarea$Token == null ? (class$org$fife$ui$rsyntaxtextarea$Token = Theme.class$("org.fife.ui.rsyntaxtextarea.Token")) : class$org$fife$ui$rsyntaxtextarea$Token).getField(string22);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    System.err.println("Invalid token type: " + string22);
                    return;
                }
                if (field.getType() == Integer.TYPE) {
                    String string23;
                    String string24;
                    String string25;
                    Color color;
                    Color color2;
                    int n = 0;
                    try {
                        n = field.getInt(this.theme.scheme);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace();
                        return;
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                        return;
                    }
                    String string26 = attributes.getValue("fg");
                    ((Theme)this.theme).scheme.getStyle((int)n).foreground = color2 = Theme.stringToColor(string26);
                    String string27 = attributes.getValue("bg");
                    ((Theme)this.theme).scheme.getStyle((int)n).background = color = Theme.stringToColor(string27);
                    Font font = this.theme.baseFont;
                    String string28 = attributes.getValue("fontFamily");
                    if (string28 != null) {
                        font = new Font(string28, font.getStyle(), font.getSize());
                    }
                    if ((string25 = attributes.getValue("fontSize")) != null) {
                        try {
                            float f = Float.parseFloat(string25);
                            f = Math.max(f, 1.0f);
                            font = font.deriveFont(f);
                        }
                        catch (NumberFormatException numberFormatException) {
                            numberFormatException.printStackTrace();
                        }
                    }
                    ((Theme)this.theme).scheme.getStyle((int)n).font = font;
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String string29 = attributes.getValue("bold");
                    if (string29 != null) {
                        bl2 = Boolean.valueOf(string29);
                        bl = true;
                    }
                    if ((string24 = attributes.getValue("italic")) != null) {
                        bl3 = Boolean.valueOf(string24);
                        bl = true;
                    }
                    if (bl) {
                        int n2 = 0;
                        if (bl2) {
                            n2 |= 1;
                        }
                        if (bl3) {
                            n2 |= 2;
                        }
                        Font font2 = ((Theme)this.theme).scheme.getStyle((int)n).font;
                        ((Theme)this.theme).scheme.getStyle((int)n).font = font2.deriveFont(n2);
                    }
                    if ((string23 = attributes.getValue("underline")) != null) {
                        boolean bl4;
                        ((Theme)this.theme).scheme.getStyle((int)n).underline = bl4 = Boolean.valueOf(string23).booleanValue();
                    }
                }
            }
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

