/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.support.ExtensionFileFilter;
import com.eviware.x.dialogs.XFileDialogs;
import com.l2fprod.common.swing.JDirectoryChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;

public class SwingFileDialogs
implements XFileDialogs {
    private static Component parent;
    private static Map<Object, JFileChooser> choosers;

    public SwingFileDialogs(Component parent) {
        SwingFileDialogs.parent = parent;
    }

    public static synchronized JFileChooser getChooser(Object action) {
        action = null;
        JFileChooser chooser = choosers.get(action);
        if (chooser == null) {
            chooser = new JFileChooser();
            choosers.put(action, chooser);
        }
        chooser.resetChoosableFileFilters();
        return chooser;
    }

    public static Component getParent() {
        return parent;
    }

    public File saveAs(Object action, String title) {
        return this.saveAs(action, title, null, null, null);
    }

    public File saveAs(Object action, String title, String extension, String fileType, File defaultFile) {
        JFileChooser chooser = SwingFileDialogs.getChooser(action);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(title);
        chooser.setAcceptAllFileFilterUsed(true);
        if (extension != null && fileType != null) {
            chooser.setFileFilter(new ExtensionFileFilter(extension, fileType));
        } else {
            chooser.setFileFilter(null);
        }
        if (defaultFile != null) {
            chooser.setSelectedFile(defaultFile);
        } else {
            chooser.setSelectedFile(null);
        }
        if (chooser.showSaveDialog(SwingFileDialogs.getParent()) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public File open(Object action, String title, String extension, String fileType, String current) {
        return SwingFileDialogs.openFile(action, title, extension, fileType, current);
    }

    public static File openFile(Object action, String title, String extension, String fileType, String current) {
        JFileChooser chooser = SwingFileDialogs.getChooser(action);
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(title);
        chooser.setAcceptAllFileFilterUsed(true);
        if (current != null) {
            File file = new File(current);
            if (file.isDirectory()) {
                chooser.setCurrentDirectory(file);
            } else {
                chooser.setSelectedFile(file);
            }
        } else {
            chooser.setSelectedFile(null);
        }
        if (extension != null && fileType != null) {
            chooser.setFileFilter(new ExtensionFileFilter(extension, fileType));
        } else {
            chooser.setFileFilter(null);
        }
        if (chooser.showOpenDialog(SwingFileDialogs.getParent()) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public File openXML(Object action, String title) {
        return this.open(action, title, ".xml", "XML Files (*.xml)", null);
    }

    public File openDirectory(Object action, String title, File defaultDirectory) {
        JDirectoryChooser chooser = new JDirectoryChooser(defaultDirectory);
        chooser.setDialogTitle(title);
        chooser.setShowingCreateDirectory(true);
        chooser.setPreferredSize(new Dimension(400, 400));
        if (chooser.showSaveDialog(SwingFileDialogs.getParent()) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public File openFileOrDirectory(Object action, String title, File defaultDirectory) {
        JFileChooser chooser = SwingFileDialogs.getChooser(action);
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(2);
        if (defaultDirectory != null) {
            chooser.setCurrentDirectory(defaultDirectory);
        }
        if (chooser.showOpenDialog(SwingFileDialogs.getParent()) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    public File saveAsDirectory(Object action, String title, File defaultDirectory) {
        JDirectoryChooser chooser = new JDirectoryChooser(defaultDirectory);
        chooser.setDialogTitle(title);
        chooser.setShowingCreateDirectory(true);
        chooser.setAcceptAllFileFilterUsed(true);
        if (chooser.showSaveDialog(SwingFileDialogs.getParent()) != 0) {
            return null;
        }
        return chooser.getSelectedFile();
    }

    static {
        choosers = new HashMap<Object, JFileChooser>();
    }
}

