/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.impl.swing;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.actions.UpdateableAction;
import com.eviware.soapui.support.DescriptionPanel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.swing.DefaultActionList;
import com.eviware.soapui.support.components.JButtonBar;
import com.eviware.soapui.support.swing.ModalFrameUtil;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.WizardPage;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormField;
import com.eviware.x.impl.swing.SwingXFormDialog;
import com.eviware.x.impl.swing.SwingXFormImpl;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JWizardDialog
extends SwingXFormDialog {
    private String name;
    private ArrayList<String> pageNames = new ArrayList();
    private JFrame dialog;
    private DescriptionPanel descriptionPanel;
    private List<SwingXFormImpl> forms = new ArrayList<SwingXFormImpl>();
    private JPanel pages;
    private CardLayout cardLayout;
    private HashMap<String, WizardPage> controllers = new HashMap();
    private int currentPage = 0;
    private DefaultActionList actions;
    private JButtonBar buttons;

    public JWizardDialog(String name, XForm[] forms, Action helpAction, String description, ImageIcon icon) {
        this.name = name;
        this.dialog = new JFrame(name);
        this.initActions(helpAction);
        this.cardLayout = new CardLayout();
        this.pages = new JPanel(this.cardLayout);
        for (XForm form : forms) {
            SwingXFormImpl swingFormImpl = (SwingXFormImpl)form;
            this.forms.add(swingFormImpl);
            JPanel panel = swingFormImpl.getPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.addPage(form.getName(), panel);
        }
        this.buttons = UISupport.initFrameActions(this.actions, this.dialog);
        if (description != null || icon != null) {
            this.descriptionPanel = UISupport.buildDescription(name, description, icon);
            this.dialog.getContentPane().add((Component)this.descriptionPanel, "North");
        }
        this.dialog.getContentPane().add((Component)this.pages, "Center");
        this.buttons.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.dialog.getContentPane().add((Component)this.buttons, "South");
        this.dialog.pack();
    }

    public XForm[] getForms() {
        ArrayList<XForm> result = new ArrayList<XForm>();
        for (XForm xForm : this.forms) {
            result.add(xForm);
        }
        return result.toArray(new XForm[result.size()]);
    }

    public void dispose() {
        this.dialog.dispose();
    }

    private void initActions(Action helpAction) {
        this.actions = new DefaultActionList();
        this.actions.addAction(new BackAction());
        this.actions.addAction(new NextAction());
        this.actions.addAction(new CancelAction());
        this.actions.addAction(new FinishAction());
        if (helpAction != null) {
            this.actions.addAction(helpAction);
        }
    }

    public void addAction(Action action) {
        DefaultActionList actions = new DefaultActionList();
        actions.addAction(action);
        this.buttons.addActions(actions);
    }

    private void addPage(String name, JComponent component) {
        this.pages.add((Component)component, name);
        if (!this.pageNames.contains(name)) {
            this.pageNames.add(name);
        }
        this.actions.update();
    }

    public void addPageController(WizardPage controller) {
        this.controllers.put(controller.getName(), controller);
    }

    public void addPageAndController(JComponent component, WizardPage controller) {
        this.addPage(controller.getName(), component);
        this.addPageController(controller);
    }

    public void setValues(StringToStringMap values) {
        for (XForm xForm : this.forms) {
            xForm.setValues(values);
        }
    }

    public void setOptions(String field, Object[] options) {
        for (XForm xForm : this.forms) {
            xForm.setOptions(field, options);
        }
    }

    public XFormField getFormField(String name) {
        for (XForm xForm : this.forms) {
            XFormField formField = xForm.getFormField(name);
            if (formField == null) continue;
            return formField;
        }
        return null;
    }

    public StringToStringMap getValues() {
        StringToStringMap result = new StringToStringMap();
        for (XForm xForm : this.forms) {
            result.putAll(xForm.getValues());
        }
        return result;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.showPage(0)) {
                Frame mainFrame = UISupport.getMainFrame();
                UISupport.centerDialog(this.dialog, mainFrame);
                ModalFrameUtil.showAsModal(this.dialog, mainFrame);
            }
        } else {
            this.dialog.setVisible(visible);
        }
    }

    public boolean validate() {
        return true;
    }

    public void setFormFieldProperty(String name, Object value) {
        for (XForm xForm : this.forms) {
            xForm.setFormFieldProperty(name, value);
        }
    }

    public String getValue(String field) {
        for (XForm xForm : this.forms) {
            if (xForm.getComponent(field) == null) continue;
            return xForm.getComponent(field).getValue();
        }
        return null;
    }

    public void setValue(String field, String value) {
        for (XForm xForm : this.forms) {
            if (xForm.getComponent(field) == null) continue;
            xForm.getComponent(field).setValue(value);
        }
    }

    public int getValueIndex(String name) {
        for (SwingXFormImpl form : this.forms) {
            if (form.getComponent(name) == null) continue;
            Object[] options = form.getOptions(name);
            if (options == null) {
                return -1;
            }
            return Arrays.asList(options).indexOf(form.getComponentValue(name));
        }
        return -1;
    }

    public boolean show() {
        this.setReturnValue(2);
        this.show(new StringToStringMap());
        return this.getReturnValue() == 1;
    }

    public void setWidth(int i) {
        this.dialog.setPreferredSize(new Dimension(i, (int)this.dialog.getPreferredSize().getHeight()));
    }

    public void setSize(int w, int h) {
        this.dialog.setSize(w, h);
    }

    private boolean showPage(int pageNo) {
        this.currentPage = pageNo;
        String pageName = this.pageNames.get(this.currentPage);
        WizardPage page = this.controllers.get(pageName);
        this.descriptionPanel.setTitle(page.getName());
        this.descriptionPanel.setDescription(page.getDescription());
        this.cardLayout.show(this.pages, pageName);
        if (this.initPage(pageName, page)) {
            this.actions.update();
            return true;
        }
        this.setVisible(false);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initPage(String pageName, WizardPage page) {
        boolean bl;
        try {
            this.dialog.setCursor(Cursor.getPredefinedCursor(3));
            bl = page.init();
            Object var6_5 = null;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                this.dialog.setCursor(Cursor.getDefaultCursor());
                SoapUI.logError(e);
                UISupport.showInfoMessage(pageName + " could not be initialized", this.name);
                bl2 = false;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.dialog.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
            this.dialog.setCursor(Cursor.getDefaultCursor());
            return bl2;
        }
        this.dialog.setCursor(Cursor.getDefaultCursor());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runCurrentPage() {
        boolean bl;
        String pageName = this.pageNames.get(this.currentPage);
        WizardPage controller = this.controllers.get(pageName);
        try {
            this.dialog.setCursor(Cursor.getPredefinedCursor(3));
            bl = controller.run();
            Object var6_5 = null;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                this.dialog.setCursor(Cursor.getDefaultCursor());
                SoapUI.logError(e);
                UISupport.showInfoMessage(pageName + " failed", this.name);
                bl2 = false;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.dialog.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
            this.dialog.setCursor(Cursor.getDefaultCursor());
            return bl2;
        }
        this.dialog.setCursor(Cursor.getDefaultCursor());
        return bl;
    }

    public void release() {
        this.dialog.dispose();
    }

    private final class FinishAction
    extends AbstractAction
    implements UpdateableAction {
        public FinishAction() {
            super("Finish");
        }

        public void update() {
            this.setEnabled(JWizardDialog.this.currentPage == JWizardDialog.this.pageNames.size() - 1);
        }

        public void actionPerformed(ActionEvent e) {
            JWizardDialog.this.runCurrentPage();
            JWizardDialog.this.setReturnValue(1);
            JWizardDialog.this.setVisible(false);
        }
    }

    private final class CancelAction
    extends AbstractAction
    implements UpdateableAction {
        public CancelAction() {
            super("Cancel");
        }

        public void update() {
        }

        public void actionPerformed(ActionEvent e) {
            JWizardDialog.this.setReturnValue(2);
            JWizardDialog.this.setVisible(false);
        }
    }

    private class NextAction
    extends AbstractAction
    implements UpdateableAction {
        public NextAction() {
            super("Next >");
        }

        public void update() {
            this.setEnabled(JWizardDialog.this.currentPage + 1 < JWizardDialog.this.pageNames.size());
        }

        public void actionPerformed(ActionEvent evt) {
            if (JWizardDialog.this.runCurrentPage()) {
                JWizardDialog.this.showPage(JWizardDialog.this.currentPage + 1);
            } else {
                JWizardDialog.this.setVisible(false);
            }
        }
    }

    private class BackAction
    extends AbstractAction
    implements UpdateableAction {
        public BackAction() {
            super("< Back");
        }

        public void update() {
            boolean enable = false;
            if (JWizardDialog.this.currentPage > 0) {
                String pageName = (String)JWizardDialog.this.pageNames.get(JWizardDialog.this.currentPage - 1);
                WizardPage prevPage = (WizardPage)JWizardDialog.this.controllers.get(pageName);
                enable = prevPage.canGoBack();
            }
            this.setEnabled(enable);
        }

        public void actionPerformed(ActionEvent e) {
            JWizardDialog.this.showPage(JWizardDialog.this.currentPage - 1);
        }
    }
}

