/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.x.form;

import com.eviware.x.form.ComponentEnabler;
import com.eviware.x.form.ValidationMessage;
import com.eviware.x.form.XFormField;
import com.eviware.x.form.XFormFieldListener;
import com.eviware.x.form.XFormFieldValidator;
import com.eviware.x.form.validators.RequiredValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXFormField<T>
implements XFormField {
    private Set<XFormFieldListener> listeners;
    private List<XFormFieldValidator> validators;
    private RequiredValidator requiredValidator;
    private ComponentEnabler enabler = null;

    @Override
    public boolean isVisible() {
        return true;
    }

    public abstract T getComponent();

    @Override
    public void addFormFieldListener(XFormFieldListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashSet<XFormFieldListener>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void addFormFieldValidator(XFormFieldValidator validator) {
        if (this.validators == null) {
            this.validators = new ArrayList<XFormFieldValidator>();
        }
        this.validators.add(validator);
    }

    @Override
    public void addComponentEnabler(XFormField tf, String value) {
        if (this.enabler == null) {
            this.enabler = new ComponentEnabler(this);
        }
        this.enabler.add(tf, value);
    }

    @Override
    public boolean isRequired() {
        return this.requiredValidator != null;
    }

    @Override
    public void removeFieldListener(XFormFieldListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void removeFormFieldValidator(XFormFieldValidator validator) {
        if (this.validators != null) {
            this.validators.remove(validator);
        }
    }

    @Override
    public void setRequired(boolean required, String message) {
        if (this.requiredValidator != null) {
            this.removeFormFieldValidator(this.requiredValidator);
        }
        if (required) {
            this.requiredValidator = new RequiredValidator(message);
            this.addFormFieldValidator(this.requiredValidator);
        }
    }

    @Override
    public ValidationMessage[] validate() {
        if (this.validators == null || this.validators.isEmpty()) {
            return null;
        }
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (XFormFieldValidator validator : this.validators) {
            ValidationMessage[] validateField = validator.validateField(this);
            if (validateField == null || validateField.length <= 0) continue;
            messages.addAll(Arrays.asList(validateField));
        }
        return messages.toArray(new ValidationMessage[messages.size()]);
    }

    protected void fireValueChanged(String newValue, String oldValue) {
        if (this.listeners == null) {
            return;
        }
        for (XFormFieldListener listener : this.listeners) {
            listener.valueChanged(this, newValue, oldValue);
        }
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public abstract void setProperty(String var1, Object var2);

    public boolean isMultiRow() {
        return false;
    }
}

