/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.ui.support;

import com.eviware.soapui.support.UISupport;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public class FindAndReplaceDialogView
extends AbstractAction {
    private JDialog dialog;
    private JCheckBox caseCheck;
    private JRadioButton allButton;
    private JRadioButton selectedLinesButton;
    private JRadioButton forwardButton;
    private JRadioButton backwardButton;
    private JCheckBox wholeWordCheck;
    private JButton findButton;
    private JButton replaceButton;
    private JButton replaceAllButton;
    private JComboBox findCombo;
    private JComboBox replaceCombo;
    private JCheckBox wrapCheck;
    private RSyntaxTextArea editArea;

    public FindAndReplaceDialogView(RSyntaxTextArea editArea) {
        super("Find / Replace");
        if (UISupport.isMac()) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("meta F"));
        } else {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("control F"));
        }
        this.editArea = editArea;
    }

    public void actionPerformed(ActionEvent arg0) {
        this.show();
    }

    public void show() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.editArea.requestFocusInWindow();
        this.replaceCombo.setEnabled(this.editArea.isEditable());
        this.replaceAllButton.setEnabled(this.editArea.isEditable());
        this.replaceButton.setEnabled(this.editArea.isEditable());
        UISupport.showDialog(this.dialog);
        this.findCombo.getEditor().selectAll();
        this.findCombo.requestFocus();
    }

    private void buildDialog() {
        Window window = SwingUtilities.windowForComponent((Component)this.editArea);
        this.dialog = new JDialog(window, "Find / Replace");
        this.dialog.setModal(false);
        JPanel panel = new JPanel(new BorderLayout());
        this.findCombo = new JComboBox();
        this.findCombo.setEditable(true);
        this.replaceCombo = new JComboBox();
        this.replaceCombo.setEditable(true);
        GridLayout gridLayout = new GridLayout(2, 2);
        gridLayout.setVgap(5);
        JPanel inputPanel = new JPanel(gridLayout);
        inputPanel.add(new JLabel("Find:"));
        inputPanel.add(this.findCombo);
        inputPanel.add(new JLabel("Replace with:"));
        inputPanel.add(this.replaceCombo);
        inputPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        ButtonGroup directionGroup = new ButtonGroup();
        this.forwardButton = new JRadioButton("Forward", true);
        this.forwardButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        directionGroup.add(this.forwardButton);
        this.backwardButton = new JRadioButton("Backward");
        this.backwardButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        directionGroup.add(this.backwardButton);
        JPanel directionPanel = new JPanel(new GridLayout(2, 1));
        directionPanel.add(this.forwardButton);
        directionPanel.add(this.backwardButton);
        directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        ButtonGroup scopeGroup = new ButtonGroup();
        this.allButton = new JRadioButton("All", true);
        this.allButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.selectedLinesButton = new JRadioButton("Selected Lines");
        this.selectedLinesButton.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        scopeGroup.add(this.allButton);
        scopeGroup.add(this.selectedLinesButton);
        JPanel scopePanel = new JPanel(new GridLayout(2, 1));
        scopePanel.add(this.allButton);
        scopePanel.add(this.selectedLinesButton);
        scopePanel.setBorder(BorderFactory.createTitledBorder("Scope"));
        this.caseCheck = new JCheckBox("Case Sensitive");
        this.caseCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.wholeWordCheck = new JCheckBox("Whole Word");
        this.wholeWordCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.wrapCheck = new JCheckBox("Wrap Search");
        this.wrapCheck.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JPanel optionsPanel = new JPanel(new GridLayout(3, 1));
        optionsPanel.add(this.caseCheck);
        optionsPanel.add(this.wholeWordCheck);
        optionsPanel.add(this.wrapCheck);
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        JPanel options = new JPanel(new GridLayout(1, 2));
        JPanel radios = new JPanel(new GridLayout(2, 1));
        radios.add(directionPanel);
        radios.add(scopePanel);
        options.add(optionsPanel);
        options.add(radios);
        options.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        ButtonBarBuilder builder = new ButtonBarBuilder();
        this.findButton = new JButton(new FindAction(this.findCombo));
        builder.addFixed((JComponent)this.findButton);
        builder.addRelatedGap();
        this.replaceButton = new JButton(new ReplaceAction());
        builder.addFixed((JComponent)this.replaceButton);
        builder.addRelatedGap();
        this.replaceAllButton = new JButton(new ReplaceAllAction());
        builder.addFixed((JComponent)this.replaceAllButton);
        builder.addUnrelatedGap();
        builder.addFixed((JComponent)new JButton(new CloseAction(this.dialog)));
        builder.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.add((Component)inputPanel, "North");
        panel.add((Component)options, "Center");
        panel.add((Component)builder.getPanel(), "South");
        this.dialog.getContentPane().add(panel);
        this.dialog.pack();
        UISupport.initDialogActions(this.dialog, null, this.findButton);
    }

    protected SearchContext createSearchAndReplaceContext() {
        if (this.findCombo.getSelectedItem() == null) {
            return null;
        }
        if (this.replaceCombo.getSelectedItem() == null) {
            return null;
        }
        String searchExpression = this.findCombo.getSelectedItem().toString();
        String replacement = this.replaceCombo.getSelectedItem().toString();
        SearchContext context = new SearchContext();
        context.setSearchFor(searchExpression);
        context.setReplaceWith(replacement);
        context.setRegularExpression(false);
        context.setSearchForward(this.forwardButton.isSelected());
        context.setWholeWord(this.wholeWordCheck.isSelected());
        return context;
    }

    protected SearchContext createSearchContext() {
        if (this.findCombo.getSelectedItem() == null) {
            return null;
        }
        String searchExpression = this.findCombo.getSelectedItem().toString();
        SearchContext context = new SearchContext();
        context.setSearchFor(searchExpression);
        context.setRegularExpression(false);
        context.setSearchForward(this.forwardButton.isSelected());
        context.setWholeWord(this.wholeWordCheck.isSelected());
        return context;
    }

    private class CloseAction
    extends AbstractAction {
        final JDialog dialog;

        public CloseAction(JDialog d) {
            super("Close");
            this.dialog = d;
        }

        public void actionPerformed(ActionEvent e) {
            this.dialog.setVisible(false);
        }
    }

    private class ReplaceAllAction
    extends AbstractAction {
        public ReplaceAllAction() {
            super("Replace All");
        }

        public void actionPerformed(ActionEvent e) {
            SearchContext context = FindAndReplaceDialogView.this.createSearchAndReplaceContext();
            if (context == null) {
                return;
            }
            int replaceCount = SearchEngine.replaceAll((RTextArea)FindAndReplaceDialogView.this.editArea, (SearchContext)context);
            if (replaceCount <= 0) {
                UISupport.showErrorMessage("String [" + context.getSearchFor() + "] not found");
            }
        }
    }

    private class ReplaceAction
    extends AbstractAction {
        public ReplaceAction() {
            super("Replace/Replace Next");
        }

        public void actionPerformed(ActionEvent e) {
            SearchContext context = FindAndReplaceDialogView.this.createSearchAndReplaceContext();
            if (context == null) {
                return;
            }
            boolean found = SearchEngine.replace((RTextArea)FindAndReplaceDialogView.this.editArea, (SearchContext)context);
            if (!found) {
                UISupport.showErrorMessage("String [" + context.getSearchFor() + "] not found");
            }
        }
    }

    private class FindAction
    extends AbstractAction {
        public FindAction(JComboBox findCombo) {
            super("Find/Find Next");
        }

        public void actionPerformed(ActionEvent e) {
            SearchContext context = FindAndReplaceDialogView.this.createSearchContext();
            if (context == null) {
                return;
            }
            boolean found = SearchEngine.find((JTextArea)FindAndReplaceDialogView.this.editArea, (SearchContext)context);
            if (!found) {
                UISupport.showErrorMessage("String [" + context.getSearchFor() + "] not found");
            }
        }
    }
}

