/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml.actions;

import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class LoadXmlTextAreaAction
extends AbstractAction {
    private final RSyntaxTextArea textArea;
    private String dialogTitle;

    public LoadXmlTextAreaAction(RSyntaxTextArea textArea, String dialogTitle) {
        super("Load from..");
        this.textArea = textArea;
        this.dialogTitle = dialogTitle;
        if (UISupport.isMac()) {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("meta L"));
        } else {
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("ctrl L"));
        }
    }

    public void actionPerformed(ActionEvent e) {
        File file = UISupport.getFileDialogs().open(this, this.dialogTitle, ".xml", "XML Files (*.xml)", null);
        if (file == null) {
            return;
        }
        try {
            this.textArea.setText(Tools.readAll(new FileInputStream(file), 0L).toString());
        }
        catch (IOException e1) {
            UISupport.showErrorMessage("Error loading xml from file: " + e1.getMessage());
        }
    }
}

