/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.xml;

import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XPathModifier;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathData {
    private StringToStringMap nsMap = new StringToStringMap();
    private List<String> pathComponents = new ArrayList<String>();
    private String function;
    private boolean absolute = false;

    public XPathData(StringToStringMap nsMap, List<String> pathComponents, boolean absolute) {
        this.nsMap = nsMap;
        this.pathComponents = pathComponents;
        this.absolute = absolute;
    }

    public XPathData(String xpath, boolean skipFirst) {
        try {
            String s;
            LineNumberReader reader = new LineNumberReader(new StringReader(xpath.trim()));
            while ((s = reader.readLine()) != null) {
                int firstWord;
                String[] words;
                if (s.startsWith("declare namespace ")) {
                    words = s.substring("declare namespace ".length()).split("=");
                    String prefix = words[0];
                    int ix1 = words[1].indexOf(39);
                    int ix2 = words[1].lastIndexOf(39);
                    String ns = words[1].substring(ix1 + 1, ix2 - ix1);
                    this.nsMap.put(ns, prefix);
                    continue;
                }
                if (s.startsWith("count(") && s.endsWith(")")) {
                    this.function = "count";
                    s = s.substring("count(".length(), s.length() - ")".length());
                } else if (s.startsWith("exists(") && s.endsWith(")")) {
                    this.function = "exists";
                    s = s.substring("exists(".length(), s.length() - ")".length());
                }
                words = s.split("/");
                for (int i = firstWord = 1 + (skipFirst ? 1 : 0); i < words.length; ++i) {
                    this.pathComponents.add(0, words[i]);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void strip() {
        if (this.pathComponents.size() > 0 && "text()".equals(this.pathComponents.get(0))) {
            this.pathComponents.remove(0);
        }
        for (int i1 = 0; i1 < this.pathComponents.size(); ++i1) {
            String s = this.pathComponents.get(i1);
            if (s.indexOf(91) < 0) continue;
            StringBuffer buf = new StringBuffer();
            boolean skip = false;
            for (int i2 = 0; i2 < s.length(); ++i2) {
                char ch = s.charAt(i2);
                if (ch == '[') {
                    skip = true;
                }
                if (!skip) {
                    buf.append(ch);
                }
                if (ch != ']') continue;
                skip = false;
            }
            s = buf.toString();
            this.pathComponents.set(i1, s);
        }
        this.function = null;
    }

    public XPathData createParent() {
        if (this.pathComponents.isEmpty()) {
            return null;
        }
        StringToStringMap nsMap2 = new StringToStringMap(this.nsMap);
        ArrayList<String> pathComponents2 = new ArrayList<String>(this.pathComponents);
        pathComponents2.remove(0);
        return new XPathData(nsMap2, pathComponents2, this.absolute);
    }

    public String toString() {
        return this.getShortPath();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != XPathData.class) {
            return false;
        }
        XPathData other = (XPathData)obj;
        return this.getHashKey().equals(other.getHashKey());
    }

    public int hashCode() {
        return this.getHashKey().hashCode();
    }

    public String getHashKey() {
        return this.getCanonicalPath();
    }

    public StringToStringMap getNamespaceMap() {
        return this.nsMap;
    }

    public List<String> getPathComponents() {
        return this.pathComponents;
    }

    public boolean isAttribute() {
        if (this.pathComponents.isEmpty()) {
            return false;
        }
        String c = this.pathComponents.get(0);
        return c.startsWith("@");
    }

    public String getAttributeName() {
        String c = this.pathComponents.get(0);
        return c.substring(1);
    }

    public String getFunction() {
        return this.function;
    }

    public String getXPath() {
        return this.buildXPath(null);
    }

    public String getFullPath() {
        return this.buildXPath(null);
    }

    public String buildXPath(XPathModifier modifier) {
        StringBuffer xpath = new StringBuffer();
        for (String ns : this.nsMap.keySet()) {
            xpath.append("declare namespace " + (String)this.nsMap.get(ns) + "='" + ns + "';\n");
        }
        if (this.function != null) {
            xpath.append(this.function).append("(");
        }
        if (modifier != null) {
            modifier.beforeSelector(xpath);
        }
        String firstComponent = "";
        if (this.pathComponents.size() > 0) {
            firstComponent = this.pathComponents.get(this.pathComponents.size() - 1);
        }
        if (!this.absolute && !"".equals(firstComponent)) {
            xpath.append("/");
        }
        for (int c = this.pathComponents.size() - 1; c >= 0; --c) {
            xpath.append("/").append(this.pathComponents.get(c));
        }
        if (modifier != null) {
            modifier.afterSelector(xpath);
        }
        if (this.function != null) {
            xpath.append(")");
        }
        return xpath.toString();
    }

    public String getPath() {
        StringBuffer buf = new StringBuffer();
        buf.append("/");
        for (int c = this.pathComponents.size() - 1; c >= 0; --c) {
            buf.append("/").append(this.pathComponents.get(c));
        }
        return buf.toString();
    }

    public String getCanonicalPath() {
        HashMap<String, String> inverseNsMap = new HashMap<String, String>();
        for (String key : this.nsMap.keySet()) {
            String value = (String)this.nsMap.get(key);
            inverseNsMap.put(value, key);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("/");
        for (int c = this.pathComponents.size() - 1; c >= 0; --c) {
            buf.append("/");
            String s = this.pathComponents.get(c);
            String[] words = s.split(":");
            if (words.length == 2) {
                String ns = (String)inverseNsMap.get(words[0]);
                if (ns != null) {
                    buf.append(ns).append(":").append(words[1]);
                    continue;
                }
                buf.append(s);
                continue;
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public String getShortPath() {
        StringBuffer buf = new StringBuffer();
        buf.append("/");
        for (int c = this.pathComponents.size() - 1; c >= 0; --c) {
            buf.append("/");
            String s = this.pathComponents.get(c);
            String[] words = s.split(":");
            if (words.length == 2) {
                buf.append(words[1]);
                continue;
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public Collection<String> getNamespaces() {
        return this.nsMap.keySet();
    }

    public boolean hasNamespaces() {
        return this.nsMap != null && !this.nsMap.isEmpty();
    }
}

