/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.scripting.groovy;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineFactory;
import com.eviware.soapui.support.scripting.SoapUIScriptGenerator;
import com.eviware.soapui.support.scripting.groovy.SoapUIGroovyScriptEngine;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XPathData;

public class GroovyScriptEngineFactory
implements SoapUIScriptEngineFactory,
SoapUIScriptGenerator {
    public static final String ID = "Groovy";

    public SoapUIScriptEngine createScriptEngine(ModelItem modelItem) {
        return new SoapUIGroovyScriptEngine(SoapUI.getSoapUICore().getExtensionClassLoader());
    }

    public SoapUIScriptGenerator createCodeGenerator(ModelItem modelItem) {
        return this;
    }

    public String createContextExpansion(String name, PropertyExpansion expansion) {
        String exp = expansion.toString();
        StringBuffer buf = new StringBuffer();
        for (int c = 0; c < exp.length(); ++c) {
            char ch = exp.charAt(c);
            switch (ch) {
                case '\'': 
                case '\\': {
                    buf.append('\\');
                }
            }
            buf.append(ch);
        }
        return "def " + name + " = context.expand( '" + buf.toString() + "' )\n";
    }

    public String createScriptAssertionForExists(XPathData xpathData) {
        String script = "import com.eviware.soapui.support.XmlHolder\n\ndef holder = new XmlHolder( messageExchange.responseContentAsXml )\n";
        StringToStringMap nsMap = xpathData.getNamespaceMap();
        for (String ns : nsMap.keySet()) {
            script = script + "holder.namespaces[\"" + (String)nsMap.get(ns) + "\"] = \"" + ns + "\"\n";
        }
        script = script + "def node = holder.getDomNode( \"" + xpathData.getPath() + "\" )\n";
        script = script + "\nassert node != null\n";
        return script;
    }
}

